### R code from vignette source 'stepwiseCM.Rnw'

###################################################
### code chunk number 1: chunk1
###################################################
# load the full Central Nervous System cancer data 
library(stepwiseCM)
data(CNS)


###################################################
### code chunk number 2: chunk2
###################################################
# gain the prediction labels of the training set
data(CNS)
attach(CNS)
#Note that columns of the train set should corresponding the sample and rows
#corresponding the feature.
train.exp <- mrna[, 1:30]
train.cli <- t(cli[1:30, ])
train.label <- class[1:30]
test.exp <- mrna[, 31:60]
test.cli <- t(cli[31:60, ])
pred.exp <- Classifier(train=train.cli, test=test.cli, train.label=train.label, 
                       type="RF", CVtype="k-fold", outerkfold=2, innerkfold=2)
pred.cli <- Classifier(train=train.exp, test=test.exp, train.label=train.label, 
                       type="plsrf_x", CVtype="k-fold", outerkfold=2, innerkfold=2)
# Classification accuracy of the training set from clinical data is:
sum(pred.cli$P.train == train.label)/length(train.label)
# Classification Accuracy of the training set from expression data is:
sum(pred.exp$P.train == train.label)/length(train.label)


###################################################
### code chunk number 3: chunk3
###################################################
train.exp <- mrna[, 1:40]
train.cli <- t(cli[1:40, ])
train.label <- class[1:40]
test.cli <- t(cli[41:60, ])
prox <- Proximity(train.cli=train.cli, train.label=train.label, test.cli=test.cli, 
                  train.gen=train.exp, N = 2)
prox1 <- Proximity(train.cli=train.cli, train.label=train.label, test.cli=test.cli, 
                  train.gen=train.cli, N = 2)
#check the range of proximity values from two different data types                                     
par(mfrow=c(1,2))
plot(sort(prox1$Prox.gen[1, ][-1], decreasing=TRUE), main="clinical", xlab="Rank", 
     ylab="Proximity", ylim=c(0,1))
plot(sort(prox$Prox.gen[1, ][-1], decreasing=TRUE), main="expression", xlab="Rank",
     ylab="Proximity", ylim=c(0,1)) 


###################################################
### code chunk number 4: chunk4
###################################################
train.exp <- mrna[, 1:30]
train.cli <- t(cli[1:30, ])
train.label <- class[1:30]
test.cli <- t(cli[31:60, ])
pred.cli <- Classifier(train=train.cli, test=c(), train.label=train.label, type="RF", 
                       CVtype="k-fold", outerkfold=2, innerkfold=2)
pred.exp <- Classifier(train=train.exp, test=c(), train.label=train.label,type="GLM_L1", 
                       CVtype="k-fold", outerkfold=2, innerkfold=2)
prox <- Proximity(train.cli=train.cli, train.label=train.label, test.cli=test.cli, 
                  train.gen=train.exp, N = 2, Parallel = FALSE)

RS <- RS.generator(pred.cli=pred.cli$P.train, pred.gen=pred.exp$P.train, 
       train.label=train.label, prox.gen=prox$Prox.gen, prox.cli=prox$Prox.cli, 
       type = "both")
#observe the differences by ranking the RS values
order(RS[, 1]) # from the ranking approach
order(RS[, 2]) # from the proximity approach           


###################################################
### code chunk number 5: chunk5
###################################################
tr.exp <- mrna[, 1:40]
tr.cli <- t(cli[1:40, ])
tr.label <- class[1:40]
te.exp <- mrna[, 41:60]
te.cli <- t(cli[41:60, ])
te.label <- class[41:60]
result <- Curve.generator(train.cli=tr.cli, train.gen=tr.exp, train.label=tr.label, 
               test.cli= te.cli, test.gen=te.exp, test.label=te.label, 
               type=c("RF", "TSP"), RStype = "rank", Parallel = FALSE, 
               CVtype = "k-fold", outerkfold = 2, innerkfold = 2, 
               N = 2, plot.it=TRUE)



###################################################
### code chunk number 6: chunk6
###################################################
tr.cli <- t(cli[1:40, ])
te.cli <- t(cli[41:60, ])
tr.gen <- mrna[, 1:40]
te.gen <- mrna[, 41:60]
tr.label <- class[1:40]
te.label <- class[41:60]
result <- Curve.generator(train.cli=tr.cli, train.gen=tr.exp, train.label=tr.label, 
               test.cli= te.cli, test.gen=te.exp, test.label=te.label, 
               type=c("RF", "plsrf_x"), RStype = "rank", Parallel = FALSE, 
               CVtype = "k-fold", outerkfold = 2, innerkfold = 2, 
               N = 2, plot.it = FALSE)
A <- Step.pred(result, test.cli, 30)


