### R code from vignette source 'ontoToolsArchiving.Rnw'

###################################################
### code chunk number 1: setup
###################################################
DontRun <- TRUE


###################################################
### code chunk number 2: getLLtags
###################################################
library(org.Hs.eg.db)
lltags <- ls(org.Hs.egGO)


###################################################
### code chunk number 3: countTags
###################################################
print(length(lltags))


###################################################
### code chunk number 4: getAnnot
###################################################
kvmap <- list()
hllgoEnv <- new.env(hash=TRUE)
library(GO.db)


###################################################
### code chunk number 5: getGOMF
###################################################
GOtags <- ls(GOTERM)
library(Biobase)
library(annotate)
GOlabs <- mget(GOtags, GOTERM)
GOMFtags <- GOtags[sapply(GOlabs,Ontology)=="MF"]
#GOMFterms <- unlist(mget(GOMFtags,env=GOTERM))
#ntags <- length(GOMFtags)
#if (any(duplicated(GOMFterms)))
# {
# dups <- (1:ntags)[duplicated(GOMFterms)]
# GOMFterms[dups] <- paste(GOMFterms[dups],".2",sep="")
# }
#names(GOMFterms) <- GOMFtags



###################################################
### code chunk number 6: iterateLoci
###################################################
if (!(DontRun)) {
 cat(length(lltags))
 for (i in 1:length(lltags))
  {
  if (i %% 200 == 0) cat(i)
  tmp <- get(lltags[i], org.Hs.egGO)
  tmp = gsub("@.*$","", tmp)
  tmp <- tmp[ tmp %in% GOMFtags ]
  if (length(tmp)>0) 
     {
     kvmap[[ lltags[i] ]]  <- tmp
     assign( lltags[i], tmp, env=hllgoEnv )
     }
  }
}


###################################################
### code chunk number 7: getGOtargets
###################################################
if (!(DontRun)) {
 print(length(kvmap))
 gotargs <- sort(unique(unlist(kvmap)))
 llused <- names(kvmap)
 print(length(gotargs))
}



###################################################
### code chunk number 8: makeNamedSparse
###################################################
library(ontoTools)
if (!DontRun) {
LL2GOMFooMap.1.18 <- otkvEnv2namedSparse( llused, gotargs, hllgoEnv )
save(LL2GOMFooMap.1.18, file="LL2GOMFooMap1.18.rda", compress=TRUE)
save.image()
}
if (DontRun) data(LL2GOMFooMap.1.18)


###################################################
### code chunk number 9: gogr
###################################################
if (!DontRun) {goMFgraph.1.18 <- buildGOgraph()} else data(goMFgraph.1.18)
save.image()


###################################################
### code chunk number 10: rDAG
###################################################
if (!DontRun) {
  go1.18DAG <- new("rootedDAG", root="GO:0003674", DAG=goMFgraph.1.18)
  GOMF1.18 <- new("ontology", name="GOMF",  version="bioc 2.0", rDAG=go1.18DAG)
}
if (!DontRun) {goMFamat.1.18 <- accessMat(GOMF1.18)} else {data(goMFamat.1.18)}
save.image()


###################################################
### code chunk number 11: makeOOC
###################################################
if (!DontRun) LL2GOMFooc1.18 <- new("OOC", ontology=GOMF1.18, OOmap=LL2GOMFooMap.1.18)
save.image()



###################################################
### code chunk number 12: conceptProbs
###################################################
if (!DontRun) LL2GOMFcp.1.18 <- conceptProbs( ooc=LL2GOMFooc1.18, acc=goMFamat.1.18 )
save.image()



