/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.NNF;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLAxiomImpl
extends OWLObjectImpl
implements OWLAxiom {
    private OWLAxiom nnf;
    private final Set<OWLAnnotation> annotations;

    public OWLAxiomImpl(OWLDataFactory dataFactory, Collection<? extends OWLAnnotation> annotations) {
        super(dataFactory);
        this.annotations = !annotations.isEmpty() ? CollectionFactory.getCopyOnRequestSet(new TreeSet<OWLAnnotation>(annotations)) : Collections.emptySet();
    }

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    @Override
    public Set<OWLAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLAnnotationProperty annotationProperty) {
        if (this.annotations.isEmpty()) {
            return this.annotations;
        }
        HashSet<OWLAnnotation> result = new HashSet<OWLAnnotation>();
        for (OWLAnnotation anno : this.annotations) {
            if (!anno.getProperty().equals(annotationProperty)) continue;
            result.add(anno);
        }
        return result;
    }

    @Override
    public boolean equalsIgnoreAnnotations(OWLAxiom axiom) {
        return this.getAxiomWithoutAnnotations().equals(axiom.getAxiomWithoutAnnotations());
    }

    @Override
    public boolean isOfType(AxiomType<?> ... axiomTypes) {
        for (AxiomType<?> type : axiomTypes) {
            if (!this.getAxiomType().equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOfType(Set<AxiomType<?>> types) {
        return types.contains(this.getAxiomType());
    }

    protected Set<OWLAnnotation> mergeAnnos(Set<OWLAnnotation> annos) {
        HashSet<OWLAnnotation> merged = new HashSet<OWLAnnotation>(annos);
        merged.addAll(this.getAnnotations());
        return merged;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLAxiom)) {
            return false;
        }
        OWLAxiom other = (OWLAxiom)obj;
        return ((Object)this.annotations).equals(other.getAnnotations());
    }

    public Set<OWLEntity> getReferencedEntities() {
        return this.getSignature();
    }

    @Override
    public OWLAxiom getNNF() {
        if (this.nnf == null) {
            NNF con = new NNF(this.getOWLDataFactory());
            this.nnf = this.accept(con);
        }
        return this.nnf;
    }
}

