/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.virtual;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import uk.ac.ebi.ontocat.Ontology;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;

public class CachedServiceDecorator
implements InvocationHandler {
    private Object target;
    private static final Logger log = Logger.getLogger(CachedServiceDecorator.class);
    private static Cache ServiceCache;
    private static Cache EternalCache;

    private CachedServiceDecorator(Object obj) throws OntologyServiceException {
        this.target = obj;
        System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
        CacheManager manager = CacheManager.create((URL)this.getClass().getResource("ehcache.xml"));
        ServiceCache = manager.getCache("OntologyServiceCache");
        EternalCache = manager.getCache("EternalServiceCache");
        if (ServiceCache == null || EternalCache == null) {
            throw new OntologyServiceException("Could not instantie the caches");
        }
    }

    public static void clearCache() {
        CacheManager.getInstance().clearAll();
    }

    private static Object createProxy(Object obj) throws OntologyServiceException {
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new CachedServiceDecorator(obj));
    }

    public static OntologyService getService(OntologyService os) throws OntologyServiceException {
        return (OntologyService)CachedServiceDecorator.createProxy(os);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        String cacheKey = method.getName() + this.ArgsToKey(args);
        if (method.getReturnType() == List.class) {
            result = Collections.emptyList();
        }
        if (method.getReturnType() == Map.class) {
            result = Collections.emptyMap();
        }
        if (method.getReturnType() == Set.class) {
            result = Collections.emptySet();
        }
        try {
            if (ServiceCache != null && ServiceCache.get((Serializable)((Object)cacheKey)) == null) {
                Element el = new Element((Object)cacheKey, method.invoke(this.target, args));
                ServiceCache.put(el);
                EternalCache.put(el);
            }
            result = ServiceCache.get((Serializable)((Object)cacheKey)).getValue();
        }
        catch (InvocationTargetException e) {
            if (EternalCache != null && EternalCache.get((Serializable)((Object)cacheKey)) != null) {
                result = EternalCache.get((Serializable)((Object)cacheKey)).getValue();
                log.warn("Accessing eternal cache for " + cacheKey);
            }
            throw new OntologyServiceException(e);
        }
        return result;
    }

    private String ArgsToKey(Object[] args) throws OntologyServiceException {
        String s = "";
        if (args == null) {
            return "";
        }
        for (Object arg : args) {
            if (arg instanceof String) {
                s = s + "|" + (String)arg;
                continue;
            }
            if (arg instanceof OntologyTerm || arg instanceof Ontology) {
                s = s + "|" + arg.toString();
                continue;
            }
            if (arg instanceof OntologyService.SearchOptions[]) {
                for (OntologyService.SearchOptions o : (OntologyService.SearchOptions[])arg) {
                    s = s + "|" + o.toString();
                }
                continue;
            }
            log.fatal("Unrecognised parameter in cached call. Could not create key!");
            throw new OntologyServiceException(new Exception("Unrecognised parameter in cached call."));
        }
        return s;
    }
}

