/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.doublenum;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleInterval {
    protected final double m_lowerBoundInclusive;
    protected final double m_upperBoundInclusive;

    public DoubleInterval(double d, double d2) {
        assert (!DoubleInterval.isIntervalEmpty(d, d2));
        this.m_lowerBoundInclusive = d;
        this.m_upperBoundInclusive = d2;
    }

    public DoubleInterval intersectWith(DoubleInterval doubleInterval) {
        double d;
        double d2 = DoubleInterval.isSmallerEqual(this.m_lowerBoundInclusive, doubleInterval.m_lowerBoundInclusive) ? doubleInterval.m_lowerBoundInclusive : this.m_lowerBoundInclusive;
        if (DoubleInterval.isIntervalEmpty(d2, d = DoubleInterval.isSmallerEqual(this.m_upperBoundInclusive, doubleInterval.m_upperBoundInclusive) ? this.m_upperBoundInclusive : doubleInterval.m_upperBoundInclusive)) {
            return null;
        }
        if (this.isEqual(d2, d)) {
            return this;
        }
        if (doubleInterval.isEqual(d2, d)) {
            return doubleInterval;
        }
        return new DoubleInterval(d2, d);
    }

    protected boolean isEqual(double d, double d2) {
        return DoubleInterval.areIdentical(this.m_lowerBoundInclusive, d) && DoubleInterval.areIdentical(this.m_upperBoundInclusive, d2);
    }

    public int subtractSizeFrom(int n) {
        return DoubleInterval.subtractIntervalSizeFrom(this.m_lowerBoundInclusive, this.m_upperBoundInclusive, n);
    }

    public boolean contains(double d) {
        return DoubleInterval.contains(this.m_lowerBoundInclusive, this.m_upperBoundInclusive, d);
    }

    public void enumerateNumbers(Collection<Object> collection) {
        double d = this.m_lowerBoundInclusive;
        while (!DoubleInterval.areIdentical(d, this.m_upperBoundInclusive)) {
            collection.add(d);
            d = DoubleInterval.nextDouble(d);
        }
        collection.add(this.m_upperBoundInclusive);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DOUBLE[");
        stringBuffer.append(this.m_lowerBoundInclusive);
        stringBuffer.append("..");
        stringBuffer.append(this.m_upperBoundInclusive);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static boolean isNaN(long l) {
        return (l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) != 0L;
    }

    protected static boolean isIntervalEmpty(double d, double d2) {
        return !DoubleInterval.isSmallerEqual(d, d2);
    }

    public static boolean areIdentical(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static double nextDouble(double d) {
        long l;
        boolean bl;
        boolean bl2;
        long l2 = Double.doubleToRawLongBits(d);
        long l3 = l2 & Long.MAX_VALUE;
        boolean bl3 = bl2 = (l2 & Long.MIN_VALUE) == 0L;
        if (DoubleInterval.isNaN(l2) || l3 == 0x7FF0000000000000L && bl2) {
            return d;
        }
        if (bl2) {
            bl = true;
            l = l3 + 1L;
        } else if (!bl2 && l3 == 0L) {
            bl = true;
            l = 0L;
        } else {
            bl = false;
            l = l3 - 1L;
        }
        long l4 = l | (bl ? 0L : Long.MIN_VALUE);
        return Double.longBitsToDouble(l4);
    }

    public static double previousDouble(double d) {
        long l;
        boolean bl;
        boolean bl2;
        long l2 = Double.doubleToRawLongBits(d);
        long l3 = l2 & Long.MAX_VALUE;
        boolean bl3 = bl2 = (l2 & Long.MIN_VALUE) == 0L;
        if (DoubleInterval.isNaN(l2) || l3 == 0x7FF0000000000000L && !bl2) {
            return d;
        }
        if (!bl2) {
            bl = false;
            l = l3 + 1L;
        } else if (bl2 && l3 == 0L) {
            bl = false;
            l = 0L;
        } else {
            bl = true;
            l = l3 - 1L;
        }
        long l4 = l | (bl ? 0L : Long.MIN_VALUE);
        return Double.longBitsToDouble(l4);
    }

    public static int subtractIntervalSizeFrom(double d, double d2, int n) {
        long l;
        boolean bl;
        long l2;
        if (n <= 0) {
            return 0;
        }
        long l3 = Double.doubleToRawLongBits(d);
        long l4 = Double.doubleToRawLongBits(d2);
        if (DoubleInterval.isNaN(l3) || DoubleInterval.isNaN(l4)) {
            return n;
        }
        boolean bl2 = (l3 & Long.MIN_VALUE) == 0L;
        if (!DoubleInterval.isSmallerEqual(bl2, l2 = l3 & Long.MAX_VALUE, bl = (l4 & Long.MIN_VALUE) == 0L, l = l4 & Long.MAX_VALUE)) {
            return n;
        }
        if (bl2 && bl) {
            long l5 = l - l2 + 1L;
            return (int)Math.max((long)n - l5, 0L);
        }
        if (!bl2 && !bl) {
            long l6 = l2 - l + 1L;
            return (int)Math.max((long)n - l6, 0L);
        }
        if (!bl2 && bl) {
            long l7 = l2 + 1L;
            if (l7 >= (long)n) {
                return 0;
            }
            long l8 = 1L + l;
            if (l8 >= (long)(n = (int)((long)n - l7))) {
                return 0;
            }
            return (int)((long)n - l8);
        }
        throw new IllegalStateException();
    }

    public static boolean contains(double d, double d2, double d3) {
        long l = Double.doubleToRawLongBits(d);
        long l2 = Double.doubleToRawLongBits(d2);
        long l3 = Double.doubleToRawLongBits(d3);
        if (DoubleInterval.isNaN(l) || DoubleInterval.isNaN(l2) || DoubleInterval.isNaN(l3)) {
            return false;
        }
        boolean bl = (l & Long.MIN_VALUE) == 0L;
        boolean bl2 = (l2 & Long.MIN_VALUE) == 0L;
        boolean bl3 = (l3 & Long.MIN_VALUE) == 0L;
        long l4 = l & Long.MAX_VALUE;
        long l5 = l2 & Long.MAX_VALUE;
        long l6 = l3 & Long.MAX_VALUE;
        return DoubleInterval.isSmallerEqual(bl, l4, bl3, l6) && DoubleInterval.isSmallerEqual(bl3, l6, bl2, l5);
    }

    public static boolean isSmallerEqual(double d, double d2) {
        long l = Double.doubleToRawLongBits(d);
        long l2 = Double.doubleToRawLongBits(d2);
        if (DoubleInterval.isNaN(l) || DoubleInterval.isNaN(l2)) {
            return false;
        }
        boolean bl = (l & Long.MIN_VALUE) == 0L;
        boolean bl2 = (l2 & Long.MIN_VALUE) == 0L;
        long l3 = l & Long.MAX_VALUE;
        long l4 = l2 & Long.MAX_VALUE;
        return DoubleInterval.isSmallerEqual(bl, l3, bl2, l4);
    }

    public static boolean isSmallerEqual(boolean bl, long l, boolean bl2, long l2) {
        if (bl && bl2) {
            return l <= l2;
        }
        if (!bl && bl2) {
            return true;
        }
        if (bl && !bl2) {
            return false;
        }
        return l >= l2;
    }
}

