### R code from vignette source 'filters.Rnw'

###################################################
### code chunk number 1: loadPackage
###################################################
library(flowViz)


###################################################
### code chunk number 2: loadData
###################################################
library(flowViz)
data(GvHD)
head(pData(GvHD))


###################################################
### code chunk number 3: subsetLattice (eval = FALSE)
###################################################
## xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD,
##        subset=Patient=="6")


###################################################
### code chunk number 4: subsetFlowCore
###################################################
GvHD <- GvHD[pData(GvHD)$Patient==6]


###################################################
### code chunk number 5: transform
###################################################
tf <- transformList(from=colnames(GvHD)[3:7], tfun=asinh)
GvHD <- tf %on% GvHD


###################################################
### code chunk number 6: simpleRG
###################################################
rgate <- rectangleGate("FSC-H"=c(0, 400),"SSC-H"=c(-50, 300))
print(xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate))


###################################################
### code chunk number 7: threeDRG
###################################################
rgate2 <- rgate * rectangleGate("FL1-H"=c(2, 4))
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate2)


###################################################
### code chunk number 8: nonSmoothScatter
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate, smooth=FALSE)


###################################################
### code chunk number 9: plotnonSmoothScatter
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 10: nonSmoothScatterOutline
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate,
smooth=FALSE, outline=TRUE)


###################################################
### code chunk number 11: plotnonSmoothScatterOutline
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 12: nonSmoothScatterOutline2
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate2,
       smooth=FALSE, outline=TRUE)


###################################################
### code chunk number 13: plotnonSmoothScatter2
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 14: norm2Filter
###################################################
n2Filter <- norm2Filter("SSC-H", "FSC-H", scale=2, filterId="Lymphocytes")
n2Filter.results <- filter(GvHD, n2Filter)
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=n2Filter.results)


###################################################
### code chunk number 15: plotnorm2Filter
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 16: curv2Filter
###################################################
c2f <- curv2Filter("FSC-H", "FL4-H", bwFac=1.8)
c2f.results <- filter(GvHD, c2f)
xyplot(`FL4-H` ~ `FSC-H` | Visit, data=GvHD, filter=c2f.results)


###################################################
### code chunk number 17: plotcurv2Filter
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 18: densityplots
###################################################
densityplot(~ `FSC-H`, GvHD, filter=curv1Filter("FSC-H"))


###################################################
### code chunk number 19: plotdensityplots
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 20: multDensityplots
###################################################
densityplot(~ ., GvHD, channels=c("FSC-H", "SSC-H", "FL1-H"), 
filter=list(curv1Filter("FSC-H"), NULL, rgate2))


###################################################
### code chunk number 21: plotmultDensityplots
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 22: Pars1
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate,
       par.settings=list(gate=list(fill="black", alpha=0.2)))


###################################################
### code chunk number 23: plotPars1
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 24: plotPars2 (eval = FALSE)
###################################################
## flowViz.par.set(gate=list(fill="black", alpha=0.2))
## xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate)


###################################################
### code chunk number 25: Pars3
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate,
       smooth=FALSE, 
       par.settings=list(gate=list(col="orange", alpha=0.04,
                                   pch=20, cex=0.7),
                         flow.symbol=list(alpha=0.04, pch=20, cex=0.7)))


###################################################
### code chunk number 26: plotPars3
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 27: Pars4
###################################################
xyplot(`FL4-H` ~ `FSC-H` | Visit, data=GvHD, filter=c2f.results,
par.settings=list(gate=list(fill=rainbow(10), alpha=0.5, col="transparent")))


###################################################
### code chunk number 28: plotPars4
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 29: norm2FilterNames
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=n2Filter.results, 
       names=TRUE, 
       par.settings=list(gate=list(fill="black", alpha=0.2, 
                                   col="transparent"),
                         gate.text=list(col="darkred", alpha=0.7, cex=0.6)))


###################################################
### code chunk number 30: plotnorm2FilterNames
###################################################
print(plot(trellis.last.object()))


###################################################
### code chunk number 31: parCoord
###################################################
parallel(~ . | Visit, GvHD, filter=n2Filter.results, alpha = 0.01)


###################################################
### code chunk number 32: plotparCoord
###################################################
print(plot(trellis.last.object()))


