### R code from vignette source 'fastseg.Rnw'

###################################################
### code chunk number 1: fastseg.Rnw:39-42
###################################################
options(width=80)
set.seed(0)
fastsegVersion <- packageDescription("fastseg")$Version


###################################################
### code chunk number 2: fastseg.Rnw:106-107
###################################################
library(fastseg)


###################################################
### code chunk number 3: fastseg.Rnw:123-131
###################################################
data(coriell)
head(coriell)

samplenames <- colnames(coriell)[4:5]
data <- as.matrix(coriell[4:5])
#data[is.na(data)] <- median(data, na.rm=TRUE)
chrom <- coriell$Chromosome
maploc <- coriell$Position


###################################################
### code chunk number 4: fastseg.Rnw:144-164
###################################################
library("GenomicRanges")

## with both individuals
gr <- GRanges(seqnames=chrom,
        ranges=IRanges(maploc, end=maploc))
elementMetadata(gr) <- data
colnames(elementMetadata(gr)) <- samplenames
res <- fastseg(gr)
head(res)



## with one individual
gr2 <- gr
data2 <- as.matrix(data[, 1])
colnames(data2) <- "sample1"
elementMetadata(gr2) <- data2
res <- fastseg(gr2)
head(res)



###################################################
### code chunk number 5: fastseg.Rnw:168-182
###################################################
library(oligo)
eSet <- new("ExpressionSet")
assayData(eSet) <- list(intensity=data)

featureData(eSet) <- new("AnnotatedDataFrame", 
        data=data.frame(
                chrom = paste("chr",chrom,sep=""),
                start = maploc, 
                end   = maploc,stringsAsFactors=FALSE))
phenoData(eSet) <- new("AnnotatedDataFrame", 
        data=data.frame(samples=samplenames))
sampleNames(eSet) <- samplenames
res <- fastseg(eSet)
head(res)


###################################################
### code chunk number 6: fastseg.Rnw:186-191
###################################################
data2 <- data[, 1]
res <- fastseg(data2)
head(res)




###################################################
### code chunk number 7: fastseg.Rnw:195-198
###################################################
data2 <- data[1:400, ]
res <- fastseg(data2)
head(res)


###################################################
### code chunk number 8: fastseg.Rnw:206-212
###################################################
## with both individuals
gr <- GRanges(seqnames=chrom,
        ranges=IRanges(maploc, end=maploc))
elementMetadata(gr) <- data
colnames(elementMetadata(gr)) <- samplenames
res <- fastseg(gr,segMedianT=0.2)


###################################################
### code chunk number 9: fastseg.Rnw:218-219
###################################################
segPlot(gr,res, plot.type="w")


###################################################
### code chunk number 10: fastseg.Rnw:226-227
###################################################
segPlot(gr,res, plot.type="s")


###################################################
### code chunk number 11: fastseg.Rnw:240-242
###################################################
data(fastsegData)
system.time(res <- fastseg(fastsegData))


###################################################
### code chunk number 12: fastseg.Rnw:246-247
###################################################
segPlot(fastsegData,res, plot.type="w")


###################################################
### code chunk number 13: fastseg.Rnw:251-254
###################################################
library(DNAcopy)
cna <- DNAcopy::CNA(fastsegData,chrom="chr1",maploc=1:length(fastsegData))
system.time(res2 <- DNAcopy::segment(cna))


###################################################
### code chunk number 14: fastseg.Rnw:258-259
###################################################
plot(res2, plot.type="w", xmaploc=TRUE)


###################################################
### code chunk number 15: fastseg.Rnw:277-278 (eval = FALSE)
###################################################
## toBibtex(citation("fastseg"))


