### R code from vignette source 'eddDetails.Rnw'

###################################################
### code chunk number 1: eddDetails.Rnw:112-131
###################################################
library(edd)
canonp <- c(.025,.05,seq(.1,.9,.1),.95,.975)
iqr <- function(x) quantile(x,.75)-quantile(x,.25)
rescaledQuantiles <- function(qfun,rfun,pctiles=canonp,...) {
 ctr <- qfun(.5,...)
 #sca <- qfun(.75,...)-qfun(.25,...)
 samp <- rfun(25000,...)
 sca <- mad(samp)
 (qfun(pctiles,...)-ctr)/sca
}
qN01 <- rescaledQuantiles(qnorm,rnorm)
qc1 <- rescaledQuantiles(qchisq,rchisq,df=1)
qt3 <- rescaledQuantiles(qt,rt,df=3)
qln <- rescaledQuantiles(qlnorm,rlnorm)
qu <- rescaledQuantiles(qunif,runif)
qb28 <- rescaledQuantiles(qbeta,rbeta,shape1=2,shape2=8)
qb82 <- rescaledQuantiles(qbeta,rbeta,shape1=8,shape2=2)




###################################################
### code chunk number 2: eddDetails.Rnw:134-139
###################################################
par(mfrow=c(2,2))
plot(qN01,canonp,main="N(0,1)")
plot(qc1,canonp,main="chisq(1)")
plot(qt3,canonp,main="t(3)")
plot(qln,canonp,main="LN(0,1)")


###################################################
### code chunk number 3: eddDetails.Rnw:153-163
###################################################
par(mfrow=c(2,2))
plot(y=qN01,x=qN01,main="N(0,1)")
abline(0,1)
plot(y=qc1,x=qN01,main="chisq(1)")
abline(0,1)
plot(y=qt3,x=qN01,main="t(3)")
abline(0,1)
plot(y=qln,x=qN01,main="LN(0,1)")
abline(0,1)



###################################################
### code chunk number 4: eddDetails.Rnw:178-183
###################################################
par(mfrow=c(2,2))
plot(canonp,qN01-qN01,main="N(0,1)")
plot(canonp,qc1-qN01,main="chisq(1)")
plot(canonp, qt3-qN01,main="t(3)")
plot(canonp, qln-qN01,main="LN(0,1)")


###################################################
### code chunk number 5: eddDetails.Rnw:190-194
###################################################
par(mfrow=c(2,2))
plot(canonp,qu-qN01,main="U(0,1)")
plot(canonp,qb28-qN01,main="Beta(2,8)")
plot(canonp,qb82-qN01,main="Beta(8,2)")


###################################################
### code chunk number 6: eddDetails.Rnw:213-217
###################################################
pfq <- function(x,main) plot(x,xlab="gaussian deviate", ylab="flat QQNorm transform",
ylim=c(-3,3), main=main)
star <- function(x) (x-median(x))/mad(x)



###################################################
### code chunk number 7: eddDetails.Rnw:220-225
###################################################
par(mfrow=c(2,2))
pfq(flatQQNorm(star(rnorm(1000))),main="N01")
pfq(flatQQNorm(star(rt(1000,3))),main="t3")
pfq(flatQQNorm(star(rbeta(1000,2,8))),main="B(2,8)")
pfq(flatQQNorm(star(rbeta(1000,8,2))),main="B(8,2)")


###################################################
### code chunk number 8: eddDetails.Rnw:242-243
###################################################
print(getSlots("eddDist"))


###################################################
### code chunk number 9: eddDetails.Rnw:258-260
###################################################
print(names(eddDistList))
print(eddDistList[1:2])


###################################################
### code chunk number 10: eddDetails.Rnw:264-265
###################################################
plotED(eddDistList[[3]])


###################################################
### code chunk number 11: eddDetails.Rnw:283-285
###################################################
print(makeCandmat.theor( 5, eddDistList[1:3] ))



###################################################
### code chunk number 12: eddDetails.Rnw:295-297
###################################################
print(makeCandmat.raw( 5, 2, eddDistList[1:3] ))



###################################################
### code chunk number 13: eddDetails.Rnw:336-339
###################################################
x <- rnorm(50)
print(testVec(x, N01, FALSE))
print(testVec(x, LN01, FALSE))


###################################################
### code chunk number 14: eddDetails.Rnw:344-345
###################################################
plotED(LN01, data=x)


