### R code from vignette source 'cosmo.Rnw'

###################################################
### code chunk number 1: load
###################################################
library(cosmo) 


###################################################
### code chunk number 2: rseqArgs
###################################################
args(rseq)


###################################################
### code chunk number 3: pwm
###################################################
data(motifPWM)
motifPWM


###################################################
### code chunk number 4: seqLogo1
###################################################
seqLogo(motifPWM)


###################################################
### code chunk number 5: transMats
###################################################
data(transMats)
transMats



###################################################
### code chunk number 6: rseqEx
###################################################
simSeqs <- rseq(20, 100, 1.0, motifPWM, transMats, "ZOOPS")
simSeqs$motifs



###################################################
### code chunk number 7: makeConSetArg
###################################################
args(makeConSet)


###################################################
### code chunk number 8: makeConSetEx
###################################################
conSet1 <- makeConSet(numInt=3, type=c("B","V","B"),length=c(3,NA,3))


###################################################
### code chunk number 9: printConSet
###################################################
conSet1


###################################################
### code chunk number 10: boundCon1
###################################################
boundCon1 <- makeBoundCon(lower=1.0, upper=2.0)


###################################################
### code chunk number 11: boundCon2
###################################################
boundCon2 <- makeBoundCon(lower=0.0, upper=1.0)


###################################################
### code chunk number 12: palCon
###################################################
palCon1 <- makePalCon(int1=1, int2=3, errBnd=0.05)


###################################################
### code chunk number 13: addCon
###################################################
constraint <- list(boundCon1, boundCon2, palCon1)
int <- list(1, 2, NA)
conSet1 <- addCon(conSet=conSet1, constraint=constraint, int=int)
conSet1


###################################################
### code chunk number 14: conSet2
###################################################
conSet2 <- makeConSet(numInt=1, type="V",length=NA)
subCon1 <- makeSubMotifCon(submotif="TATA",minfreq=0.9)
conSet2 <- addCon(conSet=conSet2, constraint=subCon1, int=NA)
conSet2


###################################################
### code chunk number 15: cosmoArgs
###################################################
args(cosmo)


###################################################
### code chunk number 16: cosmoClass
###################################################
slotNames("cosmo")


###################################################
### code chunk number 17: example1
###################################################
seqFile <- system.file("Exfiles/seq.fasta", package="cosmo")
res <- cosmo(seqs=seqFile, constraints=list(conSet1, conSet2) , minW=7, maxW=8, models=c("OOPS", "TCM")) 


###################################################
### code chunk number 18: printPwm
###################################################
print(res)


###################################################
### code chunk number 19: summary
###################################################
summary(res)


###################################################
### code chunk number 20: candModels
###################################################
res@cand


###################################################
### code chunk number 21: motifs
###################################################
summary(res@motifs)


###################################################
### code chunk number 22: seqLogo2
###################################################
plot(res)


###################################################
### code chunk number 23: postprob
###################################################
plot(res, type="prob")


###################################################
### code chunk number 24: bgModelArgs
###################################################
args(bgModel)


###################################################
### code chunk number 25: bgModelEx
###################################################
bgFile <- system.file("Exfiles", "bgSeqs", package="cosmo")
tm <- bgModel(bgFile)


###################################################
### code chunk number 26: bgModelOutput
###################################################
tm


###################################################
### code chunk number 27: tmatEx
###################################################
res <- cosmo(seqs=seqFile, constraints="None" , minW=8, maxW=8, models="OOPS", transMat=tm$transMat)


###################################################
### code chunk number 28: tmatExOut
###################################################
res 


###################################################
### code chunk number 29: bfileEx
###################################################
bfile <- system.file("Exfiles", "bfile", package="cosmo")
s1 <- scan(file = bfile, what = "", sep = "\n", quote = "", 
           allowEscapes = FALSE, quiet = TRUE)
cat(paste(s1,collapse="\n"))


###################################################
### code chunk number 30: bfile2tmat
###################################################
tmat <- bfile2tmat(bfile)
tmat



