### R code from vignette source 'SRAdb.Rnw'

###################################################
### code chunk number 1: init
###################################################
options(width=50)


###################################################
### code chunk number 2: SRAdb.Rnw:55-57
###################################################
library(SRAdb)
sqlfile <- getSRAdbFile()


###################################################
### code chunk number 3: SRAdb.Rnw:62-63
###################################################
file.info('SRAmetadb.sqlite')


###################################################
### code chunk number 4: SRAdb.Rnw:68-69
###################################################
sra_con <- dbConnect(SQLite(),sqlfile)


###################################################
### code chunk number 5: SRAdb.Rnw:79-81
###################################################
sra_tables <- dbListTables(sra_con)
sra_tables


###################################################
### code chunk number 6: SRAdb.Rnw:85-86
###################################################
dbListFields(sra_con,'study')


###################################################
### code chunk number 7: SRAdb.Rnw:90-91
###################################################
sqliteQuickSQL(sra_con,'PRAGMA TABLE_INFO(study)')


###################################################
### code chunk number 8: j1
###################################################
rs <- dbGetQuery(sra_con,'select * from study limit 3')
rs[,1:5]


###################################################
### code chunk number 9: j2
###################################################
rs <- dbGetQuery(sra_con,paste("select study_accession,study_title from study where",
                           "study_description like 'Transcriptome%'",sep=" "))
rs[1:3,]


###################################################
### code chunk number 10: SRAdb.Rnw:111-116
###################################################
getTableCounts <- function(tableName,conn) {
  sql <- sprintf("select count(*) from %s",tableName)
  return(dbGetQuery(conn,sql)[1,1])
}
do.call(rbind,sapply(sra_tables,getTableCounts,sra_con,simplify=FALSE))


###################################################
### code chunk number 11: SRAdb.Rnw:125-127
###################################################
conversion <- sraConvert(c('SRP001007','SRP000931'), sra_con= sra_con)
conversion[1:3,]


###################################################
### code chunk number 12: SRAdb.Rnw:131-132
###################################################
apply(conversion, 2, unique)


###################################################
### code chunk number 13: SRAdb.Rnw:140-142
###################################################
rs <- getSRA (search_terms ='breast cancer', out_types=c('run','study'),  sra_con=sra_con)
dim(rs)


###################################################
### code chunk number 14: SRAdb.Rnw:146-148
###################################################
rs <- getSRA (search_terms ='"breast cancer"', out_types=c('run','study'),  sra_con=sra_con)
dim(rs)


###################################################
### code chunk number 15: SRAdb.Rnw:152-154
###################################################
rs <- getSRA (search_terms ='MCF7 OR "MCF-7"', out_types=c('sample'), sra_con=sra_con) 
dim(rs)


###################################################
### code chunk number 16: SRAdb.Rnw:158-160
###################################################
rs <- getSRA (search_terms ='submission_center: GEO', out_types=c('submission'), sra_con=sra_con)  
dim(rs)


###################################################
### code chunk number 17: SRAdb.Rnw:164-166
###################################################
rs <- getSRA (search_terms ='Carcino*', out_types=c('study'), sra_con=sra_con)  
dim(rs)


###################################################
### code chunk number 18: SRAdb.Rnw:172-173 (eval = FALSE)
###################################################
## listSRAfile ("SRX000122", sra_con=sra_con, sraType='litesra') 


###################################################
### code chunk number 19: SRAdb.Rnw:177-179 (eval = FALSE)
###################################################
## rs <- getSRAinfo (in_acc=c("SRX000122"), sra_con=sra_con)
## rs[1:3,]


###################################################
### code chunk number 20: SRAdb.Rnw:183-184 (eval = FALSE)
###################################################
## getSRAfile (in_acc=c("SRR000648","SRR000657"), sra_con=sra_con, destdir=getwd(), sraType='litesra')


###################################################
### code chunk number 21: SRAdb.Rnw:192-193 (eval = FALSE)
###################################################
## startIGV("mm")


###################################################
### code chunk number 22: SRAdb.Rnw:197-204 (eval = FALSE)
###################################################
## exampleBams = file.path(system.file('extdata',package='SRAdb'),
##   dir(system.file('extdata',package='SRAdb'),pattern='bam$'))
## sock <- IGVsocket()
## IGVgenome(sock, 'hg18')
## IGVload(sock, exampleBams)
## IGVgoto(sock, 'chr1:1-1000')
## IGVsnapshot(sock)


###################################################
### code chunk number 23: SRAdb.Rnw:212-216 (eval = FALSE)
###################################################
## acc <- getSRA (search_terms ='colon cancer', out_types=c('sra'), sra_con=sra_con, acc_only=TRUE) 
## g <- entityGraph(acc)
## attrs <- getDefaultAttrs(list(node=list(fillcolor='lightblue', shape='ellipse')))
## plot(g, attrs= attrs)  


###################################################
### code chunk number 24: SRAdb.Rnw:220-224 (eval = FALSE)
###################################################
## g <- sraGraph('Ewing Sarcoma', sra_con)
## library(Rgraphviz)
## attrs <- getDefaultAttrs(list(node=list(fillcolor='lightblue', shape='ellipse')))
## plot(g, attrs=attrs)


###################################################
### code chunk number 25: SRAdb.Rnw:229-230
###################################################
dbDisconnect(sra_con)


###################################################
### code chunk number 26: SRAdb.Rnw:235-236
###################################################
toLatex(sessionInfo())


