/*
 * Decompiled with CFR 0.152.
 */
package reder.io;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import reder.application.MainFrame;
import reder.network.EdgeBank;
import reder.network.LegendBank;
import reder.network.NodeBank;
import reder.plugins.PluginAddons;
import reder.plugins.PluginMethods;
import reder.plugins.Plugins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveData {
    private static ArrayList<NodeBank> NodeList;
    private static ArrayList<EdgeBank> EdgeList;
    private static ArrayList<LegendBank> LegendList;
    private static String saveAddress;
    private float centroX;
    private float centroY;
    private float zoomInOut;
    private Color backgroundColor;
    private String taskProgress;
    private double edgeTarget;
    private double outedgeTarget;
    private double nodeSpeedBuffer;
    private double repulserad;
    private double stiffness;
    private double repelFactor;
    private double outsideRepelFactor;
    private double perimeterEffect;
    Document doc;

    public SaveData() {
        NodeList = new ArrayList();
        EdgeList = new ArrayList();
        LegendList = new ArrayList();
        saveAddress = null;
        this.taskProgress = "running";
    }

    public String getProgress() {
        return this.taskProgress;
    }

    public void inputAndGo(String outputAddress, String fileType, ArrayList<NodeBank> outputNodes, ArrayList<EdgeBank> outputEdges, ArrayList<LegendBank> outputLegend, float centroX, float centroY, float zoomInOut, Color backgroundColor, double edgeTarget, double outedgeTarget, double stiffness, double repelFactor, double outsideRepelFactor, double nodeSpeedBuffer, double perimeterEffect, double repulserad) {
        try {
            this.dataClear();
            this.repulserad = repulserad;
            this.edgeTarget = edgeTarget;
            this.outedgeTarget = outedgeTarget;
            this.stiffness = stiffness;
            this.repelFactor = repelFactor;
            this.outsideRepelFactor = outsideRepelFactor;
            this.nodeSpeedBuffer = nodeSpeedBuffer;
            this.perimeterEffect = perimeterEffect;
            this.backgroundColor = backgroundColor;
            this.zoomInOut = zoomInOut;
            this.centroX = centroX;
            this.centroY = centroY;
            saveAddress = outputAddress;
            NodeList = outputNodes;
            EdgeList = outputEdges;
            LegendList = outputLegend;
            if (fileType.equals("default")) {
                this.saveDefault();
            }
            if (fileType.equals("basicNetwork")) {
                this.basicNetwork();
            }
            if (fileType.equals("xgmml")) {
                this.xgmml();
            }
            if (fileType.equals("customPlugins")) {
                this.customPlugins();
            }
            if (fileType.equals("winbash")) {
                this.saveWinBash();
            }
            if (fileType.equals("macbash")) {
                this.saveMacBash();
            }
            if (fileType.equals("linuxbash")) {
                this.saveLinuxBash();
            }
            if (fileType.equals("adjMatrix")) {
                this.adjMatrix();
            }
            if (fileType.equals("uniqueLinks")) {
                this.uniqueLinks();
            }
            if (fileType.equals("nodeIDs")) {
                this.nodeIDs();
            }
            if (fileType.equals("clusters")) {
                this.clusterAssignments();
            }
            if (fileType.equals("assignments")) {
                this.nodeAssignments();
            }
            if (fileType.equals("medusa")) {
                this.medusa();
            }
            if (fileType.equals("pajek")) {
                this.pajek();
            }
            if (fileType.equals("graphviz")) {
                this.graphviz();
            }
            if (fileType.equals("biolayout")) {
                this.biolayout();
            }
            this.taskProgress = "endsave";
        }
        catch (IOException iOException) {
            this.taskProgress = "halt";
        }
        catch (JDOMException jDOMException) {
            this.taskProgress = "halt";
        }
        File checkFile = new File(saveAddress);
        if (!checkFile.exists()) {
            this.taskProgress = "halt";
        }
    }

    public void dataClear() {
        NodeList.clear();
        EdgeList.clear();
        LegendList.clear();
        saveAddress = null;
    }

    public void nodeIDs() throws IOException {
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt") && !end.equals("dat")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("Node_ID");
        out.newLine();
        for (int i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount1 = NodeList.get(i);
            if (NodeList.get(i).isContainer()) continue;
            out.write(nodeAccount1.getNodeID());
            out.newLine();
        }
        out.close();
    }

    public void nodeAssignments() throws IOException {
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt") && !end.equals("dat")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("Node_ID\tNest_assignmet\tStatus(selected/nonselected)");
        out.newLine();
        for (int i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount1 = NodeList.get(i);
            if (nodeAccount1.isContainer()) continue;
            String assignment = nodeAccount1.getNestedAssignment();
            if (assignment.equals("assignRoot_meaninglessCode1245ty890xyz")) {
                assignment = "NA";
            }
            String status = "N";
            if (nodeAccount1.getDestaque()) {
                status = "S";
            }
            out.write(nodeAccount1.getNodeID() + "\t" + assignment + "\t" + status);
            out.newLine();
        }
        out.close();
    }

    public void clusterAssignments() throws IOException {
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt") && !end.equals("dat")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("Node_ID\tCluster_assignmet");
        out.newLine();
        for (int i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount1 = NodeList.get(i);
            if (nodeAccount1.isContainer()) continue;
            out.write(nodeAccount1.getNodeID() + "\t" + nodeAccount1.getClusterID());
            out.newLine();
        }
        out.close();
    }

    public void adjMatrix() throws IOException {
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt") && !end.equals("dat")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("node_1\tnode_2");
        out.newLine();
        for (int i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount1 = NodeList.get(i);
            if (nodeAccount1.isContainer()) continue;
            ArrayList<Integer> parceiros = nodeAccount1.getParceiros();
            for (int j = 0; j < parceiros.size(); ++j) {
                NodeBank nodeAccount2 = NodeList.get(parceiros.get(j));
                if (nodeAccount2.isContainer()) continue;
                out.write(nodeAccount1.getNodeID() + "\t" + nodeAccount2.getNodeID());
                out.newLine();
            }
        }
        out.close();
    }

    public void uniqueLinks() throws IOException {
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt") && !end.equals("dat")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("node_1\tnode_2");
        out.newLine();
        for (int i = 0; i < EdgeList.size(); ++i) {
            EdgeBank edgeAccount = EdgeList.get(i);
            int a = edgeAccount.getA();
            int b = edgeAccount.getB();
            if (NodeList.get(a).isContainer() || NodeList.get(b).isContainer()) continue;
            String nodeA = NodeList.get(a).getNodeID();
            String nodeB = NodeList.get(b).getNodeID();
            out.write(nodeA + "\t" + nodeB);
            out.newLine();
        }
        out.close();
    }

    public void medusa() throws IOException {
        int i;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("*edges");
        out.newLine();
        for (i = 0; i < EdgeList.size(); ++i) {
            EdgeBank edgeAccount = EdgeList.get(i);
            int a = edgeAccount.getA();
            int b = edgeAccount.getB();
            if (NodeList.get(a).isContainer() || NodeList.get(b).isContainer()) continue;
            String nodeA = NodeList.get(a).getNodeID();
            String nodeB = NodeList.get(b).getNodeID();
            out.write(nodeA + "\t" + nodeB + "\t" + "i 1" + "\t" + "c 1.0" + "\t" + "o 0.0");
            out.newLine();
        }
        out.write("*nodes");
        out.newLine();
        for (i = 0; i < NodeList.size(); ++i) {
            NodeBank node = NodeList.get(i);
            int r = node.getTrueNodeColor().getRed();
            int g = node.getTrueNodeColor().getGreen();
            int b = node.getTrueNodeColor().getBlue();
            out.write(node.getNodeID() + "\t" + node.getX() + "\t" + node.getY() + "\t" + "c " + r + "," + g + "," + b + "\t\t\t\t" + "s 0");
            out.newLine();
        }
        out.close();
    }

    public void graphviz() throws IOException {
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("digraph G {");
        out.newLine();
        for (int i = 0; i < EdgeList.size(); ++i) {
            EdgeBank edgeAccount = EdgeList.get(i);
            int a = edgeAccount.getA();
            int b = edgeAccount.getB();
            if (NodeList.get(a).isContainer() || NodeList.get(b).isContainer()) continue;
            String nodeA = NodeList.get(a).getNodeID();
            String nodeB = NodeList.get(b).getNodeID();
            out.write(nodeA + " -> " + nodeB + ";");
            out.newLine();
        }
        out.write("}");
        out.close();
    }

    public void biolayout() throws IOException {
        int i;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("layout")) {
            saveAddress = saveAddress + ".layout";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        for (i = 0; i < EdgeList.size(); ++i) {
            EdgeBank edgeAccount = EdgeList.get(i);
            int a = edgeAccount.getA();
            int b = edgeAccount.getB();
            if (NodeList.get(a).isContainer() || NodeList.get(b).isContainer()) continue;
            String nodeA = NodeList.get(a).getNodeID();
            String nodeB = NodeList.get(b).getNodeID();
            out.write("\"" + nodeA + "\"" + "\t" + "\"" + nodeB + "\"");
            out.newLine();
        }
        for (i = 0; i < NodeList.size(); ++i) {
            NodeBank node = NodeList.get(i);
            if (NodeList.get(i).isContainer()) continue;
            out.write("//NODECOORD\t\"" + node.getNodeID() + "\"" + "\t" + node.getX() + "\t" + node.getY() + "\t" + "0.0");
            out.newLine();
            out.write("//NODESIZE\t\"" + node.getNodeID() + "\"" + "\t" + node.getNodeSize() * 5.0f);
            out.newLine();
        }
        out.close();
    }

    public void pajek() throws IOException {
        int i;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt")) {
            saveAddress = saveAddress + ".txt";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("*Vertices\t" + NodeList.size());
        out.newLine();
        for (i = 0; i < NodeList.size(); ++i) {
            NodeBank node = NodeList.get(i);
            if (NodeList.get(i).isContainer()) continue;
            out.write(i + 1 + "\t" + "\"" + node.getNodeID() + "\"" + "\t" + node.getX() + "\t" + node.getY());
            out.newLine();
        }
        out.write("*Edges");
        out.newLine();
        for (i = 0; i < EdgeList.size(); ++i) {
            EdgeBank edgeAccount = EdgeList.get(i);
            int a = edgeAccount.getA();
            int b = edgeAccount.getB();
            if (NodeList.get(a).isContainer() || NodeList.get(b).isContainer()) continue;
            out.write(a + 1 + "\t" + (b + 1) + "\t" + "1");
            out.newLine();
        }
        out.close();
    }

    public void xgmml() throws IOException, JDOMException {
        System.gc();
        this.JDomXmlWriter();
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("xgmml")) {
            saveAddress = saveAddress + ".xgmml";
        }
        Format formato = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(formato);
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        outputter.output(this.doc, (Writer)out);
        out.close();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDefault() throws JDOMException, IOException {
        System.gc();
        this.JDomXmlWriter();
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("dyn")) {
            saveAddress = saveAddress + ".dyn";
        }
        Format formato = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(formato);
        File tempFile = File.createTempFile("datadyn", ".tmp");
        BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
        outputter.output(this.doc, (Writer)out);
        out.close();
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            int n;
            fin = new FileInputStream(tempFile.getAbsolutePath());
            fout = new FileOutputStream(saveAddress);
            ZipOutputStream zout = new ZipOutputStream(fout);
            zout.setLevel(0);
            zout.setComment("Archive created by RedeR v1.0");
            ZipEntry ze = new ZipEntry(tempFile.getAbsolutePath());
            zout.putNextEntry(ze);
            int BUFSIZ = 2048;
            byte[] inbuf = new byte[2048];
            while ((n = fin.read(inbuf)) != -1) {
                zout.write(inbuf, 0, n);
            }
            fin.close();
            fin = null;
            zout.close();
            zout = null;
        }
        catch (IOException e) {
            System.err.println(e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        tempFile.deleteOnExit();
        System.gc();
    }

    public void JDomXmlWriter() {
        String label;
        int i;
        this.doc = new Document(){};
        this.doc.addContent(new Comment("Graph File Generated for RedeR v1.0"));
        Namespace ns = Namespace.getNamespace("http://www.cs.rpi.edu/XGMML");
        Element graph = new Element("graph", ns);
        graph.setAttribute("label", "Network");
        graph.setAttribute("directed", "1");
        this.doc.setRootElement(graph);
        Element att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "backgroundColor");
        String background = "#" + Integer.toHexString(this.backgroundColor.getRGB() & 0xFFFFFF);
        att.setAttribute("value", background);
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "GRAPH_VIEW_ZOOM");
        att.setAttribute("value", Float.toString(this.zoomInOut));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "GRAPH_VIEW_CENTER_X");
        att.setAttribute("value", Float.toString(this.centroX));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "GRAPH_VIEW_CENTER_Y");
        att.setAttribute("value", Float.toString(this.centroY));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_EDGETARGET");
        att.setAttribute("value", Float.toString((float)this.edgeTarget));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_OUTEDGETARGET");
        att.setAttribute("value", Float.toString((float)this.outedgeTarget));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_STIFFNESS");
        att.setAttribute("value", Float.toString((float)this.stiffness));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_REPEL");
        att.setAttribute("value", Float.toString((float)this.repelFactor));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_REPULSERAD");
        att.setAttribute("value", Float.toString((float)this.repulserad));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_OUTREPEL");
        att.setAttribute("value", Float.toString((float)this.outsideRepelFactor));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_PERIMETEREFFECT");
        att.setAttribute("value", Float.toString((float)this.perimeterEffect));
        graph.addContent(att);
        att = new Element("att", ns);
        att.setAttribute("type", "real");
        att.setAttribute("name", "RELAX_SPEED");
        att.setAttribute("value", Float.toString((float)this.nodeSpeedBuffer));
        graph.addContent(att);
        Element leg = new Element("legend", ns);
        for (i = 0; i < LegendList.size(); ++i) {
            String valuevec = "null";
            String aliasvec = "null";
            String size = "null";
            String bend = "null";
            String col = "null";
            String intersp = "null";
            String ftsize = "null";
            String labx = "null";
            String labxdist = "null";
            String position = "null";
            String legDistX = "null";
            String legDistY = "null";
            String isver = "null";
            String edgelen = "null";
            LegendBank legAccount = LegendList.get(i);
            String legtype = legAccount.getLegType();
            if (legAccount.getMembership() == 0) {
                leg = new Element("legend", ns);
                leg.setAttribute("legtype", legtype);
                graph.addContent(leg);
            }
            if (legtype.equals("edgewidth") || legtype.equals("nodesize")) {
                valuevec = Float.toString(legAccount.getNodeSize() * 20.0f);
                aliasvec = legAccount.getAliases();
                col = "#" + Integer.toHexString(legAccount.getTrueNodeColor().getRGB() & 0xFFFFFF);
                intersp = Float.toString(legAccount.getInterSpace());
                ftsize = Integer.toString(legAccount.getFontSize());
                labx = legAccount.getLabx();
                labxdist = Float.toString(legAccount.getLabxDist());
                position = legAccount.getPanelPosition();
                legDistX = Float.toString(legAccount.getDistBorderX());
                legDistY = Float.toString(legAccount.getDistBorderY());
                isver = Boolean.toString(legAccount.isVertical());
                if (legtype.equals("edgewidth")) {
                    edgelen = legAccount.isVertical() ? Float.toString(legAccount.getW()) : Float.toString(legAccount.getH());
                }
            } else if (legtype.equals("nodecolor") || legtype.equals("edgecolor")) {
                valuevec = "#" + Integer.toHexString(legAccount.getTrueNodeColor().getRGB() & 0xFFFFFF);
                aliasvec = legAccount.getAliases();
                size = Float.toString(legAccount.getNodeSize() * 20.0f);
                bend = Float.toString(legAccount.getNodeBend());
                ftsize = Integer.toString(legAccount.getFontSize());
                labx = legAccount.getLabx();
                labxdist = Float.toString(legAccount.getLabxDist());
                position = legAccount.getPanelPosition();
                legDistX = Float.toString(legAccount.getDistBorderX());
                legDistY = Float.toString(legAccount.getDistBorderY());
                isver = Boolean.toString(legAccount.isVertical());
            } else if (legtype.equals("nodeshape") || legtype.equals("edgeshape")) {
                valuevec = legAccount.getLegShape();
                aliasvec = legAccount.getAliases();
                col = "#" + Integer.toHexString(legAccount.getTrueNodeColor().getRGB() & 0xFFFFFF);
                size = Float.toString(legAccount.getNodeSize() * 20.0f);
                intersp = Float.toString(legAccount.getInterSpace());
                ftsize = Integer.toString(legAccount.getFontSize());
                labx = legAccount.getLabx();
                labxdist = Float.toString(legAccount.getLabxDist());
                position = legAccount.getPanelPosition();
                legDistX = Float.toString(legAccount.getDistBorderX());
                legDistY = Float.toString(legAccount.getDistBorderY());
                isver = Boolean.toString(legAccount.isVertical());
            }
            if (!size.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "size");
                att.setAttribute("value", size);
                leg.addContent(att);
            }
            if (!bend.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "bend");
                att.setAttribute("value", bend);
                leg.addContent(att);
            }
            if (!col.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "hexadecimal");
                att.setAttribute("name", "color");
                att.setAttribute("value", col);
                leg.addContent(att);
            }
            if (!intersp.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "intersp");
                att.setAttribute("value", intersp);
                leg.addContent(att);
            }
            if (!ftsize.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "ftsize");
                att.setAttribute("value", ftsize);
                leg.addContent(att);
            }
            if (!labx.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "labx");
                att.setAttribute("value", labx);
                leg.addContent(att);
            }
            if (!labxdist.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "labxdist");
                att.setAttribute("value", labxdist);
                leg.addContent(att);
            }
            if (!position.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "position");
                att.setAttribute("value", position);
                leg.addContent(att);
            }
            if (!legDistX.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "legdx");
                att.setAttribute("value", legDistX);
                leg.addContent(att);
            }
            if (!legDistY.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "float");
                att.setAttribute("name", "legdy");
                att.setAttribute("value", legDistY);
                leg.addContent(att);
            }
            if (!isver.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "boolean");
                att.setAttribute("name", "vertical");
                att.setAttribute("value", isver);
                leg.addContent(att);
            }
            if (!edgelen.equals("null") && legAccount.getMembership() == 0) {
                att = new Element("att", ns);
                att.setAttribute("type", "boolean");
                att.setAttribute("name", "edgelen");
                att.setAttribute("value", edgelen);
                leg.addContent(att);
            }
            Element member = new Element("member", ns);
            member.setAttribute("label", aliasvec);
            member.addContent(valuevec);
            leg.addContent(member);
        }
        for (i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount = NodeList.get(i);
            label = nodeAccount.getNodeID();
            String id = Integer.toString(i);
            String alias = nodeAccount.getAliases();
            String strX = Float.toString(nodeAccount.getXtoSave());
            String strY = Float.toString(nodeAccount.getYtoSave());
            String strW = Float.toString(nodeAccount.getW());
            String strH = Float.toString(nodeAccount.getH());
            String bend = Float.toString(nodeAccount.getNodeBend());
            String size = Float.toString(nodeAccount.getNodeSize() * 20.0f);
            String nodeShape = nodeAccount.getNodeShape();
            String nodeLineType = nodeAccount.getNodeLineType();
            String nodeColor = "#" + Integer.toHexString(nodeAccount.getTrueNodeColor().getRGB() & 0xFFFFFF);
            String lineSize = Float.toString(nodeAccount.getNodeLineWidth());
            String lineColor = "#" + Integer.toHexString(nodeAccount.getNodeLineColor().getRGB() & 0xFFFFFF);
            String fontName = nodeAccount.getFont().getFontName();
            String fontStyle = Integer.toString(nodeAccount.getFont().getStyle());
            String fontSize = Integer.toString(nodeAccount.getFont().getSize());
            String font = fontName + "-" + fontStyle + "-" + fontSize;
            String fontColor = "#" + Integer.toHexString(nodeAccount.getNodeFontColor().getRGB() & 0xFFFFFF);
            String weight = Double.toString(nodeAccount.getNodeWeight());
            String fontXposition = Float.toString(nodeAccount.getFontX());
            String fontYposition = Float.toString(nodeAccount.getFontY());
            String groupComponets = nodeAccount.getGroupComponets();
            String groupCompNumber = Integer.toString(nodeAccount.getGroupCompNumber());
            String relativeSize = Double.toString(nodeAccount.getRelativeSize() * 100.0);
            Element node = new Element("node", ns);
            node.setAttribute("label", label);
            node.setAttribute("id", id);
            graph.addContent(node);
            if (nodeAccount.isGroup()) {
                att = new Element("att", ns);
                att.setAttribute("type", "integer");
                att.setAttribute("name", "group");
                att.setAttribute("value", groupComponets);
                node.addContent(att);
                att = new Element("att", ns);
                att.setAttribute("type", "integer");
                att.setAttribute("name", "componets");
                att.setAttribute("value", groupCompNumber);
                node.addContent(att);
            }
            if (nodeAccount.isContainer()) {
                att = new Element("att", ns);
                att.setAttribute("type", "double");
                att.setAttribute("name", "container.rsize");
                att.setAttribute("value", relativeSize);
                node.addContent(att);
                boolean c1 = nodeAccount.isContainerAnchored();
                boolean c2 = nodeAccount.isContainerHided();
                boolean c3 = nodeAccount.isContainerTransparent();
                if (c1 && c2 && c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "TTT");
                    node.addContent(att);
                } else if (c1 && !c2 && c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "TFT");
                    node.addContent(att);
                } else if (!c1 && c2 && c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "FTT");
                    node.addContent(att);
                } else if (!c1 && !c2 && c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "FFT");
                    node.addContent(att);
                } else if (c1 && c2 && !c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "TTF");
                    node.addContent(att);
                } else if (c1 && !c2 && !c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "TFF");
                    node.addContent(att);
                } else if (!c1 && c2 && !c3) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "FTF");
                    node.addContent(att);
                } else if (!(c1 || c2 || c3)) {
                    att = new Element("att", ns);
                    att.setAttribute("type", "double");
                    att.setAttribute("name", "container.status");
                    att.setAttribute("value", "FFF");
                    node.addContent(att);
                }
                att = new Element("att", ns);
                att.setAttribute("type", "string");
                att.setAttribute("name", "line.type");
                att.setAttribute("value", nodeLineType);
                node.addContent(att);
            }
            if (nodeAccount.isNodeGradient()) {
                att = new Element("att", ns);
                att.setAttribute("type", "boolean");
                att.setAttribute("name", "gradient");
                att.setAttribute("value", "true");
                node.addContent(att);
            }
            att = new Element("att", ns);
            att.setAttribute("type", "string");
            att.setAttribute("name", "alias");
            att.setAttribute("value", alias);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "node.bend");
            att.setAttribute("value", bend);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "node.size");
            att.setAttribute("value", size);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "hexadecimal");
            att.setAttribute("name", "node.labelColor");
            att.setAttribute("value", fontColor);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "string");
            att.setAttribute("name", "node.font");
            att.setAttribute("value", font);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "double");
            att.setAttribute("name", "node.weight");
            att.setAttribute("value", weight);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "font.x.position");
            att.setAttribute("value", fontXposition);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "float");
            att.setAttribute("name", "font.y.position");
            att.setAttribute("value", fontYposition);
            node.addContent(att);
            att = new Element("att", ns);
            att.setAttribute("type", "string");
            att.setAttribute("name", "node.shape");
            String type = "ellipse";
            if (nodeShape.equals("RECTANGLE")) {
                type = "rectangle";
            }
            if (nodeShape.equals("ROUNDED_RECTANGLE")) {
                type = "roundrect";
            }
            if (nodeShape.equals("TRIANGLE")) {
                type = "triangle";
            }
            if (nodeShape.equals("DIAMOND")) {
                type = "diamond";
            }
            att.setAttribute("value", type);
            node.addContent(att);
            Element nodeAttribute = new Element("graphics", ns);
            nodeAttribute.setAttribute("type", nodeShape);
            nodeAttribute.setAttribute("h", strH);
            nodeAttribute.setAttribute("w", strW);
            nodeAttribute.setAttribute("x", strX);
            nodeAttribute.setAttribute("y", strY);
            nodeAttribute.setAttribute("fill", nodeColor);
            nodeAttribute.setAttribute("width", lineSize);
            nodeAttribute.setAttribute("outline", lineColor);
            node.addContent(nodeAttribute);
        }
        for (i = 0; i < EdgeList.size(); ++i) {
            Element edgeAttribute;
            Element edgeAttribute2;
            EdgeBank edgeAccount = EdgeList.get(i);
            label = Integer.toString(i);
            String source = Integer.toString(edgeAccount.getA());
            String target = Integer.toString(edgeAccount.getB());
            String direction = Integer.toString(edgeAccount.getArrowDirection());
            String width = Float.toString(edgeAccount.getWidth());
            String edgeColor = "#" + Integer.toHexString(edgeAccount.getEdgeColor().getRGB() & 0xFFFFFF);
            String lineType = edgeAccount.getType();
            Element edge = new Element("edge", ns);
            edge.setAttribute("label", label);
            edge.setAttribute("source", source);
            edge.setAttribute("target", target);
            edge.setAttribute("direction", direction);
            graph.addContent(edge);
            if (edgeAccount.getMeanWeight() != 0.0) {
                String weight = Double.toString(edgeAccount.getMeanWeight());
                edgeAttribute2 = new Element("att", ns);
                edgeAttribute2.setAttribute("type", "double");
                edgeAttribute2.setAttribute("name", "weight");
                edgeAttribute2.setAttribute("value", weight);
                edge.addContent(edgeAttribute2);
            }
            if (edgeAccount.getArrowLength() != 10.0f) {
                String arrowlen = Float.toString(edgeAccount.getArrowLength());
                edgeAttribute2 = new Element("att", ns);
                edgeAttribute2.setAttribute("type", "float");
                edgeAttribute2.setAttribute("name", "arrowlength");
                edgeAttribute2.setAttribute("value", arrowlen);
                edge.addContent(edgeAttribute2);
            }
            if (edgeAccount.getArrowAngle() != 45.0f) {
                String arrowangle = Float.toString(edgeAccount.getArrowAngle());
                edgeAttribute2 = new Element("att", ns);
                edgeAttribute2.setAttribute("type", "float");
                edgeAttribute2.setAttribute("name", "arrowangle");
                edgeAttribute2.setAttribute("value", arrowangle);
                edge.addContent(edgeAttribute2);
            }
            if (!edgeAccount.isDefaultEdgeAssignmet()) {
                edgeAttribute = new Element("att", ns);
                edgeAttribute.setAttribute("type", "boolean");
                edgeAttribute.setAttribute("name", "defaultnesting");
                edgeAttribute.setAttribute("value", "false");
                edge.addContent(edgeAttribute);
            }
            edgeAttribute = new Element("graphics", ns);
            edgeAttribute.setAttribute("width", width);
            edgeAttribute.setAttribute("fill", edgeColor);
            edgeAttribute.setAttribute("edgeLineType", lineType);
            edge.addContent(edgeAttribute);
        }
    }

    public void basicNetwork() throws IOException {
        int i;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("txt") && !end.equals("dat")) {
            saveAddress = saveAddress + ".dynn";
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        out.write("node_id\talias\tshape\tsize\tcolor\tx\ty\tweight");
        out.newLine();
        for (i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount = NodeList.get(i);
            String nodeID = nodeAccount.getNodeID();
            String shape = nodeAccount.getNodeShape();
            float size = SaveData.round(nodeAccount.getNodeSize() * 20.0f, 1);
            String nodeColor = "#" + Integer.toHexString(nodeAccount.getTrueNodeColor().getRGB() & 0xFFFFFF);
            double nodeWeight = SaveData.round(nodeAccount.getNodeWeight(), 2);
            float x = SaveData.round(nodeAccount.getXtoSave(), 2);
            float y = SaveData.round(nodeAccount.getYtoSave(), 2);
            out.write(i + "\t" + nodeID + "\t" + shape + "\t" + size + "\t" + nodeColor + "\t" + x + "\t" + y + "\t" + nodeWeight);
            out.newLine();
        }
        out.write("node_a\tnode_b\tweight");
        out.newLine();
        for (i = 0; i < EdgeList.size(); ++i) {
            EdgeBank edgeAccount = EdgeList.get(i);
            int a = edgeAccount.getA();
            int b = edgeAccount.getB();
            double edgeWeight = SaveData.round(EdgeList.get(i).getMeanWeight(), 2);
            out.write(a + "\t" + b + "\t" + edgeWeight);
            out.newLine();
        }
        out.close();
    }

    public void customPlugins() throws IOException, JDOMException {
        System.gc();
        this.JDomXmlPluginWriter();
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals("xml")) {
            saveAddress = saveAddress + ".xml";
        }
        Format formato = Format.getPrettyFormat();
        formato.setEncoding("ISO-8859-1");
        formato.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        XMLOutputter outputter = new XMLOutputter(formato);
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress));
        outputter.output(this.doc, (Writer)out);
        out.close();
        System.gc();
    }

    public void JDomXmlPluginWriter() {
        this.doc = new Document(){};
        this.doc.addContent(new Comment("R Plugins Generated for RedeR v1.0"));
        Element pluginList = new Element("pluginlist");
        this.doc.setRootElement(pluginList);
        for (int i = 0; i < MainFrame.PluginList.size(); ++i) {
            Element att;
            int j;
            if (MainFrame.PluginList.get(i).isToDelete() || !MainFrame.PluginList.get(i).isSelected()) continue;
            Plugins pluginAccount = MainFrame.PluginList.get(i);
            String pluginName = pluginAccount.getPluginName();
            ArrayList<PluginMethods> methods = pluginAccount.getMethods();
            ArrayList<PluginAddons> addons = pluginAccount.getAddons();
            Element plugin = new Element("plugin");
            plugin.setAttribute("name", pluginName);
            pluginList.addContent(plugin);
            for (j = 0; j < methods.size(); ++j) {
                att = new Element("method");
                att.setAttribute("name", methods.get(j).getMethodName());
                att.setText(methods.get(j).getMethodCode());
                plugin.addContent(att);
            }
            for (j = 0; j < addons.size(); ++j) {
                att = new Element("addon");
                att.setAttribute("name", addons.get(j).getAddonName());
                att.setText(addons.get(j).getAddonCode());
                plugin.addContent(att);
            }
        }
    }

    public void saveWinBash() throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress + "/script.bat"));
        String RHome = MainFrame.preferences.getRHome().replace("/", "\\") + ";";
        String includeDir = MainFrame.preferences.getIncludeDir().replace("/", "\\") + ";";
        String shareDir = MainFrame.preferences.getShareDir().replace("/", "\\") + ";";
        String docDir = MainFrame.preferences.getDocDir().replace("/", "\\") + ";";
        String userLibsDir = MainFrame.preferences.getUserLibsDir().replace("/", "\\") + ";";
        String LibRHome = MainFrame.preferences.getLibRHome().replace("/", "\\") + ";";
        String localDir = MainFrame.preferences.getLocalDir().replace("/", "\\") + ";";
        String additionalPaths = MainFrame.preferences.getAdditionalPaths().replace("/", "\\");
        out.write("set PATH=%PATH%;" + RHome + includeDir + shareDir + docDir + userLibsDir + LibRHome + localDir + additionalPaths);
        out.newLine();
        out.write("set R_LIBS_USER=" + userLibsDir);
        out.newLine();
        out.write("java -jar reder.jar openshell");
        out.newLine();
        out.newLine();
        out.close();
    }

    public void saveMacBash() throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress + "/script"));
        String RHome = MainFrame.preferences.getRHome();
        String includeDir = MainFrame.preferences.getIncludeDir();
        String shareDir = MainFrame.preferences.getShareDir();
        String docDir = MainFrame.preferences.getDocDir();
        String userLibsDir = MainFrame.preferences.getUserLibsDir();
        String libRHome = MainFrame.preferences.getLibRHome();
        String localDir = MainFrame.preferences.getLocalDir();
        String additionalPaths = MainFrame.preferences.getAdditionalPaths();
        out.write("#!/bin/sh");
        out.newLine();
        out.write("R_HOME=" + RHome);
        out.newLine();
        out.write("export R_HOME");
        out.newLine();
        out.newLine();
        out.write("R_SHARE_DIR=" + shareDir);
        out.newLine();
        out.write("export R_SHARE_DIR");
        out.newLine();
        out.newLine();
        out.write("R_INCLUDE_DIR=" + includeDir);
        out.newLine();
        out.write("export R_INCLUDE_DIR");
        out.newLine();
        out.newLine();
        out.write("R_DOC_DIR=" + docDir);
        out.newLine();
        out.write("export R_DOC_DIR");
        out.newLine();
        out.newLine();
        out.write("R_LIBS_USER=" + userLibsDir);
        out.newLine();
        out.write("export R_LIBS_USER");
        out.newLine();
        out.newLine();
        out.write("PATH=$PATH:" + RHome);
        out.newLine();
        out.write("export PATH");
        out.newLine();
        out.newLine();
        out.write("PATH=$PATH:" + libRHome);
        out.newLine();
        out.write("export PATH");
        out.newLine();
        out.newLine();
        out.write("PATH=$PATH:" + localDir);
        out.newLine();
        out.write("export PATH");
        out.newLine();
        out.newLine();
        out.write("PATH=$PATH:" + additionalPaths);
        out.newLine();
        out.write("export PATH");
        out.newLine();
        out.newLine();
        out.write("java -jar \"$1/Contents/Resources/reder.jar\" openshell");
        out.newLine();
        out.newLine();
        out.close();
    }

    public void saveLinuxBash() throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(saveAddress + "/script"));
        String RHome = MainFrame.preferences.getRHome();
        String includeDir = MainFrame.preferences.getIncludeDir();
        String shareDir = MainFrame.preferences.getShareDir();
        String docDir = MainFrame.preferences.getDocDir();
        String userLibsDir = MainFrame.preferences.getUserLibsDir();
        String libRHome = MainFrame.preferences.getLibRHome();
        String localDir = MainFrame.preferences.getLocalDir();
        String additionalPaths = MainFrame.preferences.getAdditionalPaths();
        out.write("#!/bin/sh");
        out.newLine();
        out.write("R_HOME=" + RHome);
        out.newLine();
        out.write("export R_HOME");
        out.newLine();
        out.newLine();
        out.write("R_SHARE_DIR=" + shareDir);
        out.newLine();
        out.write("export R_SHARE_DIR");
        out.newLine();
        out.newLine();
        out.write("R_INCLUDE_DIR=" + includeDir);
        out.newLine();
        out.write("export R_INCLUDE_DIR");
        out.newLine();
        out.newLine();
        out.write("R_DOC_DIR=" + docDir);
        out.newLine();
        out.write("export R_DOC_DIR");
        out.newLine();
        out.newLine();
        out.write("R_LIBS_USER=" + userLibsDir);
        out.newLine();
        out.write("export R_LIBS_USER");
        out.newLine();
        out.newLine();
        out.write("LD_LIBRARY_PATH=$LD_LIBRARY_PATH:" + RHome);
        out.newLine();
        out.write("export LD_LIBRARY_PATH");
        out.newLine();
        out.newLine();
        out.write("LD_LIBRARY_PATH=$LD_LIBRARY_PATH:" + libRHome);
        out.newLine();
        out.write("export LD_LIBRARY_PATH");
        out.newLine();
        out.newLine();
        out.write("LD_LIBRARY_PATH=$LD_LIBRARY_PATH:" + localDir);
        out.newLine();
        out.write("export LD_LIBRARY_PATH");
        out.newLine();
        out.newLine();
        out.write("LD_LIBRARY_PATH=$LD_LIBRARY_PATH:" + additionalPaths);
        out.newLine();
        out.write("export LD_LIBRARY_PATH");
        out.newLine();
        out.newLine();
        out.write("java -jar ./reder.jar openshell");
        out.newLine();
        out.newLine();
        out.close();
    }

    public static float round(float val, int places) {
        return (float)SaveData.round((double)val, places);
    }

    public static double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }
}

