### R code from vignette source 'NormqPCR.Rnw'

###################################################
### code chunk number 1: read.qPCR.tech.reps
###################################################
library(ReadqPCR) # load the ReadqPCR library
library(NormqPCR)
path <- system.file("exData", package = "NormqPCR")
qPCR.example.techReps <- file.path(path, "qPCR.techReps.txt")
qPCRBatch.qPCR.techReps <- read.qPCR(qPCR.example.techReps)
rownames(exprs(qPCRBatch.qPCR.techReps))[1:8]


###################################################
### code chunk number 2: combine read.qPCR.tech.reps
###################################################
combinedTechReps <- combineTechReps(qPCRBatch.qPCR.techReps)
combinedTechReps


###################################################
### code chunk number 3: taqman read
###################################################
path <- system.file("exData", package = "NormqPCR")
taqman.example <- file.path(path, "/example.txt")
qPCRBatch.taqman <- read.taqman(taqman.example)


###################################################
### code chunk number 4: taqman detector example
###################################################
exprs(qPCRBatch.taqman)["Ccl20.Rn00570287_m1",]


###################################################
### code chunk number 5: replace above cutoff
###################################################
qPCRBatch.taqman.replaced <- replaceAboveCutOff(qPCRBatch.taqman, newVal = NA,
cutOff = 35)
exprs(qPCRBatch.taqman.replaced)["Ccl20.Rn00570287_m1",]


###################################################
### code chunk number 6: replace NAs with 40
###################################################
qPCRBatch.taqman.replaced <- replaceNAs(qPCRBatch.taqman, newNA = 40)
exprs(qPCRBatch.taqman.replaced)["Ccl20.Rn00570287_m1",]


###################################################
### code chunk number 7: construct contrast matrix
###################################################
sampleNames(qPCRBatch.taqman)
a <- c(0,0,1,1,0,0,1,1) # one for each sample type, with 1 representing
b <- c(1,1,0,0,1,1,0,0) # position of sample type in the samplenames vector 
contM <- cbind(a,b)
colnames(contM) <- c("case","control") # then give the names of each sample type
rownames(contM) <- sampleNames(qPCRBatch.taqman) # and the rows of the matrix
contM
sMaxM <- t(as.matrix(c(3,3))) # now make the contrast matrix
colnames(sMaxM) <- c("case","control") # make sure these line up with samples
sMaxM


###################################################
### code chunk number 8: replace 3 or more NAs with all NAs
###################################################
qPCRBatch.taqman.replaced <- makeAllNAs(qPCRBatch.taqman, contM, sMaxM)


###################################################
### code chunk number 9: ccl20 is now all NAs
###################################################
exprs(qPCRBatch.taqman.replaced)["Ccl20.Rn00570287_m1",]


###################################################
### code chunk number 10: NormqPCR
###################################################
options(width = 68)
data(geNorm)
str(exprs(geNorm.qPCRBatch))


###################################################
### code chunk number 11: geNorm
###################################################

tissue <- as.factor(c(rep("BM", 9),  rep("FIB", 20), rep("LEU", 13),
                    rep("NB", 34), rep("POOL", 9)))
res.BM <- selectHKs(geNorm.qPCRBatch[,tissue == "BM"], method = "geNorm", 
                    Symbols = featureNames(geNorm.qPCRBatch), minNrHK = 2, log = FALSE)
res.POOL <- selectHKs(geNorm.qPCRBatch[,tissue == "POOL"], method = "geNorm", 
                      Symbols = featureNames(geNorm.qPCRBatch), minNrHK = 2, 
                      trace = FALSE, log = FALSE)
res.FIB <- selectHKs(geNorm.qPCRBatch[,tissue == "FIB"], method = "geNorm", 
                     Symbols = featureNames(geNorm.qPCRBatch), minNrHK = 2, 
                     trace = FALSE, log = FALSE)
res.LEU <- selectHKs(geNorm.qPCRBatch[,tissue == "LEU"], method = "geNorm", 
                     Symbols = featureNames(geNorm.qPCRBatch), minNrHK = 2, 
                     trace = FALSE, log = FALSE)
res.NB <- selectHKs(geNorm.qPCRBatch[,tissue == "NB"], method = "geNorm", 
                    Symbols = featureNames(geNorm.qPCRBatch), minNrHK = 2, 
                    trace = FALSE, log = FALSE)


###################################################
### code chunk number 12: table3
###################################################
ranks <- data.frame(c(1, 1:9), res.BM$ranking, res.POOL$ranking, 
                    res.FIB$ranking, res.LEU$ranking, 
                    res.NB$ranking)
names(ranks) <- c("rank", "BM", "POOL", "FIB", "LEU", "NB")
ranks


###################################################
### code chunk number 13: fig2
###################################################
library(RColorBrewer)
mypalette <- brewer.pal(5, "Set1")
matplot(cbind(res.BM$meanM, res.POOL$meanM, res.FIB$meanM, 
              res.LEU$meanM, res.NB$meanM), type = "b", 
        ylab = "Average expression stability M", 
        xlab = "Number of remaining control genes", 
        axes = FALSE, pch = 19, col = mypalette, 
        ylim = c(0.2, 1.22), lty = 1, lwd = 2, 
        main = "Figure 2 in Vandesompele et al. (2002)")
axis(1, at = 1:9, labels = as.character(10:2))
axis(2, at = seq(0.2, 1.2, by = 0.2), labels = seq(0.2, 1.2, by = 0.2))
box()
abline(h = seq(0.2, 1.2, by = 0.2), lty = 2, lwd = 1, col = "grey")
legend("topright", legend = c("BM", "POOL", "FIB", "LEU", "NB"), 
       fill = mypalette)


###################################################
### code chunk number 14: fig3a
###################################################
mypalette <- brewer.pal(8, "YlGnBu")
barplot(cbind(res.POOL$variation, res.LEU$variation, res.NB$variation, 
              res.FIB$variation, res.BM$variation), beside = TRUE, 
        col = mypalette, space = c(0, 2), 
        names.arg = c("POOL", "LEU", "NB", "FIB", "BM"),
        ylab = "Pairwise variation V",
        main = "Figure 3(a) in Vandesompele et al. (2002)")
legend("topright", legend = c("V9/10", "V8/9", "V7/8", "V6/7", 
                              "V5/6", "V4/5", "V3/4", "V2/3"), 
       fill = mypalette, ncol = 2)
abline(h = seq(0.05, 0.25, by = 0.05), lty = 2, col = "grey")
abline(h = 0.15, lty = 1, col = "black")


###################################################
### code chunk number 15: NormFinder
###################################################
data(Colon)
str(exprs(Colon.qPCRBatch))
group <- pData(Colon.qPCRBatch)[,"Group"]
res.Colon <- stabMeasureRho(Colon.qPCRBatch, group = group,
                            log = FALSE)
sort(res.Colon) # cf. Table 3 in Andersen et al (2004)

data(Bladder)
str(exprs(Bladder.qPCRBatch))
group <- pData(Bladder.qPCRBatch)[,"Group"]
cat("test1")
res.Bladder <- stabMeasureRho(Bladder.qPCRBatch, group = group,
                              log = FALSE)
cat("test test")
sort(res.Bladder)


###################################################
### code chunk number 16: NormFinder1
###################################################
selectHKs(Colon.qPCRBatch, log = FALSE, trace = FALSE, 
          Symbols = featureNames(Colon.qPCRBatch))$ranking
selectHKs(Bladder.qPCRBatch, log = FALSE, trace = FALSE, 
          Symbols = featureNames(Bladder.qPCRBatch))$ranking


###################################################
### code chunk number 17: NormFinder2
###################################################
group <- pData(Colon.qPCRBatch)[,"Group"]
selectHKs(Colon.qPCRBatch, 
          log = FALSE, trace = TRUE, group = group,
          Symbols = featureNames(Colon.qPCRBatch), minNrHKs = 12,
          method = "NormFinder")$ranking
group <- pData(Bladder.qPCRBatch)[,"Group"]
selectHKs(Bladder.qPCRBatch, group = group,
          log = FALSE, trace = FALSE, 
          Symbols = featureNames(Bladder.qPCRBatch), minNrHKs = 13,
          method = "NormFinder")$ranking


###################################################
### code chunk number 18: taqman read dCt
###################################################
path <- system.file("exData", package = "NormqPCR")
taqman.example <- file.path(path, "example.txt")
qPCR.example <- file.path(path, "qPCR.example.txt")
qPCRBatch.taqman <- read.taqman(taqman.example)


###################################################
### code chunk number 19: dCt
###################################################
hkgs<-"Actb-Rn00667869_m1"
qPCRBatch.norm <- deltaCt(qPCRBatch =  qPCRBatch.taqman, hkgs = hkgs, calc="arith")
head(exprs(qPCRBatch.norm))


###################################################
### code chunk number 20: dCt many genes
###################################################
hkgs<-c("Actb-Rn00667869_m1", "B2m-Rn00560865_m1", "Gapdh-Rn99999916_s1")
qPCRBatch.norm <- deltaCt(qPCRBatch =  qPCRBatch.taqman, hkgs = hkgs, calc="arith")
head(exprs(qPCRBatch.norm))


###################################################
### code chunk number 21: taqman read
###################################################
path <- system.file("exData", package = "NormqPCR")
taqman.example <- file.path(path, "example.txt")
qPCR.example <- file.path(path, "qPCR.example.txt")
qPCRBatch.taqman <- read.taqman(taqman.example)


###################################################
### code chunk number 22: contrast
###################################################
contM <- cbind(c(0,0,1,1,0,0,1,1),c(1,1,0,0,1,1,0,0))
colnames(contM) <- c("interestingPhenotype","wildTypePhenotype")
rownames(contM) <- sampleNames(qPCRBatch.taqman)
contM


###################################################
### code chunk number 23: ddCt
###################################################
hkg <- "Actb-Rn00667869_m1"
ddCt.taqman <- deltaDeltaCt(qPCRBatch = qPCRBatch.taqman, maxNACase=1, maxNAControl=1, hkg=hkg, contrastM=contM, case="interestingPhenotype", control="wildTypePhenotype", statCalc="geom", hkgCalc="arith")
head(ddCt.taqman)


###################################################
### code chunk number 24: ddCt Avg
###################################################
hkg <- "Actb-Rn00667869_m1"
ddCtAvg.taqman <- deltaDeltaCt(qPCRBatch = qPCRBatch.taqman, maxNACase=1, maxNAControl=1, hkg=hkg, contrastM=contM, case="interestingPhenotype", control="wildTypePhenotype", paired=FALSE, statCalc="geom", hkgCalc="arith")
head(ddCtAvg.taqman)


###################################################
### code chunk number 25: taqman gM
###################################################
qPCRBatch.taqman <- read.taqman(taqman.example)
contM <- cbind(c(0,0,1,1,0,0,1,1),c(1,1,0,0,1,1,0,0))
colnames(contM) <- c("interestingPhenotype","wildTypePhenotype")
rownames(contM) <- sampleNames(qPCRBatch.taqman)
hkgs<-c("Actb-Rn00667869_m1", "B2m-Rn00560865_m1", "Gapdh-Rn99999916_s1")
ddCt.gM.taqman <- deltaDeltaCt(qPCRBatch = qPCRBatch.taqman, maxNACase=1, maxNAControl=1, hkgs=hkgs, contrastM=contM, case="interestingPhenotype", control="wildTypePhenotype", statCalc="arith", hkgCalc="arith")
head(ddCt.gM.taqman)


###################################################
### code chunk number 26: taqman gM Avg
###################################################
qPCRBatch.taqman <- read.taqman(taqman.example)
contM <- cbind(c(0,0,1,1,0,0,1,1),c(1,1,0,0,1,1,0,0))
colnames(contM) <- c("interestingPhenotype","wildTypePhenotype")
rownames(contM) <- sampleNames(qPCRBatch.taqman)
hkgs<-c("Actb-Rn00667869_m1", "B2m-Rn00560865_m1", "Gapdh-Rn99999916_s1")
ddAvgCt.gM.taqman <-deltaDeltaCt(qPCRBatch = qPCRBatch.taqman, maxNACase=1, maxNAControl=1, hkgs=hkgs, contrastM=contM, case="interestingPhenotype", control="wildTypePhenotype", paired=FALSE, statCalc="arith", hkgCalc="arith")
head(ddAvgCt.gM.taqman)


