/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import ding.view.DGraphView;
import ding.view.ViewState;
import javax.swing.undo.AbstractUndoableEdit;
import undo.Undo;

public class ViewChangeEdit
extends AbstractUndoableEdit {
    private ViewState origState;
    private ViewState newState;
    private DGraphView m_view;
    private String m_label;
    private SavedObjs m_savedObjs;

    public ViewChangeEdit(DGraphView view, String label) {
        this(view, SavedObjs.ALL, label);
    }

    public ViewChangeEdit(DGraphView view, SavedObjs saveObjs, String label) {
        this.m_view = view;
        this.m_label = label;
        this.m_savedObjs = saveObjs;
        this.saveOldPositions();
    }

    protected void saveOldPositions() {
        this.origState = new ViewState(this.m_view, this.m_savedObjs);
    }

    protected void saveNewPositions() {
        this.newState = new ViewState(this.m_view, this.m_savedObjs);
    }

    public void post() {
        this.saveNewPositions();
        if (!this.origState.equals(this.newState)) {
            Undo.getUndoableEditSupport().postEdit(this);
        }
    }

    public String getPresentationName() {
        return this.m_label;
    }

    public String getRedoPresentationName() {
        return "Redo: " + this.m_label;
    }

    public String getUndoPresentationName() {
        return "Undo: " + this.m_label;
    }

    public void redo() {
        super.redo();
        this.newState.apply();
    }

    public void undo() {
        super.undo();
        this.origState.apply();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SavedObjs {
        ALL,
        SELECTED,
        NODES,
        EDGES,
        SELECTED_NODES,
        SELECTED_EDGES;

    }
}

