/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.AbstractMapping;
import cytoscape.visual.mappings.discrete.DiscreteLegend;
import cytoscape.visual.mappings.discrete.DiscreteMappingReader;
import cytoscape.visual.mappings.discrete.DiscreteMappingWriter;
import cytoscape.visual.mappings.discrete.DiscreteRangeCalculator;
import cytoscape.visual.parsers.ValueParser;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteMapping
extends AbstractMapping {
    private static final Class<?>[] ACCEPTED_CLASSES = new Class[]{String.class, Number.class, Integer.class, Double.class, Float.class, Long.class, Short.class, NodeShape.class, List.class, Boolean.class};
    private SortedMap treeMap = new TreeMap();
    private Object lastKey;

    @Deprecated
    public DiscreteMapping(Object defObj, byte mapType) {
        this(defObj, null, mapType);
    }

    @Deprecated
    public DiscreteMapping(Object defObj, String attrName, byte mapType) {
        this(defObj.getClass(), attrName);
    }

    public DiscreteMapping(Class<?> rangeClass, String controllingAttrName) {
        super(rangeClass, controllingAttrName);
        this.acceptedClasses = ACCEPTED_CLASSES;
    }

    @Override
    public Object clone() {
        DiscreteMapping clone = new DiscreteMapping(this.rangeClass, this.controllingAttrName);
        for (ChangeListener listener : this.observers) {
            clone.addChangeListener(listener);
        }
        for (Object key : this.treeMap.keySet()) {
            clone.treeMap.put(key, this.treeMap.get(key));
        }
        return clone;
    }

    public Object getMapValue(Object key) {
        return this.treeMap.get(key);
    }

    public void putMapValue(Object key, Object value) {
        this.lastKey = key;
        this.treeMap.put(key, value);
        this.fireStateChanged();
    }

    public Object getLastKeyModified() {
        return this.lastKey;
    }

    public void putAll(Map map) {
        this.treeMap.putAll(map);
    }

    public Map getAll() {
        return this.treeMap;
    }

    @Override
    public void applyProperties(Properties props, String baseKey, ValueParser parser) {
        DiscreteMappingReader reader = new DiscreteMappingReader(props, baseKey, parser);
        String contValue = reader.getControllingAttributeName();
        if (contValue != null) {
            this.setControllingAttributeName(contValue);
        }
        this.treeMap = reader.getMap();
    }

    @Override
    public Properties getProperties(String baseKey) {
        DiscreteMappingWriter writer = new DiscreteMappingWriter(this.controllingAttrName, baseKey, this.treeMap);
        return writer.getProperties();
    }

    @Override
    public Object calculateRangeValue(Map<String, Object> attrBundle) {
        DiscreteRangeCalculator calculator = new DiscreteRangeCalculator(this.treeMap, this.controllingAttrName);
        return calculator.calculateRangeValue(attrBundle);
    }

    @Override
    public JPanel getLegend(VisualPropertyType vpt) {
        return new DiscreteLegend(this.treeMap, this.controllingAttrName, vpt);
    }
}

