/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.CyAttributesReader;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.util.FileUtil;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualMappingManager;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Font;
import java.io.FileReader;
import java.util.Properties;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VisualMappingManagerTest
extends TestCase {
    CyNetwork cyNet;
    CyNode a;
    CyNode b;
    CyNode c;
    CyEdge ab;
    CalculatorCatalog catalog;
    Properties props;

    public VisualMappingManagerTest(String name) {
        super(name);
    }

    public void setUp() {
        System.out.println("setup begin");
        this.cyNet = Cytoscape.createNetworkFromFile("testData/small.sif");
        this.a = Cytoscape.getCyNode("a");
        this.b = Cytoscape.getCyNode("b");
        this.c = Cytoscape.getCyNode("c");
        this.ab = Cytoscape.getCyEdge(this.a, this.b, "interaction", "pp", false);
        this.props = new Properties();
        try {
            CyAttributesReader.loadAttributes(Cytoscape.getNodeAttributes(), new FileReader("testData/small.nodeAttr"));
            this.props.load(FileUtil.getInputStream("testData/small.vizmap.props"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.catalog = new CalculatorCatalog();
        CalculatorIO.loadCalculators(this.props, this.catalog, true);
        System.out.println("setup end");
    }

    public void testBypass() throws Exception {
        Color fillColor = new Color(63, 128, 255);
        Color borderColor = new Color(100, 100, 50);
        NodeShape shape = NodeShape.DIAMOND;
        double width = 49.0;
        double height = 79.0;
        String label = "testLabel";
        String toolTip = "testToolTip";
        Font font = new Font("SansSerif", 2, 10);
        String fontString = "SansSerif,italic,10";
        CytoscapeRootGraph graph = Cytoscape.getRootGraph();
        int index1 = graph.createNode();
        Node first = graph.getNode(index1);
        int index2 = graph.createNode();
        Node second = graph.getNode(index2);
        CyNetwork network2 = Cytoscape.createNetwork(Cytoscape.getRootGraph().getNodeIndicesArray(), Cytoscape.getRootGraph().getEdgeIndicesArray(), null);
        CyAttributes secondNodeAttr = Cytoscape.getNodeAttributes();
        String secondName = second.getIdentifier();
        secondNodeAttr.setAttribute(secondName, "node.fillColor", "63,128,255");
        secondNodeAttr.setAttribute(secondName, "node.borderColor", "100,100,50");
        secondNodeAttr.setAttribute(secondName, "node.size", "32.0");
        CyNetworkView view = Cytoscape.getNetworkView(network2.getIdentifier());
        NodeView nv = view.getNodeView(index2);
        VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
        vmm.setNetworkView(view);
        vmm.setVisualStyle(view.getVisualStyle());
        vmm.vizmapNode(nv, view);
        VisualMappingManagerTest.assertEquals(fillColor, nv.getUnselectedPaint());
        VisualMappingManagerTest.assertEquals(borderColor, nv.getBorderPaint());
        VisualMappingManagerTest.assertEquals(32.0, nv.getWidth());
        VisualMappingManagerTest.assertEquals(32.0, nv.getHeight());
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(VisualMappingManagerTest.class));
    }
}

