/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.geom.rtree;

import cytoscape.geom.rtree.ObjStack;
import cytoscape.geom.spacial.MutableSpacialIndex2D;
import cytoscape.geom.spacial.SpacialEntry2DEnumerator;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntObjHash;
import cytoscape.util.intr.IntStack;
import java.io.Serializable;
import java.util.Iterator;

public final class RTree
implements MutableSpacialIndex2D,
Serializable {
    public static final int DEFAULT_MAX_BRANCHES = 11;
    private final float[] m_MBR;
    private final int m_maxBranches;
    private final int m_minBranches;
    private Node m_root;
    private IntObjHash m_entryMap;
    private final Object m_deletedEntry = "";
    private int m_deletedEntries;
    private int m_mapExpansionThreshold;
    private final int[] m_objKeyBuff;
    private final Node[] m_childrenBuff;
    private final float[] m_xMinBuff;
    private final float[] m_yMinBuff;
    private final float[] m_xMaxBuff;
    private final float[] m_yMaxBuff;
    private final float[] m_tempBuff1;
    private final float[] m_tempBuff2;
    private final float[] m_extentsStack;
    private final ObjStack m_nodeStack;

    public RTree() {
        this(11);
    }

    public RTree(int maxBranches) {
        if (maxBranches < 3) {
            throw new IllegalArgumentException("maxBranches is less than three");
        }
        this.m_MBR = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        this.m_maxBranches = maxBranches;
        this.m_minBranches = Math.max(2, (int)((double)(this.m_maxBranches + 1) * 0.4));
        this.m_root = new Node(this.m_maxBranches, true);
        this.m_entryMap = new IntObjHash();
        this.m_deletedEntries = 0;
        this.m_mapExpansionThreshold = IntObjHash.maxCapacity(this.m_entryMap.size());
        this.m_objKeyBuff = new int[this.m_maxBranches + 1];
        this.m_childrenBuff = new Node[this.m_maxBranches + 1];
        this.m_xMinBuff = new float[this.m_maxBranches + 1];
        this.m_yMinBuff = new float[this.m_maxBranches + 1];
        this.m_xMaxBuff = new float[this.m_maxBranches + 1];
        this.m_yMaxBuff = new float[this.m_maxBranches + 1];
        this.m_tempBuff1 = new float[this.m_maxBranches + 1];
        this.m_tempBuff2 = new float[this.m_maxBranches + 1];
        this.m_extentsStack = new float[560];
        this.m_nodeStack = new ObjStack();
    }

    public final void empty() {
        this.m_root = new Node(this.m_maxBranches, true);
        this.m_entryMap = new IntObjHash();
        this.m_deletedEntries = 0;
        this.m_mapExpansionThreshold = IntObjHash.maxCapacity(this.m_entryMap.size());
    }

    public final int size() {
        return RTree.isLeafNode(this.m_root) ? this.m_root.entryCount : this.m_root.data.deepCount;
    }

    private static final boolean isLeafNode(Node n) {
        return n.data == null;
    }

    public final void insert(int objKey, float xMin, float yMin, float xMax, float yMax) {
        if (objKey < 0) {
            throw new IllegalArgumentException("objKey is negative");
        }
        if (!(xMin <= xMax)) {
            throw new IllegalArgumentException("xMin <= xMax not true");
        }
        if (!(yMin <= yMax)) {
            throw new IllegalArgumentException("yMin <= yMax not true");
        }
        if (this.m_entryMap.get(objKey) != null) {
            if (this.m_entryMap.get(objKey) != this.m_deletedEntry) {
                throw new IllegalStateException("objkey " + objKey + " is already in this tree");
            }
            --this.m_deletedEntries;
        } else if (this.m_entryMap.size() == this.m_mapExpansionThreshold) {
            if (this.m_deletedEntries * 4 > this.m_entryMap.size()) {
                IntObjHash newEntryMap = new IntObjHash();
                IntEnumerator objKeys = this.m_entryMap.keys();
                Iterator leafNodes = this.m_entryMap.values();
                while (objKeys.numRemaining() > 0) {
                    Object leafNode = leafNodes.next();
                    if (leafNode == this.m_deletedEntry) {
                        objKeys.nextInt();
                        continue;
                    }
                    newEntryMap.put(objKeys.nextInt(), leafNode);
                }
                this.m_entryMap = newEntryMap;
                this.m_deletedEntries = 0;
            }
            this.m_mapExpansionThreshold = IntObjHash.maxCapacity(this.m_entryMap.size() + 1);
        }
        Node rootSplit = RTree.insert(this.m_root, objKey, xMin, yMin, xMax, yMax, this.m_maxBranches, this.m_minBranches, this.m_entryMap, this.m_MBR, this.m_objKeyBuff, this.m_childrenBuff, this.m_xMinBuff, this.m_yMinBuff, this.m_xMaxBuff, this.m_yMaxBuff, this.m_tempBuff1, this.m_tempBuff2);
        if (rootSplit != null) {
            Node newRoot = new Node(this.m_maxBranches, false);
            newRoot.entryCount = 2;
            this.m_root.parent = newRoot;
            rootSplit.parent = newRoot;
            ((InternalNodeData)((Node)newRoot).data).children[0] = this.m_root;
            ((InternalNodeData)((Node)newRoot).data).children[1] = rootSplit;
            ((Node)newRoot).xMins[0] = this.m_root.xMins[this.m_maxBranches - 1];
            ((Node)newRoot).yMins[0] = this.m_root.yMins[this.m_maxBranches - 1];
            ((Node)newRoot).xMaxs[0] = this.m_root.xMaxs[this.m_maxBranches - 1];
            ((Node)newRoot).yMaxs[0] = this.m_root.yMaxs[this.m_maxBranches - 1];
            ((Node)newRoot).xMins[1] = rootSplit.xMins[this.m_maxBranches - 1];
            ((Node)newRoot).yMins[1] = rootSplit.yMins[this.m_maxBranches - 1];
            ((Node)newRoot).xMaxs[1] = rootSplit.xMaxs[this.m_maxBranches - 1];
            ((Node)newRoot).yMaxs[1] = rootSplit.yMaxs[this.m_maxBranches - 1];
            if (RTree.isLeafNode(this.m_root)) {
                newRoot.data.deepCount = this.m_root.entryCount + rootSplit.entryCount;
            } else {
                newRoot.data.deepCount = this.m_root.data.deepCount + rootSplit.data.deepCount;
            }
            this.m_root = newRoot;
            this.m_MBR[0] = Math.min(this.m_root.xMins[0], this.m_root.xMins[1]);
            this.m_MBR[1] = Math.min(this.m_root.yMins[0], this.m_root.yMins[1]);
            this.m_MBR[2] = Math.max(this.m_root.xMaxs[0], this.m_root.xMaxs[1]);
            this.m_MBR[3] = Math.max(this.m_root.yMaxs[0], this.m_root.yMaxs[1]);
        }
    }

    private static final Node insert(Node root, int objKey, float xMin, float yMin, float xMax, float yMax, int maxBranches, int minBranches, IntObjHash entryMap, float[] globalMBR, int[] objKeyBuff, Node[] childrenBuff, float[] xMinBuff, float[] yMinBuff, float[] xMaxBuff, float[] yMaxBuff, float[] tempBuff1, float[] tempBuff2) {
        int i;
        boolean deepCountIncrease = true;
        Node chosenLeaf = RTree.chooseLeaf(root, xMin, yMin, xMax, yMax);
        if (chosenLeaf.entryCount < maxBranches) {
            int newInx = chosenLeaf.entryCount++;
            ((Node)chosenLeaf).objKeys[newInx] = objKey;
            ((Node)chosenLeaf).xMins[newInx] = xMin;
            ((Node)chosenLeaf).yMins[newInx] = yMin;
            ((Node)chosenLeaf).xMaxs[newInx] = xMax;
            ((Node)chosenLeaf).yMaxs[newInx] = yMax;
            entryMap.put(objKey, chosenLeaf);
            RTree.adjustTreeNoSplit(chosenLeaf, 1, globalMBR);
            return null;
        }
        Node newLeaf = RTree.splitLeafNode(chosenLeaf, objKey, xMin, yMin, xMax, yMax, maxBranches, minBranches, objKeyBuff, xMinBuff, yMinBuff, xMaxBuff, yMaxBuff, tempBuff1, tempBuff2);
        for (i = 0; i < chosenLeaf.entryCount; ++i) {
            entryMap.put(chosenLeaf.objKeys[i], chosenLeaf);
        }
        for (i = 0; i < newLeaf.entryCount; ++i) {
            entryMap.put(newLeaf.objKeys[i], newLeaf);
        }
        return RTree.adjustTreeWithSplit(chosenLeaf, newLeaf, 1, maxBranches, minBranches, globalMBR, childrenBuff, xMinBuff, yMinBuff, xMaxBuff, yMaxBuff, tempBuff1, tempBuff2);
    }

    private static final Node insert(Node root, int depth, Node n, float xMin, float yMin, float xMax, float yMax, int maxBranches, int minBranches, float[] globalMBR, Node[] childrenBuff, float[] xMinBuff, float[] yMinBuff, float[] xMaxBuff, float[] yMaxBuff, float[] tempBuff1, float[] tempBuff2) {
        int deepCountIncrease = RTree.isLeafNode(n) ? n.entryCount : n.data.deepCount;
        Node chosenParent = RTree.chooseParent(root, depth, xMin, yMin, xMax, yMax);
        if (chosenParent.entryCount < maxBranches) {
            int newInx = chosenParent.entryCount++;
            n.parent = chosenParent;
            ((InternalNodeData)((Node)chosenParent).data).children[newInx] = n;
            ((Node)chosenParent).xMins[newInx] = xMin;
            ((Node)chosenParent).yMins[newInx] = yMin;
            ((Node)chosenParent).xMaxs[newInx] = xMax;
            ((Node)chosenParent).yMaxs[newInx] = yMax;
            chosenParent.data.deepCount += deepCountIncrease;
            RTree.adjustTreeNoSplit(chosenParent, deepCountIncrease, globalMBR);
            return null;
        }
        Node parentSibling = RTree.splitInternalNode(chosenParent, n, xMin, yMin, xMax, yMax, maxBranches, minBranches, childrenBuff, xMinBuff, yMinBuff, xMaxBuff, yMaxBuff, tempBuff1, tempBuff2);
        return RTree.adjustTreeWithSplit(chosenParent, parentSibling, deepCountIncrease, maxBranches, minBranches, globalMBR, childrenBuff, xMinBuff, yMinBuff, xMaxBuff, yMaxBuff, tempBuff1, tempBuff2);
    }

    private static final Node chooseLeaf(Node root, float xMin, float yMin, float xMax, float yMax) {
        Node n = root;
        while (!RTree.isLeafNode(n)) {
            n = n.data.children[RTree.chooseSubtree(n, xMin, yMin, xMax, yMax)];
        }
        return n;
    }

    private static final Node chooseParent(Node root, int depth, float xMin, float yMin, float xMax, float yMax) {
        Node n = root;
        for (int currDepth = 0; currDepth != depth; ++currDepth) {
            n = n.data.children[RTree.chooseSubtree(n, xMin, yMin, xMax, yMax)];
        }
        return n;
    }

    private static final int chooseSubtree(Node n, float xMin, float yMin, float xMax, float yMax) {
        float bestAreaDelta = Float.POSITIVE_INFINITY;
        float bestArea = Float.POSITIVE_INFINITY;
        int bestInx = -1;
        for (int i = 0; i < n.entryCount; ++i) {
            float currArea = (n.xMaxs[i] - n.xMins[i]) * (n.yMaxs[i] - n.yMins[i]);
            float newArea = (Math.max(n.xMaxs[i], xMax) - Math.min(n.xMins[i], xMin)) * (Math.max(n.yMaxs[i], yMax) - Math.min(n.yMins[i], yMin));
            float currAreaDelta = newArea - currArea;
            if (!(currAreaDelta < bestAreaDelta) && (currAreaDelta != bestAreaDelta || !(currArea < bestArea))) continue;
            bestAreaDelta = currAreaDelta;
            bestArea = currArea;
            bestInx = i;
        }
        return bestInx;
    }

    private static final Node splitLeafNode(Node fullLeafNode, int newObjKey, float newXMin, float newYMin, float newXMax, float newYMax, int maxBranches, int minBranches, int[] objKeyBuff, float[] xMinBuff, float[] yMinBuff, float[] xMaxBuff, float[] yMaxBuff, float[] tempBuff1, float[] tempBuff2) {
        for (int i = 0; i < fullLeafNode.entryCount; ++i) {
            objKeyBuff[i] = fullLeafNode.objKeys[i];
            xMinBuff[i] = fullLeafNode.xMins[i];
            yMinBuff[i] = fullLeafNode.yMins[i];
            xMaxBuff[i] = fullLeafNode.xMaxs[i];
            yMaxBuff[i] = fullLeafNode.yMaxs[i];
        }
        objKeyBuff[((Node)fullLeafNode).entryCount] = newObjKey;
        xMinBuff[((Node)fullLeafNode).entryCount] = newXMin;
        yMinBuff[((Node)fullLeafNode).entryCount] = newYMin;
        xMaxBuff[((Node)fullLeafNode).entryCount] = newXMax;
        yMaxBuff[((Node)fullLeafNode).entryCount] = newYMax;
        int totalEntries = fullLeafNode.entryCount + 1;
        long seeds = RTree.pickSeeds(totalEntries, xMinBuff, yMinBuff, xMaxBuff, yMaxBuff, tempBuff1);
        int seed1 = (int)(seeds >> 32);
        ((Node)fullLeafNode).objKeys[0] = objKeyBuff[seed1];
        ((Node)fullLeafNode).xMins[0] = xMinBuff[seed1];
        ((Node)fullLeafNode).yMins[0] = yMinBuff[seed1];
        ((Node)fullLeafNode).xMaxs[0] = xMaxBuff[seed1];
        ((Node)fullLeafNode).yMaxs[0] = yMaxBuff[seed1];
        fullLeafNode.entryCount = 1;
        int seed2 = (int)seeds;
        Node returnThis = new Node(maxBranches, true);
        ((Node)returnThis).objKeys[0] = objKeyBuff[seed2];
        ((Node)returnThis).xMins[0] = xMinBuff[seed2];
        ((Node)returnThis).yMins[0] = yMinBuff[seed2];
        ((Node)returnThis).xMaxs[0] = xMaxBuff[seed2];
        ((Node)returnThis).yMaxs[0] = yMaxBuff[seed2];
        returnThis.entryCount = 1;
        ((Node)fullLeafNode).xMins[maxBranches - 1] = fullLeafNode.xMins[0];
        ((Node)fullLeafNode).yMins[maxBranches - 1] = fullLeafNode.yMins[0];
        ((Node)fullLeafNode).xMaxs[maxBranches - 1] = fullLeafNode.xMaxs[0];
        ((Node)fullLeafNode).yMaxs[maxBranches - 1] = fullLeafNode.yMaxs[0];
        ((Node)returnThis).xMins[maxBranches - 1] = returnThis.xMins[0];
        ((Node)returnThis).yMins[maxBranches - 1] = returnThis.yMins[0];
        ((Node)returnThis).xMaxs[maxBranches - 1] = returnThis.xMaxs[0];
        ((Node)returnThis).yMaxs[maxBranches - 1] = returnThis.yMaxs[0];
        int entriesRemaining = totalEntries;
        if (seed2 != --entriesRemaining) {
            objKeyBuff[seed2] = objKeyBuff[entriesRemaining];
            xMinBuff[seed2] = xMinBuff[entriesRemaining];
            yMinBuff[seed2] = yMinBuff[entriesRemaining];
            xMaxBuff[seed2] = xMaxBuff[entriesRemaining];
            yMaxBuff[seed2] = yMaxBuff[entriesRemaining];
        }
        if (seed1 != --entriesRemaining) {
            objKeyBuff[seed1] = objKeyBuff[entriesRemaining];
            xMinBuff[seed1] = xMinBuff[entriesRemaining];
            yMinBuff[seed1] = yMinBuff[entriesRemaining];
            xMaxBuff[seed1] = xMaxBuff[entriesRemaining];
            yMaxBuff[seed1] = yMaxBuff[entriesRemaining];
        }
        boolean buff1Valid = false;
        boolean buff2Valid = false;
        while (entriesRemaining != 0) {
            float[] validTempBuff;
            Node chosenGroup;
            float group2Area;
            float group1Area;
            Node restGroup = entriesRemaining + fullLeafNode.entryCount == minBranches ? fullLeafNode : (entriesRemaining + returnThis.entryCount == minBranches ? returnThis : null);
            if (restGroup != null) {
                for (int i = 0; i < entriesRemaining; ++i) {
                    int newInx = restGroup.entryCount++;
                    ((Node)restGroup).objKeys[newInx] = objKeyBuff[i];
                    ((Node)restGroup).xMins[newInx] = xMinBuff[i];
                    ((Node)restGroup).yMins[newInx] = yMinBuff[i];
                    ((Node)restGroup).xMaxs[newInx] = xMaxBuff[i];
                    ((Node)restGroup).yMaxs[newInx] = yMaxBuff[i];
                    ((Node)restGroup).xMins[maxBranches - 1] = Math.min(restGroup.xMins[maxBranches - 1], xMinBuff[i]);
                    ((Node)restGroup).yMins[maxBranches - 1] = Math.min(restGroup.yMins[maxBranches - 1], yMinBuff[i]);
                    ((Node)restGroup).xMaxs[maxBranches - 1] = Math.max(restGroup.xMaxs[maxBranches - 1], xMaxBuff[i]);
                    ((Node)restGroup).yMaxs[maxBranches - 1] = Math.max(restGroup.yMaxs[maxBranches - 1], yMaxBuff[i]);
                }
                break;
            }
            int next = RTree.pickNext(fullLeafNode, returnThis, entriesRemaining, maxBranches, xMinBuff, yMinBuff, xMaxBuff, yMaxBuff, tempBuff1, buff1Valid, tempBuff2, buff2Valid);
            boolean chooseGroup1 = tempBuff1[next] < tempBuff2[next] ? true : (tempBuff1[next] > tempBuff2[next] ? false : ((group1Area = (fullLeafNode.xMaxs[maxBranches - 1] - fullLeafNode.xMins[maxBranches - 1]) * (fullLeafNode.yMaxs[maxBranches - 1] - fullLeafNode.yMins[maxBranches - 1])) < (group2Area = (returnThis.xMaxs[maxBranches - 1] - returnThis.xMins[maxBranches - 1]) * (returnThis.yMaxs[maxBranches - 1] - returnThis.yMins[maxBranches - 1])) ? true : (group1Area > group2Area ? false : fullLeafNode.entryCount < returnThis.entryCount)));
            if (chooseGroup1) {
                chosenGroup = fullLeafNode;
                validTempBuff = tempBuff2;
                buff1Valid = false;
                buff2Valid = true;
            } else {
                chosenGroup = returnThis;
                validTempBuff = tempBuff1;
                buff1Valid = true;
                buff2Valid = false;
            }
            int newInx = chosenGroup.entryCount++;
            ((Node)chosenGroup).objKeys[newInx] = objKeyBuff[next];
            ((Node)chosenGroup).xMins[newInx] = xMinBuff[next];
            ((Node)chosenGroup).yMins[newInx] = yMinBuff[next];
            ((Node)chosenGroup).xMaxs[newInx] = xMaxBuff[next];
            ((Node)chosenGroup).yMaxs[newInx] = yMaxBuff[next];
            ((Node)chosenGroup).xMins[maxBranches - 1] = Math.min(chosenGroup.xMins[maxBranches - 1], xMinBuff[next]);
            ((Node)chosenGroup).yMins[maxBranches - 1] = Math.min(chosenGroup.yMins[maxBranches - 1], yMinBuff[next]);
            ((Node)chosenGroup).xMaxs[maxBranches - 1] = Math.max(chosenGroup.xMaxs[maxBranches - 1], xMaxBuff[next]);
            ((Node)chosenGroup).yMaxs[maxBranches - 1] = Math.max(chosenGroup.yMaxs[maxBranches - 1], yMaxBuff[next]);
            if (next == --entriesRemaining) continue;
            objKeyBuff[next] = objKeyBuff[entriesRemaining];
            xMinBuff[next] = xMinBuff[entriesRemaining];
            yMinBuff[next] = yMinBuff[entriesRemaining];
            xMaxBuff[next] = xMaxBuff[entriesRemaining];
            yMaxBuff[next] = yMaxBuff[entriesRemaining];
            validTempBuff[next] = validTempBuff[entriesRemaining];
        }
        return returnThis;
    }

    private static final Node splitInternalNode(Node fullInternalNode, Node newChild, float newXMin, float newYMin, float newXMax, float newYMax, int maxBranches, int minBranches, Node[] childrenBuff, float[] xMinBuff, float[] yMinBuff, float[] xMaxBuff, float[] yMaxBuff, float[] tempBuff1, float[] tempBuff2) {
        int i;
        for (int i2 = 0; i2 < fullInternalNode.entryCount; ++i2) {
            childrenBuff[i2] = fullInternalNode.data.children[i2];
            xMinBuff[i2] = fullInternalNode.xMins[i2];
            yMinBuff[i2] = fullInternalNode.yMins[i2];
            xMaxBuff[i2] = fullInternalNode.xMaxs[i2];
            yMaxBuff[i2] = fullInternalNode.yMaxs[i2];
        }
        childrenBuff[((Node)fullInternalNode).entryCount] = newChild;
        xMinBuff[((Node)fullInternalNode).entryCount] = newXMin;
        yMinBuff[((Node)fullInternalNode).entryCount] = newYMin;
        xMaxBuff[((Node)fullInternalNode).entryCount] = newXMax;
        yMaxBuff[((Node)fullInternalNode).entryCount] = newYMax;
        int totalEntries = fullInternalNode.entryCount + 1;
        long seeds = RTree.pickSeeds(totalEntries, xMinBuff, yMinBuff, xMaxBuff, yMaxBuff, tempBuff1);
        int seed1 = (int)(seeds >> 32);
        childrenBuff[seed1].parent = fullInternalNode;
        ((InternalNodeData)((Node)fullInternalNode).data).children[0] = childrenBuff[seed1];
        ((Node)fullInternalNode).xMins[0] = xMinBuff[seed1];
        ((Node)fullInternalNode).yMins[0] = yMinBuff[seed1];
        ((Node)fullInternalNode).xMaxs[0] = xMaxBuff[seed1];
        ((Node)fullInternalNode).yMaxs[0] = yMaxBuff[seed1];
        fullInternalNode.entryCount = 1;
        int seed2 = (int)seeds;
        Node returnThis = new Node(maxBranches, false);
        childrenBuff[seed2].parent = returnThis;
        ((InternalNodeData)((Node)returnThis).data).children[0] = childrenBuff[seed2];
        ((Node)returnThis).xMins[0] = xMinBuff[seed2];
        ((Node)returnThis).yMins[0] = yMinBuff[seed2];
        ((Node)returnThis).xMaxs[0] = xMaxBuff[seed2];
        ((Node)returnThis).yMaxs[0] = yMaxBuff[seed2];
        returnThis.entryCount = 1;
        ((Node)fullInternalNode).xMins[maxBranches - 1] = fullInternalNode.xMins[0];
        ((Node)fullInternalNode).yMins[maxBranches - 1] = fullInternalNode.yMins[0];
        ((Node)fullInternalNode).xMaxs[maxBranches - 1] = fullInternalNode.xMaxs[0];
        ((Node)fullInternalNode).yMaxs[maxBranches - 1] = fullInternalNode.yMaxs[0];
        ((Node)returnThis).xMins[maxBranches - 1] = returnThis.xMins[0];
        ((Node)returnThis).yMins[maxBranches - 1] = returnThis.yMins[0];
        ((Node)returnThis).xMaxs[maxBranches - 1] = returnThis.xMaxs[0];
        ((Node)returnThis).yMaxs[maxBranches - 1] = returnThis.yMaxs[0];
        int entriesRemaining = totalEntries;
        if (seed2 != --entriesRemaining) {
            childrenBuff[seed2] = childrenBuff[entriesRemaining];
            xMinBuff[seed2] = xMinBuff[entriesRemaining];
            yMinBuff[seed2] = yMinBuff[entriesRemaining];
            xMaxBuff[seed2] = xMaxBuff[entriesRemaining];
            yMaxBuff[seed2] = yMaxBuff[entriesRemaining];
        }
        if (seed1 != --entriesRemaining) {
            childrenBuff[seed1] = childrenBuff[entriesRemaining];
            xMinBuff[seed1] = xMinBuff[entriesRemaining];
            yMinBuff[seed1] = yMinBuff[entriesRemaining];
            xMaxBuff[seed1] = xMaxBuff[entriesRemaining];
            yMaxBuff[seed1] = yMaxBuff[entriesRemaining];
        }
        boolean buff1Valid = false;
        boolean buff2Valid = false;
        while (entriesRemaining != 0) {
            float[] validTempBuff;
            Node chosenGroup;
            float group2Area;
            float group1Area;
            Node restGroup = entriesRemaining + fullInternalNode.entryCount == minBranches ? fullInternalNode : (entriesRemaining + returnThis.entryCount == minBranches ? returnThis : null);
            if (restGroup != null) {
                for (int i3 = 0; i3 < entriesRemaining; ++i3) {
                    int newInx = restGroup.entryCount++;
                    childrenBuff[i3].parent = restGroup;
                    ((InternalNodeData)((Node)restGroup).data).children[newInx] = childrenBuff[i3];
                    ((Node)restGroup).xMins[newInx] = xMinBuff[i3];
                    ((Node)restGroup).yMins[newInx] = yMinBuff[i3];
                    ((Node)restGroup).xMaxs[newInx] = xMaxBuff[i3];
                    ((Node)restGroup).yMaxs[newInx] = yMaxBuff[i3];
                    ((Node)restGroup).xMins[maxBranches - 1] = Math.min(restGroup.xMins[maxBranches - 1], xMinBuff[i3]);
                    ((Node)restGroup).yMins[maxBranches - 1] = Math.min(restGroup.yMins[maxBranches - 1], yMinBuff[i3]);
                    ((Node)restGroup).xMaxs[maxBranches - 1] = Math.max(restGroup.xMaxs[maxBranches - 1], xMaxBuff[i3]);
                    ((Node)restGroup).yMaxs[maxBranches - 1] = Math.max(restGroup.yMaxs[maxBranches - 1], yMaxBuff[i3]);
                }
                break;
            }
            int next = RTree.pickNext(fullInternalNode, returnThis, entriesRemaining, maxBranches, xMinBuff, yMinBuff, xMaxBuff, yMaxBuff, tempBuff1, buff1Valid, tempBuff2, buff2Valid);
            boolean chooseGroup1 = tempBuff1[next] < tempBuff2[next] ? true : (tempBuff1[next] > tempBuff2[next] ? false : ((group1Area = (fullInternalNode.xMaxs[maxBranches - 1] - fullInternalNode.xMins[maxBranches - 1]) * (fullInternalNode.yMaxs[maxBranches - 1] - fullInternalNode.yMins[maxBranches - 1])) < (group2Area = (returnThis.xMaxs[maxBranches - 1] - returnThis.xMins[maxBranches - 1]) * (returnThis.yMaxs[maxBranches - 1] - returnThis.yMins[maxBranches - 1])) ? true : (group1Area > group2Area ? false : fullInternalNode.entryCount < returnThis.entryCount)));
            if (chooseGroup1) {
                chosenGroup = fullInternalNode;
                validTempBuff = tempBuff2;
                buff1Valid = false;
                buff2Valid = true;
            } else {
                chosenGroup = returnThis;
                validTempBuff = tempBuff1;
                buff1Valid = true;
                buff2Valid = false;
            }
            int newInx = chosenGroup.entryCount++;
            childrenBuff[next].parent = chosenGroup;
            ((InternalNodeData)((Node)chosenGroup).data).children[newInx] = childrenBuff[next];
            ((Node)chosenGroup).xMins[newInx] = xMinBuff[next];
            ((Node)chosenGroup).yMins[newInx] = yMinBuff[next];
            ((Node)chosenGroup).xMaxs[newInx] = xMaxBuff[next];
            ((Node)chosenGroup).yMaxs[newInx] = yMaxBuff[next];
            ((Node)chosenGroup).xMins[maxBranches - 1] = Math.min(chosenGroup.xMins[maxBranches - 1], xMinBuff[next]);
            ((Node)chosenGroup).yMins[maxBranches - 1] = Math.min(chosenGroup.yMins[maxBranches - 1], yMinBuff[next]);
            ((Node)chosenGroup).xMaxs[maxBranches - 1] = Math.max(chosenGroup.xMaxs[maxBranches - 1], xMaxBuff[next]);
            ((Node)chosenGroup).yMaxs[maxBranches - 1] = Math.max(chosenGroup.yMaxs[maxBranches - 1], yMaxBuff[next]);
            if (next == --entriesRemaining) continue;
            childrenBuff[next] = childrenBuff[entriesRemaining];
            xMinBuff[next] = xMinBuff[entriesRemaining];
            yMinBuff[next] = yMinBuff[entriesRemaining];
            xMaxBuff[next] = xMaxBuff[entriesRemaining];
            yMaxBuff[next] = yMaxBuff[entriesRemaining];
            validTempBuff[next] = validTempBuff[entriesRemaining];
        }
        fullInternalNode.data.deepCount = 0;
        if (RTree.isLeafNode(fullInternalNode.data.children[0])) {
            for (i = 0; i < fullInternalNode.entryCount; ++i) {
                fullInternalNode.data.deepCount += fullInternalNode.data.children[i].entryCount;
            }
            for (i = 0; i < returnThis.entryCount; ++i) {
                returnThis.data.deepCount += returnThis.data.children[i].entryCount;
            }
        } else {
            for (i = 0; i < fullInternalNode.entryCount; ++i) {
                fullInternalNode.data.deepCount += fullInternalNode.data.children[i].data.deepCount;
            }
            for (i = 0; i < returnThis.entryCount; ++i) {
                returnThis.data.deepCount += returnThis.data.children[i].data.deepCount;
            }
        }
        for (i = fullInternalNode.entryCount; i < fullInternalNode.data.children.length; ++i) {
            ((InternalNodeData)((Node)fullInternalNode).data).children[i] = null;
        }
        for (i = 0; i < childrenBuff.length; ++i) {
            childrenBuff[i] = null;
        }
        return returnThis;
    }

    private static final long pickSeeds(int count, float[] xMins, float[] yMins, float[] xMaxs, float[] yMaxs, float[] tempBuff) {
        for (int i = 0; i < count; ++i) {
            tempBuff[i] = (xMaxs[i] - xMins[i]) * (yMaxs[i] - yMins[i]);
        }
        float maximumD = Float.NEGATIVE_INFINITY;
        int maximumInx1 = -1;
        int maximumInx2 = -1;
        for (int i = 0; i < count - 1; ++i) {
            for (int j = i + 1; j < count; ++j) {
                float areaJ = (Math.max(xMaxs[i], xMaxs[j]) - Math.min(xMins[i], xMins[j])) * (Math.max(yMaxs[i], yMaxs[j]) - Math.min(yMins[i], yMins[j]));
                float d = areaJ - tempBuff[i] - tempBuff[j];
                if (!(d > maximumD)) continue;
                maximumD = d;
                maximumInx1 = i;
                maximumInx2 = j;
            }
        }
        return (long)maximumInx1 << 32 | (long)maximumInx2;
    }

    private static final int pickNext(Node group1, Node group2, int count, int maxBranches, float[] xMins, float[] yMins, float[] xMaxs, float[] yMaxs, float[] tempBuff1, boolean buff1Valid, float[] tempBuff2, boolean buff2Valid) {
        int i;
        if (!buff1Valid) {
            float group1Area = (group1.xMaxs[maxBranches - 1] - group1.xMins[maxBranches - 1]) * (group1.yMaxs[maxBranches - 1] - group1.yMins[maxBranches - 1]);
            for (i = 0; i < count; ++i) {
                tempBuff1[i] = (Math.max(group1.xMaxs[maxBranches - 1], xMaxs[i]) - Math.min(group1.xMins[maxBranches - 1], xMins[i])) * (Math.max(group1.yMaxs[maxBranches - 1], yMaxs[i]) - Math.min(group1.yMins[maxBranches - 1], yMins[i])) - group1Area;
            }
        }
        if (!buff2Valid) {
            float group2Area = (group2.xMaxs[maxBranches - 1] - group2.xMins[maxBranches - 1]) * (group2.yMaxs[maxBranches - 1] - group2.yMins[maxBranches - 1]);
            for (i = 0; i < count; ++i) {
                tempBuff2[i] = (Math.max(group2.xMaxs[maxBranches - 1], xMaxs[i]) - Math.min(group2.xMins[maxBranches - 1], xMins[i])) * (Math.max(group2.yMaxs[maxBranches - 1], yMaxs[i]) - Math.min(group2.yMins[maxBranches - 1], yMins[i])) - group2Area;
            }
        }
        float maxDDifference = Float.NEGATIVE_INFINITY;
        int maxInx = -1;
        for (int i2 = 0; i2 < count; ++i2) {
            float currDDifference = Math.abs(tempBuff1[i2] - tempBuff2[i2]);
            if (!(currDDifference > maxDDifference)) continue;
            maxDDifference = currDDifference;
            maxInx = i2;
        }
        return maxInx;
    }

    private static final void adjustTreeNoSplit(Node nodeWithNewEntry, int deepCountIncrease, float[] globalMBR) {
        int currModInx = nodeWithNewEntry.entryCount - 1;
        Node n = nodeWithNewEntry;
        while (true) {
            Node p;
            if ((p = n.parent) == null) {
                if (currModInx < 0) break;
                globalMBR[0] = Math.min(globalMBR[0], n.xMins[currModInx]);
                globalMBR[1] = Math.min(globalMBR[1], n.yMins[currModInx]);
                globalMBR[2] = Math.max(globalMBR[2], n.xMaxs[currModInx]);
                globalMBR[3] = Math.max(globalMBR[3], n.yMaxs[currModInx]);
                break;
            }
            p.data.deepCount += deepCountIncrease;
            if (currModInx >= 0) {
                int i = 0;
                while (true) {
                    if (p.data.children[i] == n) break;
                    ++i;
                }
                int nInxInP = i;
                float newXMin = Math.min(p.xMins[nInxInP], n.xMins[currModInx]);
                float newYMin = Math.min(p.yMins[nInxInP], n.yMins[currModInx]);
                float newXMax = Math.max(p.xMaxs[nInxInP], n.xMaxs[currModInx]);
                float newYMax = Math.max(p.yMaxs[nInxInP], n.yMaxs[currModInx]);
                if (newXMin == p.xMins[nInxInP] && newYMin == p.yMins[nInxInP] && newXMax == p.xMaxs[nInxInP] && newYMax == p.yMaxs[nInxInP]) {
                    currModInx = -1;
                } else {
                    ((Node)p).xMins[nInxInP] = newXMin;
                    ((Node)p).yMins[nInxInP] = newYMin;
                    ((Node)p).xMaxs[nInxInP] = newXMax;
                    ((Node)p).yMaxs[nInxInP] = newYMax;
                    currModInx = nInxInP;
                }
            }
            n = p;
        }
    }

    private static final Node adjustTreeWithSplit(Node originalNode, Node newNode, int deepCountIncrease, int maxBranches, int minBranches, float[] globalMBR, Node[] childrenBuff, float[] xMinBuff, float[] yMinBuff, float[] xMaxBuff, float[] yMaxBuff, float[] tempBuff1, float[] tempBuff2) {
        int currModInx = -1;
        boolean newNodeAdded = false;
        Node n = originalNode;
        Node nn = newNode;
        while (true) {
            int nInxInP;
            Node p;
            if ((p = n.parent) == null) {
                if (nn != null || currModInx < 0) break;
                globalMBR[0] = Math.min(globalMBR[0], n.xMins[currModInx]);
                globalMBR[1] = Math.min(globalMBR[1], n.yMins[currModInx]);
                globalMBR[2] = Math.max(globalMBR[2], n.xMaxs[currModInx]);
                globalMBR[3] = Math.max(globalMBR[3], n.yMaxs[currModInx]);
                if (!newNodeAdded) break;
                int countMin1 = n.entryCount - 1;
                globalMBR[0] = Math.min(globalMBR[0], n.xMins[countMin1]);
                globalMBR[1] = Math.min(globalMBR[1], n.yMins[countMin1]);
                globalMBR[2] = Math.max(globalMBR[2], n.xMaxs[countMin1]);
                globalMBR[3] = Math.max(globalMBR[3], n.yMaxs[countMin1]);
                break;
            }
            p.data.deepCount += deepCountIncrease;
            if (nn != null) {
                int i = 0;
                while (true) {
                    if (p.data.children[i] == n) break;
                    ++i;
                }
                nInxInP = i;
                ((Node)p).xMins[nInxInP] = n.xMins[maxBranches - 1];
                ((Node)p).yMins[nInxInP] = n.yMins[maxBranches - 1];
                ((Node)p).xMaxs[nInxInP] = n.xMaxs[maxBranches - 1];
                ((Node)p).yMaxs[nInxInP] = n.yMaxs[maxBranches - 1];
                if (p.entryCount < maxBranches) {
                    int newInxInP = p.entryCount++;
                    nn.parent = p;
                    ((InternalNodeData)((Node)p).data).children[newInxInP] = nn;
                    ((Node)p).xMins[newInxInP] = nn.xMins[maxBranches - 1];
                    ((Node)p).yMins[newInxInP] = nn.yMins[maxBranches - 1];
                    ((Node)p).xMaxs[newInxInP] = nn.xMaxs[maxBranches - 1];
                    ((Node)p).yMaxs[newInxInP] = nn.yMaxs[maxBranches - 1];
                    currModInx = nInxInP;
                    newNodeAdded = true;
                    nn = null;
                } else {
                    nn = RTree.splitInternalNode(p, nn, nn.xMins[maxBranches - 1], nn.yMins[maxBranches - 1], nn.xMaxs[maxBranches - 1], nn.yMaxs[maxBranches - 1], maxBranches, minBranches, childrenBuff, xMinBuff, yMinBuff, xMaxBuff, yMaxBuff, tempBuff1, tempBuff2);
                }
            } else if (currModInx >= 0) {
                int i = 0;
                while (true) {
                    if (p.data.children[i] == n) break;
                    ++i;
                }
                nInxInP = i;
                float newXMin = Math.min(p.xMins[nInxInP], n.xMins[currModInx]);
                float newYMin = Math.min(p.yMins[nInxInP], n.yMins[currModInx]);
                float newXMax = Math.max(p.xMaxs[nInxInP], n.xMaxs[currModInx]);
                float newYMax = Math.max(p.yMaxs[nInxInP], n.yMaxs[currModInx]);
                if (newNodeAdded) {
                    int countMin1 = n.entryCount - 1;
                    newXMin = Math.min(newXMin, n.xMins[countMin1]);
                    newYMin = Math.min(newYMin, n.yMins[countMin1]);
                    newXMax = Math.max(newXMax, n.xMaxs[countMin1]);
                    newYMax = Math.max(newYMax, n.yMaxs[countMin1]);
                    newNodeAdded = false;
                }
                if (newXMin == p.xMins[nInxInP] && newYMin == p.yMins[nInxInP] && newXMax == p.xMaxs[nInxInP] && newYMax == p.yMaxs[nInxInP]) {
                    currModInx = -1;
                } else {
                    ((Node)p).xMins[nInxInP] = newXMin;
                    ((Node)p).yMins[nInxInP] = newYMin;
                    ((Node)p).xMaxs[nInxInP] = newXMax;
                    ((Node)p).yMaxs[nInxInP] = newYMax;
                    currModInx = nInxInP;
                }
            }
            n = p;
        }
        return nn;
    }

    public final boolean exists(int objKey, float[] extentsArr, int offset) {
        if (objKey < 0) {
            return false;
        }
        Object o = this.m_entryMap.get(objKey);
        if (o == null || o == this.m_deletedEntry) {
            return false;
        }
        if (extentsArr != null) {
            Node n = (Node)o;
            int i = -1;
            while (n.objKeys[++i] != objKey) {
            }
            extentsArr[offset] = n.xMins[i];
            extentsArr[offset + 1] = n.yMins[i];
            extentsArr[offset + 2] = n.xMaxs[i];
            extentsArr[offset + 3] = n.yMaxs[i];
        }
        return true;
    }

    public final boolean delete(int objKey) {
        if (objKey < 0) {
            return false;
        }
        Object o = this.m_entryMap.get(objKey);
        if (o == null || o == this.m_deletedEntry) {
            return false;
        }
        Node n = (Node)o;
        int i = 0;
        while (true) {
            if (n.objKeys[i] == objKey) break;
            ++i;
        }
        int delInx = i;
        n.entryCount--;
        if (delInx != n.entryCount) {
            ((Node)n).objKeys[delInx] = n.objKeys[n.entryCount];
            ((Node)n).xMins[delInx] = n.xMins[n.entryCount];
            ((Node)n).yMins[delInx] = n.yMins[n.entryCount];
            ((Node)n).xMaxs[delInx] = n.xMaxs[n.entryCount];
            ((Node)n).yMaxs[delInx] = n.yMaxs[n.entryCount];
        }
        int currentDepth = RTree.condenseTree(n, 1, this.m_nodeStack, this.m_minBranches, this.m_MBR) - this.m_nodeStack.size() + 1;
        while (this.m_nodeStack.size() > 0) {
            Node eliminatedNode = (Node)this.m_nodeStack.pop();
            for (int i2 = 0; i2 < eliminatedNode.entryCount; ++i2) {
                Node rootSplit;
                if (RTree.isLeafNode(eliminatedNode)) {
                    rootSplit = RTree.insert(this.m_root, eliminatedNode.objKeys[i2], eliminatedNode.xMins[i2], eliminatedNode.yMins[i2], eliminatedNode.xMaxs[i2], eliminatedNode.yMaxs[i2], this.m_maxBranches, this.m_minBranches, this.m_entryMap, this.m_MBR, this.m_objKeyBuff, this.m_childrenBuff, this.m_xMinBuff, this.m_yMinBuff, this.m_xMaxBuff, this.m_yMaxBuff, this.m_tempBuff1, this.m_tempBuff2);
                } else {
                    rootSplit = RTree.insert(this.m_root, currentDepth, eliminatedNode.data.children[i2], eliminatedNode.xMins[i2], eliminatedNode.yMins[i2], eliminatedNode.xMaxs[i2], eliminatedNode.yMaxs[i2], this.m_maxBranches, this.m_minBranches, this.m_MBR, this.m_childrenBuff, this.m_xMinBuff, this.m_yMinBuff, this.m_xMaxBuff, this.m_yMaxBuff, this.m_tempBuff1, this.m_tempBuff2);
                    ((InternalNodeData)((Node)eliminatedNode).data).children[i2] = null;
                }
                if (rootSplit == null) continue;
                Node newRoot = new Node(this.m_maxBranches, false);
                newRoot.entryCount = 2;
                this.m_root.parent = newRoot;
                rootSplit.parent = newRoot;
                ((InternalNodeData)((Node)newRoot).data).children[0] = this.m_root;
                ((InternalNodeData)((Node)newRoot).data).children[1] = rootSplit;
                ((Node)newRoot).xMins[0] = this.m_root.xMins[this.m_maxBranches - 1];
                ((Node)newRoot).yMins[0] = this.m_root.yMins[this.m_maxBranches - 1];
                ((Node)newRoot).xMaxs[0] = this.m_root.xMaxs[this.m_maxBranches - 1];
                ((Node)newRoot).yMaxs[0] = this.m_root.yMaxs[this.m_maxBranches - 1];
                ((Node)newRoot).xMins[1] = rootSplit.xMins[this.m_maxBranches - 1];
                ((Node)newRoot).yMins[1] = rootSplit.yMins[this.m_maxBranches - 1];
                ((Node)newRoot).xMaxs[1] = rootSplit.xMaxs[this.m_maxBranches - 1];
                ((Node)newRoot).yMaxs[1] = rootSplit.yMaxs[this.m_maxBranches - 1];
                newRoot.data.deepCount = this.m_root.data.deepCount + rootSplit.data.deepCount;
                this.m_root = newRoot;
                this.m_MBR[0] = Math.min(this.m_root.xMins[0], this.m_root.xMins[1]);
                this.m_MBR[1] = Math.min(this.m_root.yMins[0], this.m_root.yMins[1]);
                this.m_MBR[2] = Math.max(this.m_root.xMaxs[0], this.m_root.xMaxs[1]);
                this.m_MBR[3] = Math.max(this.m_root.yMaxs[0], this.m_root.yMaxs[1]);
                ++currentDepth;
            }
            ++currentDepth;
        }
        if (!RTree.isLeafNode(this.m_root) && this.m_root.entryCount == 1) {
            Node newRoot = this.m_root.data.children[0];
            newRoot.parent = null;
            this.m_root = newRoot;
        }
        this.m_entryMap.put(objKey, this.m_deletedEntry);
        if (++this.m_deletedEntries * 2 > this.m_entryMap.size() && this.m_deletedEntries > 5) {
            IntObjHash newEntryMap = new IntObjHash();
            IntEnumerator objKeys = this.m_entryMap.keys();
            Iterator leafNodes = this.m_entryMap.values();
            while (objKeys.numRemaining() > 0) {
                Object leafNode = leafNodes.next();
                if (leafNode == this.m_deletedEntry) {
                    objKeys.nextInt();
                    continue;
                }
                newEntryMap.put(objKeys.nextInt(), leafNode);
            }
            this.m_entryMap = newEntryMap;
            this.m_deletedEntries = 0;
            this.m_mapExpansionThreshold = IntObjHash.maxCapacity(this.m_entryMap.size());
        }
        return true;
    }

    private static final int condenseTree(Node nodeWithDeletions, int deepCountDecrease, ObjStack eliminatedNodes, int minBranches, float[] globalMBR) {
        int depth = 0;
        boolean updateMBR = true;
        Node n = nodeWithDeletions;
        while (true) {
            Node p;
            if ((p = n.parent) == null) {
                if (!updateMBR) break;
                globalMBR[0] = Float.POSITIVE_INFINITY;
                globalMBR[1] = Float.POSITIVE_INFINITY;
                globalMBR[2] = Float.NEGATIVE_INFINITY;
                globalMBR[3] = Float.NEGATIVE_INFINITY;
                for (int i = 0; i < n.entryCount; ++i) {
                    globalMBR[0] = Math.min(globalMBR[0], n.xMins[i]);
                    globalMBR[1] = Math.min(globalMBR[1], n.yMins[i]);
                    globalMBR[2] = Math.max(globalMBR[2], n.xMaxs[i]);
                    globalMBR[3] = Math.max(globalMBR[3], n.yMaxs[i]);
                }
                break;
            }
            int i = 0;
            while (true) {
                if (p.data.children[i] == n) break;
                ++i;
            }
            int nInxInP = i;
            if (n.entryCount < minBranches) {
                p.entryCount--;
                if (nInxInP != p.entryCount) {
                    ((InternalNodeData)((Node)p).data).children[nInxInP] = p.data.children[p.entryCount];
                    ((Node)p).xMins[nInxInP] = p.xMins[p.entryCount];
                    ((Node)p).yMins[nInxInP] = p.yMins[p.entryCount];
                    ((Node)p).xMaxs[nInxInP] = p.xMaxs[p.entryCount];
                    ((Node)p).yMaxs[nInxInP] = p.yMaxs[p.entryCount];
                }
                ((InternalNodeData)((Node)p).data).children[((Node)p).entryCount] = null;
                n.parent = null;
                eliminatedNodes.push(n);
                deepCountDecrease += RTree.isLeafNode(n) ? n.entryCount : n.data.deepCount;
            } else if (updateMBR) {
                float oldXMin = p.xMins[nInxInP];
                float oldYMin = p.yMins[nInxInP];
                float oldXMax = p.xMaxs[nInxInP];
                float oldYMax = p.yMaxs[nInxInP];
                ((Node)p).xMins[nInxInP] = Float.POSITIVE_INFINITY;
                ((Node)p).yMins[nInxInP] = Float.POSITIVE_INFINITY;
                ((Node)p).xMaxs[nInxInP] = Float.NEGATIVE_INFINITY;
                ((Node)p).yMaxs[nInxInP] = Float.NEGATIVE_INFINITY;
                for (int i2 = 0; i2 < n.entryCount; ++i2) {
                    ((Node)p).xMins[nInxInP] = Math.min(p.xMins[nInxInP], n.xMins[i2]);
                    ((Node)p).yMins[nInxInP] = Math.min(p.yMins[nInxInP], n.yMins[i2]);
                    ((Node)p).xMaxs[nInxInP] = Math.max(p.xMaxs[nInxInP], n.xMaxs[i2]);
                    ((Node)p).yMaxs[nInxInP] = Math.max(p.yMaxs[nInxInP], n.yMaxs[i2]);
                }
                if (oldXMin == p.xMins[nInxInP] && oldYMin == p.yMins[nInxInP] && oldXMax == p.xMaxs[nInxInP] && oldYMax == p.yMaxs[nInxInP]) {
                    updateMBR = false;
                }
            }
            p.data.deepCount -= deepCountDecrease;
            n = p;
            ++depth;
        }
        return depth;
    }

    public final SpacialEntry2DEnumerator queryOverlap(float xMin, float yMin, float xMax, float yMax, float[] extentsArr, int offset, boolean reverse) {
        if (!(xMin <= xMax)) {
            throw new IllegalArgumentException("xMin <= xMax not true");
        }
        if (!(yMin <= yMax)) {
            throw new IllegalArgumentException("yMin <= yMax not true");
        }
        if (extentsArr != null) {
            extentsArr[offset] = Float.POSITIVE_INFINITY;
            extentsArr[offset + 1] = Float.POSITIVE_INFINITY;
            extentsArr[offset + 2] = Float.NEGATIVE_INFINITY;
            extentsArr[offset + 3] = Float.NEGATIVE_INFINITY;
        }
        this.m_nodeStack.push(this.m_root);
        this.m_extentsStack[0] = this.m_MBR[0];
        this.m_extentsStack[1] = this.m_MBR[1];
        this.m_extentsStack[2] = this.m_MBR[2];
        this.m_extentsStack[3] = this.m_MBR[3];
        ObjStack nodeStack = new ObjStack();
        ObjStack stackStack = new ObjStack();
        int totalCount = RTree.queryOverlap(this.m_nodeStack, this.m_extentsStack, nodeStack, stackStack, xMin, yMin, xMax, yMax, extentsArr, offset, reverse);
        return new OverlapEnumerator(totalCount, nodeStack, stackStack, reverse);
    }

    private static final int queryOverlap(ObjStack unprocessedNodes, float[] extStack, ObjStack nodeStack, ObjStack stackStack, float xMinQ, float yMinQ, float xMaxQ, float yMaxQ, float[] extents, int off, boolean reverse) {
        int incr = reverse ? -1 : 1;
        int count = 0;
        int extOff = 4;
        while (unprocessedNodes.size() > 0) {
            int i;
            Node n = (Node)unprocessedNodes.pop();
            if (xMinQ <= extStack[extOff -= 4] && xMaxQ >= extStack[extOff + 2] && yMinQ <= extStack[extOff + 1] && yMaxQ >= extStack[extOff + 3]) {
                if (RTree.isLeafNode(n)) {
                    count += n.entryCount;
                    stackStack.push(null);
                } else {
                    count += n.data.deepCount;
                }
                nodeStack.push(n);
                if (extents == null) continue;
                extents[off] = Math.min(extents[off], extStack[extOff]);
                extents[off + 1] = Math.min(extents[off + 1], extStack[extOff + 1]);
                extents[off + 2] = Math.max(extents[off + 2], extStack[extOff + 2]);
                extents[off + 3] = Math.max(extents[off + 3], extStack[extOff + 3]);
                continue;
            }
            if (RTree.isLeafNode(n)) {
                int i2;
                IntStack stack = new IntStack();
                int cntr = n.entryCount;
                int n2 = i2 = reverse ? 0 : n.entryCount - 1;
                while (cntr > 0) {
                    if (Math.max(xMinQ, n.xMins[i2]) <= Math.min(xMaxQ, n.xMaxs[i2]) && Math.max(yMinQ, n.yMins[i2]) <= Math.min(yMaxQ, n.yMaxs[i2])) {
                        stack.push(i2);
                        if (extents != null) {
                            extents[off] = Math.min(extents[off], n.xMins[i2]);
                            extents[off + 1] = Math.min(extents[off + 1], n.yMins[i2]);
                            extents[off + 2] = Math.max(extents[off + 2], n.xMaxs[i2]);
                            extents[off + 3] = Math.max(extents[off + 3], n.yMaxs[i2]);
                        }
                    }
                    --cntr;
                    i2 -= incr;
                }
                if (stack.size() <= 0) continue;
                count += stack.size();
                stackStack.push(stack);
                nodeStack.push(n);
                continue;
            }
            int cntr = n.entryCount;
            int n3 = i = reverse ? n.entryCount - 1 : 0;
            while (cntr > 0) {
                if (Math.max(xMinQ, n.xMins[i]) <= Math.min(xMaxQ, n.xMaxs[i]) && Math.max(yMinQ, n.yMins[i]) <= Math.min(yMaxQ, n.yMaxs[i])) {
                    unprocessedNodes.push(n.data.children[i]);
                    extStack[extOff++] = n.xMins[i];
                    extStack[extOff++] = n.yMins[i];
                    extStack[extOff++] = n.xMaxs[i];
                    extStack[extOff++] = n.yMaxs[i];
                }
                --cntr;
                i += incr;
            }
        }
        return count;
    }

    private static final class OverlapEnumerator
    implements SpacialEntry2DEnumerator {
        private int count;
        private final ObjStack nodeStack;
        private final ObjStack stackStack;
        private final boolean reverse;
        private final int inxIncr;
        private Node currentLeafNode;
        private IntStack currentStack;
        private int currentInx;
        private int boundaryInx;

        private OverlapEnumerator(int totalCount, ObjStack nodeStack, ObjStack stackStack, boolean reverse) {
            this.count = totalCount;
            this.nodeStack = nodeStack;
            this.stackStack = stackStack;
            this.reverse = reverse;
            this.inxIncr = this.reverse ? -1 : 1;
            this.computeNextLeafNode();
        }

        public final int numRemaining() {
            return this.count;
        }

        public final int nextExtents(float[] extentsArr, int offset) {
            int inx;
            Node leaf = this.currentLeafNode;
            if (this.currentStack == null) {
                inx = this.currentInx;
                this.currentInx += this.inxIncr;
                if (this.currentInx == this.boundaryInx) {
                    this.computeNextLeafNode();
                }
            } else {
                inx = this.currentStack.pop();
                if (this.currentStack.size() == 0) {
                    this.computeNextLeafNode();
                }
            }
            --this.count;
            extentsArr[offset] = leaf.xMins[inx];
            extentsArr[offset + 1] = leaf.yMins[inx];
            extentsArr[offset + 2] = leaf.xMaxs[inx];
            extentsArr[offset + 3] = leaf.yMaxs[inx];
            return leaf.objKeys[inx];
        }

        public final int nextInt() {
            int returnThis = -1;
            if (this.currentStack == null) {
                returnThis = this.currentLeafNode.objKeys[this.currentInx];
                this.currentInx += this.inxIncr;
                if (this.currentInx == this.boundaryInx) {
                    this.computeNextLeafNode();
                }
            } else {
                returnThis = this.currentLeafNode.objKeys[this.currentStack.pop()];
                if (this.currentStack.size() == 0) {
                    this.computeNextLeafNode();
                }
            }
            --this.count;
            return returnThis;
        }

        private final void computeNextLeafNode() {
            if (this.nodeStack.size() == 0) {
                this.currentLeafNode = null;
                this.currentStack = null;
                return;
            }
            block0: while (true) {
                int i;
                Node next;
                if (RTree.isLeafNode(next = (Node)this.nodeStack.pop())) {
                    this.currentLeafNode = next;
                    this.currentStack = (IntStack)this.stackStack.pop();
                    if (this.currentStack == null) {
                        if (this.reverse) {
                            this.currentInx = this.currentLeafNode.entryCount - 1;
                            this.boundaryInx = -1;
                        } else {
                            this.currentInx = 0;
                            this.boundaryInx = this.currentLeafNode.entryCount;
                        }
                    }
                    return;
                }
                int cntr = next.entryCount;
                int n = i = this.reverse ? 0 : next.entryCount - 1;
                while (true) {
                    if (cntr <= 0) continue block0;
                    if (RTree.isLeafNode(next.data.children[i])) {
                        this.stackStack.push(null);
                    }
                    this.nodeStack.push(next.data.children[i]);
                    --cntr;
                    i -= this.inxIncr;
                }
                break;
            }
        }
    }

    private static final class InternalNodeData
    implements Serializable {
        private int deepCount = 0;
        private final Node[] children;

        private InternalNodeData(int maxBranches) {
            this.children = new Node[maxBranches];
        }
    }

    private static final class Node
    implements Serializable {
        private Node parent;
        private int entryCount = 0;
        private final float[] xMins;
        private final float[] yMins;
        private final float[] xMaxs;
        private final float[] yMaxs;
        private final int[] objKeys;
        private final InternalNodeData data;

        private Node(int maxBranches, boolean leafNode) {
            this.xMins = new float[maxBranches];
            this.yMins = new float[maxBranches];
            this.xMaxs = new float[maxBranches];
            this.yMaxs = new float[maxBranches];
            if (leafNode) {
                this.objKeys = new int[maxBranches];
                this.data = null;
            } else {
                this.objKeys = null;
                this.data = new InternalNodeData(maxBranches);
            }
        }
    }
}

