/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.cruft.obo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public final class SynonymReader
extends Reader {
    private final String NL = System.getProperty("line.separator");
    private final HashMap m_dupsFilter = new HashMap();
    private BufferedReader m_file;
    private String m_readString;
    private int m_readInx;

    public SynonymReader(String speciesName, Reader geneAssociationFile) {
        if (geneAssociationFile == null) {
            throw new NullPointerException("geneAssociationFile is null");
        }
        this.m_file = new BufferedReader(geneAssociationFile);
        this.m_readString = speciesName + this.NL;
        this.m_readInx = 0;
    }

    public final int read(char[] cbuf, int off, int len) throws IOException {
        int returnThis;
        if (this.m_file == null) {
            throw new IOException("this stream is closed");
        }
        if (this.m_readString == null) {
            return -1;
        }
        if (this.m_readString.length() - this.m_readInx >= len) {
            this.m_readString.getChars(this.m_readInx, this.m_readInx + len, cbuf, off);
            returnThis = len;
            this.m_readInx += len;
        } else {
            this.m_readString.getChars(this.m_readInx, this.m_readString.length(), cbuf, off);
            returnThis = this.m_readString.length() - this.m_readInx;
            this.m_readInx = this.m_readString.length();
        }
        if (this.m_readInx == this.m_readString.length()) {
            this.readMore();
        }
        return returnThis;
    }

    private final void readMore() throws IOException {
        String delimitedList;
        String canon;
        while (true) {
            String line;
            if ((line = this.m_file.readLine()) == null) {
                this.m_readString = null;
                return;
            }
            if ((line = line.trim()).length() <= 0 || line.startsWith("!")) continue;
            int fromIndex = 0;
            for (int i = 0; i < 2; ++i) {
                fromIndex = 1 + line.indexOf(9, fromIndex);
            }
            canon = line.substring(fromIndex, line.indexOf(9, fromIndex));
            if (this.m_dupsFilter.get(canon) != null) continue;
            for (int i = 0; i < 8; ++i) {
                fromIndex = 1 + line.indexOf(9, fromIndex);
            }
            delimitedList = line.substring(fromIndex, line.indexOf(9, fromIndex));
            if (delimitedList.length() > 0) break;
        }
        this.m_readString = canon + " " + delimitedList.replace('|', ' ') + this.NL;
        System.out.println("Syno: " + this.m_readString);
        this.m_readInx = 0;
        this.m_dupsFilter.put(canon, canon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        try {
            this.m_file.close();
        }
        finally {
            this.m_file = null;
        }
    }
}

