/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.headless.AbstractHeadlessScreenExecutor;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public abstract class ConsoleScreenExecutor
extends AbstractHeadlessScreenExecutor {
    public boolean isUnattended() {
        return false;
    }

    public boolean isConsole() {
        return true;
    }

    protected boolean handleScreen(ScreenBeanConfig screenBeanConfig) throws UserCanceledException {
        Object[] objectArray;
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        do {
            ConsoleImpl consoleImpl = ConsoleImpl.getInstance();
            objectArray = null;
            if (screen.hasFormPanel()) {
                FormPanel formPanel = new FormPanel(screenBeanConfig.getFormComponentConfigs(), this.getContext(), false, screen);
                screen.setFormPanel(formPanel, formPanel.getFormEnvironment());
                objectArray = new Object[]{formPanel.getFormEnvironment()};
            }
            if (screen.handleConsole(consoleImpl)) continue;
            return false;
        } while (!this.getContext().runBooleanScript(screenBeanConfig.getValidationClassName(), screen, objectArray));
        return true;
    }

    public ProgressInterface getProgressInterface() {
        return ConsoleImpl.getInstance();
    }

    public void selectLanguage(ReturnToken returnToken) {
        ConsoleImpl consoleImpl = ConsoleImpl.getInstance();
        consoleImpl.println("Please select a language:");
        List list = InstallerConfig.getCurrentInstance().getLanguages();
        String string = Locale.getDefault().getLanguage();
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList);
        LanguageConfig languageConfig = InstallerConfig.getCurrentInstance().getLanguageById(string);
        int n = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            consoleImpl.print(i + 1 + ": " + arrayList.get(i));
            if (arrayList.get(i) == languageConfig) {
                consoleImpl.print(" [Enter]");
                n = i;
            }
            consoleImpl.println();
        }
        while (true) {
            try {
                String string2;
                int n2;
                do {
                    consoleImpl.println("[1 - " + arrayList.size() + "]");
                    string2 = consoleImpl.readLine();
                    if (string2.trim().length() != 0 || n <= -1) continue;
                    returnToken.returnToController(((LanguageConfig)arrayList.get(n)).getId());
                    return;
                } while ((n2 = Integer.parseInt(string2)) <= 0 || n2 > arrayList.size());
                returnToken.returnToController(((LanguageConfig)arrayList.get(n2 - 1)).getId());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            catch (UserCanceledException userCanceledException) {
                try {
                    Thread.sleep(100000000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }
}

