### R code from vignette source 'DOSE.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=60)
require(DOSE)


###################################################
### code chunk number 2: DOSE.Rnw:57-59
###################################################
library(DOSE)
help(DOSE)


###################################################
### code chunk number 3: DO Similarity
###################################################
data(DO2EG)
set.seed(123)
terms <- list(a=sample(names(DO2EG), 5),b= sample(names(DO2EG), 6))
terms
## Setting Parameters...
params <- new("DOParams", IDs=terms, type="DOID", method="Wang")
## Calculating Semantic Similarities...
sim(params)


###################################################
### code chunk number 4: DO Similarity 2
###################################################
params <- new("DOParams", IDs=terms, type="DOID", method="Wang", combine="rcmax.avg")
sim(params)


###################################################
### code chunk number 5: Gene Similarity
###################################################
data(EG2DO)
set.seed(123)
geneid <- list(a=sample(names(EG2DO), 5),b= sample(names(EG2DO), 6))
geneid
params <- new("DOParams", IDs=geneid, type="GeneID", method="Wang", combine="rcmax.avg")
sim(params)


###################################################
### code chunk number 6: enrichment analysis
###################################################
genes <- as.character(1:100)
x <- enrichDO(genes, pvalueCutoff=0.05)
summary(x)


###################################################
### code chunk number 7: DOSE.Rnw:112-113
###################################################
sessionInfo()


