### R code from vignette source 'CNAnorm.Snw'

###################################################
### code chunk number 1: CNAnorm.Snw:30-34
###################################################
library(CNAnorm)
data(LS041)
# show the data
LS041[1:5,]


###################################################
### code chunk number 2: CNAnorm.Snw:49-50
###################################################
CN <- dataFrame2object(LS041)


###################################################
### code chunk number 3: CNAnorm.Snw:57-59
###################################################
toSkip <- c("chrY", "chrM")
CN <- gcNorm(CN, exclude = toSkip)


###################################################
### code chunk number 4: CNAnorm.Snw:65-66
###################################################
CN <- addSmooth(CN, lambda = 7)


###################################################
### code chunk number 5: CNAnorm.Snw:71-72
###################################################
CN <- peakPloidy(CN, exclude = toSkip)


###################################################
### code chunk number 6: CNAnorm.Snw:78-79
###################################################
plotPeaks(CN, special1 = 'chrX', special2 = 'chrY')


###################################################
### code chunk number 7: CNAnorm.Snw:85-86
###################################################
CN.default <- validation(CN)


###################################################
### code chunk number 8: CNAnorm.Snw:91-92
###################################################
CN <- validation(CN, ploidy = (sugg.ploidy(CN) + 1) )


###################################################
### code chunk number 9: CNAnorm.Snw:98-100
###################################################
CN <- addDNACopy(CN)
CN <- discreteNorm(CN)


###################################################
### code chunk number 10: CNAnorm.Snw:105-106
###################################################
plotGenome(CN, superimpose = 'DNACopy')


###################################################
### code chunk number 11: CNAnorm.Snw:111-114
###################################################
toPlot <- c('chr10', 'chr11', 'chr12')
subSet <- chrs(CN) %in% toPlot
plotGenome(CN[subSet], superimpose = 'DNACopy')


###################################################
### code chunk number 12: CNAnorm.Snw:118-119
###################################################
exportTable(CN, file = "CNAnorm_table.tab", show = 'ploidy')


