###################################################
### chunk number 1: 
###################################################
#line 92 "xps.Rnw"
library(xps)


###################################################
### chunk number 2: 
###################################################
#line 121 "xps.Rnw"
library(xps)


###################################################
### chunk number 3: 
###################################################
#line 126 "xps.Rnw"
celdir <- file.path(.path.package("xps"), "raw")


###################################################
### chunk number 4: 
###################################################
#line 132 "xps.Rnw"
scheme.test3 <- root.scheme(file.path(.path.package("xps"), "schemes", "SchemeTest3.root"))


###################################################
### chunk number 5: 
###################################################
#line 137 "xps.Rnw"
celfiles <- c("TestA1.CEL","TestA2.CEL")
data.test3 <- import.data(scheme.test3, "tmpdt_DataTest3", celdir=celdir, celfiles=celfiles, verbose=FALSE)


###################################################
### chunk number 6: 
###################################################
#line 143 "xps.Rnw"
unlist(treeNames(data.test3))


###################################################
### chunk number 7: 
###################################################
#line 148 "xps.Rnw"
celfiles <- c("TestB1.CEL","TestB2.CEL")
data.test3 <- addData(data.test3, celdir=celdir, celfiles=celfiles, verbose=FALSE)


###################################################
### chunk number 8: 
###################################################
#line 156 "xps.Rnw"
getTreeNames(rootFile(data.test3))


###################################################
### chunk number 9: 
###################################################
#line 200 "xps.Rnw"
tmp <- intensity(data.test3)
head(tmp)


###################################################
### chunk number 10: 
###################################################
#line 206 "xps.Rnw"
data.test3 <- attachInten(data.test3)


###################################################
### chunk number 11: 
###################################################
#line 211 "xps.Rnw"
tmp <- intensity(data.test3)
head(tmp)


###################################################
### chunk number 12: 
###################################################
#line 218 "xps.Rnw"
subdata.test3 <- attachInten(data.test3, c("TestB1.cel","TestA2"))
tmp <- intensity(subdata.test3)
head(tmp)


###################################################
### chunk number 13: 
###################################################
#line 226 "xps.Rnw"
data.test3 <- removeInten(data.test3)
tmp <- intensity(data.test3)
head(tmp)


###################################################
### chunk number 14: 
###################################################
#line 237 "xps.Rnw"
data.test3 <- attachMask(data.test3)
data.test3 <- attachInten(data.test3)


###################################################
### chunk number 15: hist
###################################################
#line 250 "xps.Rnw"
hist(data.test3)


###################################################
### chunk number 16: boxplot
###################################################
#line 259 "xps.Rnw"
boxplot(data.test3)


###################################################
### chunk number 17: image
###################################################
#line 268 "xps.Rnw"
image(data.test3, names="TestA1.cel")


###################################################
### chunk number 18: pmplot
###################################################
#line 277 "xps.Rnw"
pmplot(data.test3)


###################################################
### chunk number 19: 
###################################################
#line 283 "xps.Rnw"
data.test3 <- removeInten(data.test3)
data.test3 <- removeMask(data.test3)


###################################################
### chunk number 20: 
###################################################
#line 300 "xps.Rnw"
library(xps)
scheme.test3 <- root.scheme(file.path(.path.package("xps"), "schemes", "SchemeTest3.root"))
data.test3 <- root.data(scheme.test3, file.path(.path.package("xps"),"rootdata", "DataTest3_cel.root"))


###################################################
### chunk number 21: 
###################################################
#line 318 "xps.Rnw"
data.rma <- rma(data.test3, "tmpdt_Test3RMA", verbose=FALSE)


###################################################
### chunk number 22: 
###################################################
#line 330 "xps.Rnw"
data.mas5 <- mas5(data.test3, "tmpdt_Test3MAS5", normalize=TRUE, sc=500, update=TRUE, verbose=FALSE)


###################################################
### chunk number 23: 
###################################################
#line 337 "xps.Rnw"
expr.rma <- validData(data.rma)
expr.mas5 <- validData(data.mas5)


###################################################
### chunk number 24: plot
###################################################
#line 344 "xps.Rnw"
plot(expr.rma[,1],expr.mas5[,1],log="xy",xlim=c(1,20000),ylim=c(1,20000))


###################################################
### chunk number 25: 
###################################################
#line 356 "xps.Rnw"
call.mas5 <- mas5.call(data.test3,"tmpdt_Test3Call", verbose=FALSE)


###################################################
### chunk number 26: 
###################################################
#line 361 "xps.Rnw"
call.dabg <- dabg.call(data.test3,"tmpdt_Test3DABG", verbose=FALSE)


###################################################
### chunk number 27: 
###################################################
#line 371 "xps.Rnw"
pres.mas5 <- presCall(call.mas5)
head(pres.mas5)


###################################################
### chunk number 28: 
###################################################
#line 376 "xps.Rnw"
pval.mas5 <- pvalData(call.mas5)
head(pval.mas5)


###################################################
### chunk number 29: hist-rma
###################################################
#line 395 "xps.Rnw"
hist(data.rma)


###################################################
### chunk number 30: boxplot-rma
###################################################
#line 404 "xps.Rnw"
boxplot(data.rma)


###################################################
### chunk number 31: mvaplot
###################################################
#line 413 "xps.Rnw"
mvaplot(data.rma, pch=20, ylim=c(-2,2), names="TestB1.mdp_LEVEL")


###################################################
### chunk number 32: callplot
###################################################
#line 422 "xps.Rnw"
callplot(call.mas5)


###################################################
### chunk number 33: 
###################################################
#line 432 "xps.Rnw"
getTreeNames(rootFile(data.mas5))


###################################################
### chunk number 34: 
###################################################
#line 440 "xps.Rnw"
bgrd <- export.root(rootFile(data.mas5),schemeFile(data.mas5),"PreprocesSet","TestA2","wbg","fBg","BgrdROOTOut.txt",as.dataframe=TRUE, verbose=FALSE)


###################################################
### chunk number 35: 
###################################################
#line 445 "xps.Rnw"
wbg <- matrix(bgrd[,"BGRD"], ncol=ncols(schemeSet(data.mas5)), nrow=nrows(schemeSet(data.mas5)))


###################################################
### chunk number 36: image-bg
###################################################
#line 452 "xps.Rnw"
image(log2(wbg))


###################################################
### chunk number 37: 
###################################################
#line 495 "xps.Rnw"
prefltr <- PreFilter(mad=c(0.5), lothreshold=c(7.0,0.02,"mean"), hithreshold=c(10.5,80.0,"percent"))
str(prefltr)


###################################################
### chunk number 38: 
###################################################
#line 502 "xps.Rnw"
data.rma@rootfile <- paste(.path.package("xps"),"rootdata/tmp_Test3RMA.root",sep="/")
data.rma@filedir  <- paste(.path.package("xps"),"rootdata",sep="/")


###################################################
### chunk number 39: 
###################################################
#line 507 "xps.Rnw"
rma.pfr <- prefilter(data.rma, "tmpdt_Test3Prefilter", getwd(),
                     filter=prefltr, minfilters=2, verbose=FALSE)


###################################################
### chunk number 40: 
###################################################
#line 513 "xps.Rnw"
tmp <- validData(rma.pfr)
head(tmp)
dim(tmp[tmp[,"FLAG"]==1,])


###################################################
### chunk number 41: 
###################################################
#line 547 "xps.Rnw"
unifltr <- UniFilter(foldchange=c(1.3,"both"), unifilter=c(0.1,"pval"))


###################################################
### chunk number 42: 
###################################################
#line 555 "xps.Rnw"
data.rma@rootfile <- paste(.path.package("xps"),"rootdata/tmp_Test3RMA.root",sep="/")
data.rma@filedir  <- paste(.path.package("xps"),"rootdata",sep="/")


###################################################
### chunk number 43: 
###################################################
#line 560 "xps.Rnw"
rma.ufr <- unifilter(data.rma, "tmpdt_Test3Unifilter", getwd(),
                     unifltr, group=c("GrpA","GrpA","GrpB","GrpB"),
                     xps.fltr=rma.pfr, verbose=FALSE)


###################################################
### chunk number 44: 
###################################################
#line 567 "xps.Rnw"
tmp <- validData(rma.ufr)
tmp


###################################################
### chunk number 45: 
###################################################
#line 577 "xps.Rnw"
msk <- validFilter(rma.ufr)
tmp <- validData(rma.ufr, which="UnitName")
tmp <- cbind(tmp, msk)


###################################################
### chunk number 46: 
###################################################
#line 585 "xps.Rnw"
tmp <- export.filter(rma.ufr, treetype="stt",
                     varlist="fUnitName:fName:fSymbol:fc:pval:flag",
                     as.dataframe=TRUE, verbose=FALSE)
head(tmp)


###################################################
### chunk number 47: volcanoplot
###################################################
#line 600 "xps.Rnw"
volcanoplot(rma.ufr, labels="fSymbol")


###################################################
### chunk number 48:  eval=FALSE
###################################################
## #line 633 "xps.Rnw"
## library(xps)
## libdir <- "/path/to/Affy/libraryfiles"
## anndir <- "/path/to/Affy/Annotation"
## scmdir <- "/path/to/CRAN/Workspaces/Schemes"


###################################################
### chunk number 49:  eval=FALSE
###################################################
## #line 641 "xps.Rnw"
## scheme.test3 <- import.expr.scheme("Scheme_Test3_na28", 
##                        filedir=scmdir,  
##                        paste(libdir,"Test3.CDF",sep="/"), 
##                        paste(libdir,"Test3_probe.tab",sep="/"), 
##                        paste(anndir,"Test3.na28.annot.csv",sep="/"))


###################################################
### chunk number 50:  eval=FALSE
###################################################
## #line 652 "xps.Rnw"
## scmdir <- "/path/to/CRAN/Workspaces/Schemes"
## scheme.test3 <- root.scheme(paste(scmdir,"SchemeTest3.root",sep="/"))


###################################################
### chunk number 51:  eval=FALSE
###################################################
## #line 673 "xps.Rnw"
## scheme.test3 <- import.expr.scheme("Scheme_Test3_na28",..., add.mask=TRUE)


###################################################
### chunk number 52:  eval=FALSE
###################################################
## #line 708 "xps.Rnw"
## library(Biobase)
## expr.rma <- validData(data.rma)
## minimalSet <- new("ExpressionSet", exprs = as.matrix(expr.rma))


###################################################
### chunk number 53:  eval=FALSE
###################################################
## #line 718 "xps.Rnw"
## vv <- minimalSet[1:5,1:3]
## featureNames(vv)
## sampleNames(vv)
## exprs(vv)


###################################################
### chunk number 54:  eval=FALSE
###################################################
## #line 741 "xps.Rnw"
## root.image(data.exon, treename="BreastA.cel", zlim=c(3,11), w=400, h=400)


###################################################
### chunk number 55:  eval=FALSE
###################################################
## #line 762 "xps.Rnw"
## root.density(data.exon, "*", w=400, h=400)
## root.density(data.x.rma, "*", w=400, h=400)


###################################################
### chunk number 56:  eval=FALSE
###################################################
## #line 778 "xps.Rnw"
## root.profile(data.x.rma, w=640, h=400)


###################################################
### chunk number 57:  eval=FALSE
###################################################
## #line 798 "xps.Rnw"
## root.graph2D(data.exon, "BreastA.cel", "BreastB.cel")
## root.graph2D(data.x.rma, "BreastA.mdp", "BreastB.mdp")


###################################################
### chunk number 58:  eval=FALSE
###################################################
## #line 820 "xps.Rnw"
## root.hist2D(data.exon, "BreastA.cel", "BreastB.cel", option="COLZ")
## root.hist2D(data.x.rma, "BreastA.mdp", "BreastB.mdp", option="COLZ")
## root.hist2D(data.x.rma, "BreastA.mdp", "BreastB.mdp", option="SURF2")


###################################################
### chunk number 59:  eval=FALSE
###################################################
## #line 842 "xps.Rnw"
## root.hist3D(data.exon, "BreastA.cel", "BreastB.cel", "BreastC.cel", option="SCAT")
## root.hist3D(data.x.rma, "BreastA.mdp", "BreastB.mdp", "BreastC.mdp", option="SCAT")


###################################################
### chunk number 60:  eval=FALSE
###################################################
## #line 889 "xps.Rnw"
## data.farms <- farms(data.test3,"tmp_Test3FARMS",verbose=FALSE)


###################################################
### chunk number 61:  eval=FALSE
###################################################
## #line 895 "xps.Rnw"
## data.dfw <- dfw(data.test3,"tmp_Test3DFW",verbose=FALSE)


###################################################
### chunk number 62:  eval=FALSE
###################################################
## #line 911 "xps.Rnw"
## call.ini <- ini.call(data.test3,"tmp_Test3INI",verbose=FALSE)


