###################################################
### chunk number 1: 
###################################################
#line 146 "xmapbridge.Rnw"
#We are actually writing everything to a tmp directory behind the scenes.
path     <- tempdir()
old.path <- Sys.getenv( "XMAP_BRIDGE_CACHE" )
Sys.setenv( XMAP_BRIDGE_CACHE=path )
#We put things back later


###################################################
### chunk number 2: 
###################################################
#line 153 "xmapbridge.Rnw"
library( xmapbridge )
set.seed( 100 )
x <- runif( 100, 1100000,1200000 )
y <- 10 * sin( 2 * pi * ( x-1000000 ) / 10000 )


###################################################
### chunk number 3:  eval=FALSE
###################################################
## #line 159 "xmapbridge.Rnw"
## xmap.plot( x, y, species="homo_sapiens", chr="1", type="line" )


###################################################
### chunk number 4: 
###################################################
#line 162 "xmapbridge.Rnw"
cat( xmap.debug( xmap.plot( x, y, species="homo_sapiens", chr="1", type="line" ), newlines=TRUE ) )


###################################################
### chunk number 5: 
###################################################
#line 212 "xmapbridge.Rnw"
data(xmapbridge)


###################################################
### chunk number 6: 
###################################################
#line 225 "xmapbridge.Rnw"
l <- split(exon.data,exon.data$"gene")


###################################################
### chunk number 7: 
###################################################
#line 237 "xmapbridge.Rnw"

g <- l[[1]]
x   <- g$"seq_region_end" + (g$"seq_region_end" - g$"seq_region_start")/2
y   <- g[,2]
chr <- unique(g$"name")



###################################################
### chunk number 8:  eval=FALSE
###################################################
## #line 252 "xmapbridge.Rnw"
## xmap.plot(x,y,chr,species="homo_sapiens",type="area",col="#ff000066")


###################################################
### chunk number 9: 
###################################################
#line 255 "xmapbridge.Rnw"
cat( xmap.debug( xmap.plot(x,y,chr,species="homo_sapiens",type="area",col="#ff000066"), newlines=TRUE ) )


###################################################
### chunk number 10:  eval=FALSE
###################################################
## #line 274 "xmapbridge.Rnw"
## xmap.plot(x,y,chr,species="homo_sapiens",type="scatter",col="#ff000066")


###################################################
### chunk number 11: 
###################################################
#line 277 "xmapbridge.Rnw"
cat( xmap.debug( xmap.plot(x,y,chr,species="homo_sapiens",type="scatter",col="#ff000066"), newlines=TRUE ) )


###################################################
### chunk number 12:  eval=FALSE
###################################################
## #line 280 "xmapbridge.Rnw"
## xmap.plot(x,y,chr,species="homo_sapiens",type="line",col="#ff000066")


###################################################
### chunk number 13: 
###################################################
#line 283 "xmapbridge.Rnw"
cat( xmap.debug( xmap.plot(x,y,chr,species="homo_sapiens",type="line",col="#ff000066"), newlines=TRUE ) )


###################################################
### chunk number 14:  eval=FALSE
###################################################
## #line 286 "xmapbridge.Rnw"
## xmap.plot(x,y,chr,species="homo_sapiens",type="bar",col="#ff000066")


###################################################
### chunk number 15: 
###################################################
#line 289 "xmapbridge.Rnw"
cat( xmap.debug( xmap.plot(x,y,chr,species="homo_sapiens",type="bar",col="#ff000066"), newlines=TRUE ) )


###################################################
### chunk number 16:  eval=FALSE
###################################################
## #line 292 "xmapbridge.Rnw"
## xmap.plot(x,y,chr,species="homo_sapiens",type="area",col="#ff000066")


###################################################
### chunk number 17: 
###################################################
#line 295 "xmapbridge.Rnw"
cat( xmap.debug( xmap.plot(x,y,chr,species="homo_sapiens",type="area",col="#ff000066"), newlines=TRUE ) )


###################################################
### chunk number 18:  eval=FALSE
###################################################
## #line 298 "xmapbridge.Rnw"
## xmap.plot(x,y,chr,species="homo_sapiens",type="steparea",col="#ff000066")


###################################################
### chunk number 19: 
###################################################
#line 301 "xmapbridge.Rnw"
cat( xmap.debug( xmap.plot(x,y,chr,species="homo_sapiens",type="steparea",col="#ff000066"), newlines=TRUE ) )


###################################################
### chunk number 20: 
###################################################
#line 318 "xmapbridge.Rnw"
#Pick an interesting gene
g <- l[["ENSG00000128394"]]
x   <- g$"seq_region_end" + (g$"seq_region_end" - g$"seq_region_start")/2
chr <- unique(g$"name")
y <- g[,2]


###################################################
### chunk number 21:  eval=FALSE
###################################################
## #line 325 "xmapbridge.Rnw"
## xmap.plot(x,y,chr,species="homo_sapiens",type="area",col="#ff000033",ylim=c(0,16))


###################################################
### chunk number 22: 
###################################################
#line 328 "xmapbridge.Rnw"
cat( xmap.debug( xmap.plot(x,y,chr,species="homo_sapiens",type="area",col="#ff000033",ylim=c(0,16)), newlines=TRUE ) )


###################################################
### chunk number 23:  eval=FALSE
###################################################
## #line 331 "xmapbridge.Rnw"
## xmap.points(x,y,chr,type="line",col="#ff0000ff")


###################################################
### chunk number 24: 
###################################################
#line 334 "xmapbridge.Rnw"
cat( xmap.debug( xmap.points(x,y,chr,type="line",col="#ff0000ff"), newlines=TRUE ) )


###################################################
### chunk number 25: 
###################################################
#line 338 "xmapbridge.Rnw"
#We were plotting the 1st array (2nd column in g), now plot the 4th (5th column in g)
y <- g[,5]


###################################################
### chunk number 26:  eval=FALSE
###################################################
## #line 342 "xmapbridge.Rnw"
## xmap.points(x,y,chr,type="area",col="#0000ff33")


###################################################
### chunk number 27: 
###################################################
#line 345 "xmapbridge.Rnw"
cat( xmap.debug( xmap.points(x,y,chr,type="area",col="#0000ff33"), newlines=TRUE ) )


###################################################
### chunk number 28:  eval=FALSE
###################################################
## #line 348 "xmapbridge.Rnw"
## xmap.points(x,y,chr,type="line",col="#0000ffff")


###################################################
### chunk number 29: 
###################################################
#line 351 "xmapbridge.Rnw"
cat( xmap.debug( xmap.points(x,y,chr,type="line",col="#0000ffff"), newlines=TRUE ) )


###################################################
### chunk number 30: 
###################################################
#line 404 "xmapbridge.Rnw"
cols.bg <- c(rep("#ff000011",3),rep("#0000ff11",3))
cols.fg <- c(rep("#ff0000ff",3),rep("#0000ffff",3))
names   <- c("7.1","7.2","7.3","10a.1","10a.2","10a.3")


###################################################
### chunk number 31: 
###################################################
#line 418 "xmapbridge.Rnw"
pid <- xmap.project.new("mcf7 vs mcf10a")


###################################################
### chunk number 32: 
###################################################
#line 428 "xmapbridge.Rnw"
plot.a.gene <- function(g,pid) {
  x    <- g$"seq_region_end" + (g$"seq_region_end" - g$"seq_region_start")/2
  y    <- g[,2:7]
  chr  <- unique(g$"name")
  gene <- unique(g$"gene")
  xlim <- range(x)
  gph  <- xmap.graph.new(projectid=pid, name=gene,desc="vignette example", min=0, max=16, chr=chr, start=xlim[1], stop=xlim[2], ylab="value",species="homo_sapiens")
  for(i in 1:6) {
    xmap.points(graphid=gph,x=x,y=y[,i],type="area",col=cols.bg[i],xlab="")
    xmap.points(graphid=gph,x=x,y=y[,i],type="line",col=cols.fg[i],xlab=names[i])
  }
}


###################################################
### chunk number 33: 
###################################################
#line 454 "xmapbridge.Rnw"
lapply(l,plot.a.gene,pid=pid)


###################################################
### chunk number 34: 
###################################################
#line 476 "xmapbridge.Rnw"
library( RColorBrewer )


###################################################
### chunk number 35:  eval=FALSE
###################################################
## #line 479 "xmapbridge.Rnw"
## #A light grey almost transparent step area
## xmap.plot( x, y, type="steparea", col="#11111111", ylab="intensity",
##            chr="4", species="homo_sapiens" )


###################################################
### chunk number 36: 
###################################################
#line 484 "xmapbridge.Rnw"
cat( xmap.debug( xmap.plot( x, y, type="steparea", col="#11111111", ylab="intensity",
           chr="4", species="homo_sapiens" ), newlines=TRUE ) )


###################################################
### chunk number 37:  eval=FALSE
###################################################
## #line 489 "xmapbridge.Rnw"
## #With an opaque orange edge
## xmap.points( x, y, type="step", col="#F7941DFF" )


###################################################
### chunk number 38: 
###################################################
#line 493 "xmapbridge.Rnw"
cat( xmap.debug( xmap.points( x, y, type="step", col="#F7941DFF" ), newlines=TRUE ) )


###################################################
### chunk number 39: 
###################################################
#line 503 "xmapbridge.Rnw"
#Five levels of red, chosen by the RColorBrewer
reds <- brewer.pal( 5, "Reds" )
reds <- xmap.col( reds, alpha=0x55 )

for( i in 1:5 ) {
  xmap.points( x, y / i, type="area", col=reds[i] )
}


###################################################
### chunk number 40: 
###################################################
#line 528 "xmapbridge.Rnw"
#put the environment variable back. Not strictly necessary, but why not?
Sys.setenv(XMAP_BRIDGE_CACHE=old.path)


