###################################################
### chunk number 1:  eval=FALSE
###################################################
## #line 47 "tr_2004_01.Rnw"
## q(save="no")
## 


###################################################
### chunk number 2: 
###################################################
#line 50 "tr_2004_01.Rnw"
library(splines)
library(stats)
library(golubEsets)
library(vsn)
oldopt <- options(digits=3)
on.exit( {options(oldopt)} )
options(width=75)


###################################################
### chunk number 3: 
###################################################
#line 112 "tr_2004_01.Rnw"
data(Golub_Train)
golubNorm <- justvsn(Golub_Train)
id <- as.numeric(Golub_Train$ALL.AML) #$


###################################################
### chunk number 4: 
###################################################
#line 119 "tr_2004_01.Rnw"
Golub_Train$ALL.AML #$
id


###################################################
### chunk number 5: 
###################################################
#line 131 "tr_2004_01.Rnw"
library(twilight)
pval <- twilight.pval(golubNorm, id, B=100)


###################################################
### chunk number 6: 
###################################################
#line 138 "tr_2004_01.Rnw"
data(expval)
expval


###################################################
### chunk number 7: 
###################################################
#line 144 "tr_2004_01.Rnw"
class(expval)
names(expval)


###################################################
### chunk number 8: 
###################################################
#line 150 "tr_2004_01.Rnw"
names(expval$result) #$


###################################################
### chunk number 9: 
###################################################
#line 156 "tr_2004_01.Rnw"
expval$result[1:7,1:5] #$


###################################################
### chunk number 10: 
###################################################
#line 161 "tr_2004_01.Rnw"
bitmap(file="tr_2004_01-scores.png",width=6,height=4.5,pointsize=10)
plot(expval,which="scores",grayscale=F,legend=F)
dev.off()
bitmap(file="tr_2004_01-qvalues.png",width=6,height=4.5,pointsize=10)
plot(expval,which="qvalues")
dev.off()


###################################################
### chunk number 11: 
###################################################
#line 179 "tr_2004_01.Rnw"
expval$pi0 #$


###################################################
### chunk number 12: 
###################################################
#line 213 "tr_2004_01.Rnw"
gene <- exprs(golubNorm)[pval$result$index[1],]
corr <- twilight.pval(golubNorm,gene,method="spearman",quant.ci=0.99,B=100)
corr


###################################################
### chunk number 13: 
###################################################
#line 222 "tr_2004_01.Rnw"
corr$result[1:10,1:5] #$


###################################################
### chunk number 14: 
###################################################
#line 228 "tr_2004_01.Rnw"
bitmap(file="tr_2004_01-corr.png",width=6,height=4.5,pointsize=10)
plot(corr,which="scores",grayscale=F,legend=F)
dev.off()


###################################################
### chunk number 15: 
###################################################
#line 269 "tr_2004_01.Rnw"
yperm <- twilight.filtering(golubNorm,id,method="fc",num.perm=50,num.take=10)
dim(yperm)


###################################################
### chunk number 16: 
###################################################
#line 276 "tr_2004_01.Rnw"
yperm <- yperm[-1,]
b <- twilight.pval(golubNorm,yperm[1,],method="fc",yperm=yperm)
hist(b$result$pvalue,col="gray",br=20)


###################################################
### chunk number 17: 
###################################################
#line 282 "tr_2004_01.Rnw"
bitmap(file="tr_2004_01-hist.png",width=6,height=4.5,pointsize=10)
hist(b$result$pvalue,col="gray",br=20,main="",xlab="P-value")
dev.off()


###################################################
### chunk number 18: 
###################################################
#line 325 "tr_2004_01.Rnw"
data(exfdr)
exfdr



###################################################
### chunk number 19: 
###################################################
#line 329 "tr_2004_01.Rnw"
exfdr$result[1:5,6:9] #$


###################################################
### chunk number 20: 
###################################################
#line 335 "tr_2004_01.Rnw"
bitmap(file="tr_2004_01-fdr.png",width=6,height=4.5,pointsize=10)
plot(exfdr,which="fdr",grayscale=F,legend=T)
dev.off()
bitmap(file="tr_2004_01-volcano.png",width=6,height=4.5,pointsize=10)
plot(exfdr,which="volcano")
dev.off()
bitmap(file="tr_2004_01-effectsize.png",width=6,height=4.5,pointsize=10)
plot(exfdr,which="effectsize",legend=T)
dev.off()


###################################################
### chunk number 21: 
###################################################
#line 368 "tr_2004_01.Rnw"
tab <- plot(exfdr,which="table")
tab[1:8,]


###################################################
### chunk number 22: 
###################################################
#line 395 "tr_2004_01.Rnw"
x <- c(rep(0,2),rep(1,3))
x


###################################################
### chunk number 23: 
###################################################
#line 400 "tr_2004_01.Rnw"
twilight.combi(x,pin=FALSE,bin=FALSE)


###################################################
### chunk number 24: 
###################################################
#line 408 "tr_2004_01.Rnw"
twilight.combi(x,pin=FALSE,bin=TRUE)


###################################################
### chunk number 25: 
###################################################
#line 417 "tr_2004_01.Rnw"
y <- c(rep(0,4),rep(1,4))
y


###################################################
### chunk number 26: 
###################################################
#line 422 "tr_2004_01.Rnw"
twilight.combi(y,pin=TRUE,bin=FALSE)


###################################################
### chunk number 27: 
###################################################
#line 430 "tr_2004_01.Rnw"
twilight.combi(y,pin=TRUE,bin=TRUE)


###################################################
### chunk number 28: 
###################################################
#line 436 "tr_2004_01.Rnw"
twilight.permute.pair(y,7,bal=TRUE)


###################################################
### chunk number 29: 
###################################################
#line 440 "tr_2004_01.Rnw"
Sys.sleep(30)


