###################################################
### chunk number 1: load
###################################################
#line 55 "plotAlongChrom.Rnw"
library("grid")
library("RColorBrewer")
library("tilingArray")


###################################################
### chunk number 2: errorReporting
###################################################
#line 60 "plotAlongChrom.Rnw"
options(error=recover, warn=0, digits=3)


###################################################
### chunk number 3: showTilingArrayData
###################################################
#line 63 "plotAlongChrom.Rnw"
data("segnf")
class(segnf)
ls(segnf)
segnf$"1.+"
head(segnf$"1.+"@y)
dim(segnf$"1.+"@y)
head(segnf$"1.+"@x)
length(segnf$"1.+"@x)
segnf$"1.+"@logLik
segnf$"1.+"@nrSegments
head(segnf$"1.+"@breakpoints[[segnf$"1.+"@nrSegments]])


###################################################
### chunk number 4: gffSub
###################################################
#line 88 "plotAlongChrom.Rnw"
data(gffSub)
head(gffSub)


###################################################
### chunk number 5: alongChromDot1
###################################################
#line 105 "plotAlongChrom.Rnw"
grid.newpage()
plotAlongChrom(segnf,chr=1, coord=c(35000,50000),what="dots", gff=gffSub)


###################################################
### chunk number 6: alongChromDot2
###################################################
#line 115 "plotAlongChrom.Rnw"
segObj = new.env(parent = baseenv())
nmLabel = colnames(segnf$"1.+"@y)
lab = gsub("\\d","",nmLabel)
for(nm in paste(1,c("+","-"),sep=".")){
    s = get(nm,env = segnf)
    rpY =  tapply(1:length(lab),lab,function(i)rowMeans(s@y[,i]))
    s@y = do.call(cbind,rpY)
    assign(nm,s,segObj)
}
grid.newpage()
plotAlongChrom(segObj,chr=1, coord=c(35000,50000),what="dots", gff=gffSub,sepPlot = T)


###################################################
### chunk number 7: alongChromHeatmap1
###################################################
#line 136 "plotAlongChrom.Rnw"
grid.newpage() 
plotAlongChrom(segnf,chr=1, coord=c(35000,50000),what="heatmap", gff=gffSub,
         rowNamesHeatmap=nmLabel,makeRasterImage=FALSE)


###################################################
### chunk number 8: alongChromHeatmap2
###################################################
#line 152 "plotAlongChrom.Rnw"
grid.newpage() 
plotAlongChrom(segnf,chr=1, coord=c(35000,50000),what="heatmap", gff=gffSub,
         rowNamesHeatmap=nmLabel,makeRasterImage=TRUE)


###################################################
### chunk number 9: alongChromHeatmap3
###################################################
#line 164 "plotAlongChrom.Rnw"
grid.newpage() 
plotAlongChrom(segnf,chr=1, coord=c(35000,50000),what="heatmap", gff=gffSub,
         rowNamesHeatmap=nmLabel,makeRasterImage=TRUE,
         colHeatmap = colorRamp(brewer.pal(9, "Blues")))


