###################################################
### chunk number 1: R.hide
###################################################
#line 82 "splicegear.Rnw"
library(splicegear)


###################################################
### chunk number 2: 
###################################################
#line 96 "splicegear.Rnw"
data(spsites)

print(spsites)

plot(spsites)


###################################################
### chunk number 3: 
###################################################
#line 119 "splicegear.Rnw"
library(XML)
filename <- system.file("extdata", "example.xml", package="splicegear")
xml <- xmlTreeParse(filename, asTree=TRUE)


###################################################
### chunk number 4: 
###################################################
#line 128 "splicegear.Rnw"
spsites <- buildSpliceSites(xml, verbose=FALSE)
length(spsites)
show(spsites[1:2])


###################################################
### chunk number 5: 
###################################################
#line 151 "splicegear.Rnw"
## build SpliceSites
library(XML)
filename <- system.file("extdata", "example.xml", package="splicegear")
xml <- xmlTreeParse(filename, asTree=TRUE)
spsites <- buildSpliceSites(xml, verbose=FALSE)

## subset the second object in the list
my.spsites <- spsites[[2]]


###################################################
### chunk number 6: 
###################################################
#line 162 "splicegear.Rnw"
plot(my.spsites)


###################################################
### chunk number 7: 
###################################################
#line 179 "splicegear.Rnw"
data(spliceset)

dataf <- as.data.frame(spliceset)

colnames(dataf)


###################################################
### chunk number 8: 
###################################################
#line 188 "splicegear.Rnw"
lm.panel <- function(x, y, ...) {
                                  points(x,y,...)
                                  p.lm <- lm(y~x); abline(p.lm)
                                }

## to plot probe intensity values conditioned by the position of the probes on
## the mRNA:
## (commented out to avoid a warning)
##coplot(log(exprs) ~ Material | begin, data=dataf, panel=lm.panel)



###################################################
### chunk number 9: 
###################################################
#line 221 "splicegear.Rnw"
## a 10 bp window
seq.length <- as.integer(10)
## positions of the exons
spsiteIpos <- matrix(c(1, 3.5, 5, 9, 3, 4, 8, 10), nc=2)
## known variants
variants <- list(a=c(1,2,3,4), b=c(1,2,3), c=c(1,3,4))
##
n.exons <- nrow(spsiteIpos)

spvar <- new("SpliceSitesGenomic", spsiteIpos=spsiteIpos,
         variants=variants, seq.length=seq.length)


###################################################
### chunk number 10: 
###################################################
#line 238 "splicegear.Rnw"
par(mfrow = c(3,1), mar = c(3.1, 2.1, 2.1, 1.1))

plot(spvar, split=TRUE, col.exon=rainbow(n.exons))


