###################################################
### chunk number 1: lib
###################################################
#line 32 "ld-vignette.Rnw"
require(snpStats)
require(hexbin)


###################################################
### chunk number 2: data
###################################################
#line 41 "ld-vignette.Rnw"
data(ld.example)


###################################################
### chunk number 3: showgt
###################################################
#line 48 "ld-vignette.Rnw"
ceph.1mb
yri.1mb


###################################################
### chunk number 4: showsp
###################################################
#line 53 "ld-vignette.Rnw"
head(support.ld)


###################################################
### chunk number 5: ldstats
###################################################
#line 61 "ld-vignette.Rnw"
ld.ceph <- ld(ceph.1mb, stats=c("D.prime", "R.squared"), depth=100)
ld.yri <- ld(yri.1mb, stats=c("D.prime", "R.squared"), depth=100)


###################################################
### chunk number 6: image1 eval=FALSE
###################################################
## #line 77 "ld-vignette.Rnw"
## image(ld.ceph$D.prime) 


###################################################
### chunk number 7: png1
###################################################
#line 80 "ld-vignette.Rnw"
png(file="image1.png", width=800, height=800)
image(ld.ceph$D.prime)
dev.off()


###################################################
### chunk number 8: image2 eval=FALSE
###################################################
## #line 86 "ld-vignette.Rnw"
## image(ld.yri$D.prime)


###################################################
### chunk number 9: png2
###################################################
#line 89 "ld-vignette.Rnw"
png(file="image2.png", width=800, height=800)
image(ld.yri$D.prime)
dev.off()


###################################################
### chunk number 10: quartiles
###################################################
#line 103 "ld-vignette.Rnw"
quantile(ld.ceph$D.prime@x, na.rm=TRUE)
quantile(ld.yri$D.prime@x, na.rm=TRUE)


###################################################
### chunk number 11: colors
###################################################
#line 110 "ld-vignette.Rnw"
spectrum <- rainbow(10, start=0, end=1/6)[10:1]


###################################################
### chunk number 12: imagecol eval=FALSE
###################################################
## #line 114 "ld-vignette.Rnw"
## image(ld.ceph$D.prime, cuts=9, col.regions=spectrum, colorkey=TRUE)


###################################################
### chunk number 13: pngcol
###################################################
#line 117 "ld-vignette.Rnw"
png(file="imagecol.png", width=800, height=800)
image(ld.ceph$D.prime, cuts=9, col.regions=spectrum, colorkey=TRUE)
dev.off()


###################################################
### chunk number 14: use
###################################################
#line 127 "ld-vignette.Rnw"
use <- 75:274


###################################################
### chunk number 15: image3 eval=FALSE
###################################################
## #line 130 "ld-vignette.Rnw"
## image(ld.ceph$D.prime[use,use])


###################################################
### chunk number 16: png3
###################################################
#line 133 "ld-vignette.Rnw"
png(file="image3.png", width=800, height=800)
image(ld.ceph$D.prime[use,use])
dev.off()


###################################################
### chunk number 17: image4 eval=FALSE
###################################################
## #line 139 "ld-vignette.Rnw"
## image(ld.ceph$R.squared[use,use])


###################################################
### chunk number 18: png4
###################################################
#line 142 "ld-vignette.Rnw"
png(file="image4.png", width=800, height=800)
image(ld.ceph$R.squared[use,use])
dev.off()


###################################################
### chunk number 19: distance
###################################################
#line 156 "ld-vignette.Rnw"
pos <- support.ld$Position
diags <- vector("list", 100)
for (i in 1:100) diags[[i]] <- pos[(i+1):603] - pos[1:(603-i)]
dist <- bandSparse(603, k=1:100, diagonals=diags)


###################################################
### chunk number 20: values
###################################################
#line 165 "ld-vignette.Rnw"
distance <- dist@x
D.prime <- ld.ceph$D.prime@x
R.squared <- ld.ceph$R.squared@x


###################################################
### chunk number 21: drplot
###################################################
#line 173 "ld-vignette.Rnw"
plot(hexbin(D.prime^2, R.squared))


###################################################
### chunk number 22: dpplot1
###################################################
#line 180 "ld-vignette.Rnw"
plot(hexbin(distance, D.prime, xbin=10))


###################################################
### chunk number 23: dpplot2
###################################################
#line 183 "ld-vignette.Rnw"
plot(hexbin(distance, R.squared, xbin=10))


###################################################
### chunk number 24: two
###################################################
#line 194 "ld-vignette.Rnw"
snp1 <- as(ceph.1mb[,1], "character")
snp5 <- as(ceph.1mb[,5], "character")
tab33 <- table(snp1, snp5)
tab33


###################################################
### chunk number 25: twoDR
###################################################
#line 201 "ld-vignette.Rnw"
ld.ceph$D.prime[1,5]
ld.ceph$R.squared[1,5]


###################################################
### chunk number 26: digits
###################################################
#line 244 "ld-vignette.Rnw"
options(digits=4)


###################################################
### chunk number 27: OR
###################################################
#line 247 "ld-vignette.Rnw"
OR <- ld(ceph.1mb[,1], ceph.1mb[,5], stats="OR")
OR
AABB <- tab33[2,2]*OR/(1+OR)
ABBA <- tab33[2,2]*1/(1+OR)
AABB
ABBA


###################################################
### chunk number 28: twoxtwo
###################################################
#line 255 "ld-vignette.Rnw"
a <- format(2*tab33[1,1] + tab33[1,2] + tab33[2,1] + AABB, digits=4)
b <- format(2*tab33[1,3] + tab33[1,2] + tab33[2,3] + ABBA, digits=4)
c <- format(2*tab33[3,1] + tab33[2,1] + tab33[3,2] + ABBA, digits=4)
d <- format(2*tab33[3,3] + tab33[3,2] + tab33[2,3] + AABB, digits=4)


###################################################
### chunk number 29: extent
###################################################
#line 295 "ld-vignette.Rnw"
left <- ld(ceph.1mb[,168], ceph.1mb[,68:167], stats="D.prime")
right <- ld(ceph.1mb[,168], ceph.1mb[,169:268], stats="D.prime")
D.prime <- c(left, right)
where <- pos[c(68:167, 169:268)]


###################################################
### chunk number 30: eplot
###################################################
#line 302 "ld-vignette.Rnw"
plot(where, D.prime)
lines(where, smooth(D.prime))


