### R code from vignette source 'clustering-comparison-vignette.Rnw'

###################################################
### code chunk number 1: init
###################################################
library(snpMatrix)
load(system.file("data/Genotypes.GenTrain1.RData",package="snpMatrix"))
load(system.file("data/Genotypes.GenTrain2.RData",package="snpMatrix"))


###################################################
### code chunk number 2: clustering-comparison-vignette.Rnw:65-67
###################################################
ab.signals <- read.wtccc.signals(system.file("extdata/example-new.txt", package="snpMatrix"),
                                 paste("rs", 1:99, sep=""))


###################################################
### code chunk number 3: clustering-comparison-vignette.Rnw:72-73
###################################################
col.summary(GenTrain2)[1:3,2:7]


###################################################
### code chunk number 4: lothist
###################################################
result <- snp.compare(GenTrain1, GenTrain2)
diff.counts <- result$count
hist(diff.counts,breaks=50,col='black')


###################################################
### code chunk number 5: clustering-comparison-vignette.Rnw:93-98
###################################################
dim(GenTrain1)
diff.counts[diff.counts > 1550 * 0.1]
diff.counts[diff.counts > 1550 * 0.05]
worst.snps <- names(diff.counts[diff.counts > 1550 * 0.20])
worst.snps


###################################################
### code chunk number 6: plot-clus1gtrs22
###################################################
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs22']], GenTrain1[,'rs22'], title='rs22 GenTrain1')
snp.clust.plot(ab.signals[['rs22']], GenTrain2[,'rs22'], title='rs22 GenTrain2')


###################################################
### code chunk number 7: plot-clus1gtrs27
###################################################
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs27']], GenTrain1[,'rs27'], title='rs27 GenTrain1')
snp.clust.plot(ab.signals[['rs27']], GenTrain2[,'rs27'], title='rs27 GenTrain2')


###################################################
### code chunk number 8: plot-clus1gtrs62
###################################################
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs62']], GenTrain1[,'rs62'], title='rs62 GenTrain1')
snp.clust.plot(ab.signals[['rs62']], GenTrain2[,'rs62'], title='rs62 GenTrain2')


###################################################
### code chunk number 9: plot-clus1gtrs80
###################################################
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs80']], GenTrain1[,'rs80'], title='rs80 GenTrain1')
snp.clust.plot(ab.signals[['rs80']], GenTrain2[,'rs80'], title='rs80 GenTrain2')


###################################################
### code chunk number 10: plot-clus1gtrs94
###################################################
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs94']], GenTrain1[,'rs94'], title='rs94 GenTrain1')
snp.clust.plot(ab.signals[['rs94']], GenTrain2[,'rs94'], title='rs94 GenTrain2')


###################################################
### code chunk number 11: lothist2
###################################################
count.signed <- result$count.signed
hist(count.signed,breaks=50,col='black')


###################################################
### code chunk number 12: clustering-comparison-vignette.Rnw:170-171
###################################################
result$count.signed[result$count.signed < -30]


###################################################
### code chunk number 13: plot-clus1gtrs13
###################################################
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs13']], GenTrain1[,'rs13'], title='rs13 GenTrain1')
snp.clust.plot(ab.signals[['rs13']], GenTrain2[,'rs13'], title='rs13 GenTrain2')


###################################################
### code chunk number 14: plot-clus1gtrs69
###################################################
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs69']], GenTrain1[,'rs69'], title='rs69 GenTrain1')
snp.clust.plot(ab.signals[['rs69']], GenTrain2[,'rs69'], title='rs69 GenTrain2')


###################################################
### code chunk number 15: clustering-comparison-vignette.Rnw:194-196
###################################################
col.summary(GenTrain1)[worst.snps,2:7]
col.summary(GenTrain2)[worst.snps,2:7]


