###################################################
### chunk number 1: 
###################################################
#line 61 "siggenes.Rnw"
library(siggenes)


###################################################
### chunk number 2: 
###################################################
#line 65 "siggenes.Rnw"
library(siggenes)


###################################################
### chunk number 3: 
###################################################
#line 75 "siggenes.Rnw"
data(golub)


###################################################
### chunk number 4: 
###################################################
#line 150 "siggenes.Rnw"
args(sam)


###################################################
### chunk number 5: 
###################################################
#line 156 "siggenes.Rnw"
args(d.stat)


###################################################
### chunk number 6: 
###################################################
#line 191 "siggenes.Rnw"
args.sam(summary)


###################################################
### chunk number 7: 
###################################################
#line 265 "siggenes.Rnw"
n <- 10
rep(1, n)


###################################################
### chunk number 8: 
###################################################
#line 281 "siggenes.Rnw"
n1 <- n2 <- 5
rep(c(0, 1), c(n1, n2))


###################################################
### chunk number 9: 
###################################################
#line 309 "siggenes.Rnw"
K <- 5
c((-1:-5), 1:5)


###################################################
### chunk number 10: 
###################################################
#line 323 "siggenes.Rnw"
K <- 5
rep(1:K, e = 2) * rep(c(-1 ,1), K)


###################################################
### chunk number 11: 
###################################################
#line 336 "siggenes.Rnw"
K <- 5
cbind(rep(c(-1, 1), 5), rep(1:5, e = 2))


###################################################
### chunk number 12: 
###################################################
#line 375 "siggenes.Rnw"
sam.out <- sam(golub, golub.cl, rand = 123, gene.names = golub.gnames[,3])
sam.out


###################################################
### chunk number 13: 
###################################################
#line 401 "siggenes.Rnw"
sam.out2 <- sam(golub, golub.cl, method = wilc.stat, rand = 123)


###################################################
### chunk number 14: 
###################################################
#line 407 "siggenes.Rnw"
summary(sam.out)


###################################################
### chunk number 15: 
###################################################
#line 421 "siggenes.Rnw"
print(sam.out, seq(1.5, 2.4, 0.1))


###################################################
### chunk number 16: 
###################################################
#line 471 "siggenes.Rnw"
sum.sam.out <- summary(sam.out, 3.3)
sum.sam.out


###################################################
### chunk number 17: 
###################################################
#line 486 "siggenes.Rnw"
print(sum.sam.out, varNames = "Proteins")


###################################################
### chunk number 18: 
###################################################
#line 495 "siggenes.Rnw"
sum.sam.out@row.sig.genes


###################################################
### chunk number 19: 
###################################################
#line 501 "siggenes.Rnw"
sum.sam.out@mat.fdr


###################################################
### chunk number 20: 
###################################################
#line 507 "siggenes.Rnw"
sum.sam.out@mat.sig


###################################################
### chunk number 21: 
###################################################
#line 513 "siggenes.Rnw"
list.siggenes(sam.out, 3.3)


###################################################
### chunk number 22: 
###################################################
#line 521 "siggenes.Rnw"
findDelta(sam.out, fdr = 0.05)


###################################################
### chunk number 23: 
###################################################
#line 535 "siggenes.Rnw"
findDelta(sam.out, genes = 200)


###################################################
### chunk number 24: 
###################################################
#line 554 "siggenes.Rnw"
find.out <- find.a0(golub, golub.cl, rand = 123)


###################################################
### chunk number 25: 
###################################################
#line 561 "siggenes.Rnw"
find.out


###################################################
### chunk number 26: 
###################################################
#line 570 "siggenes.Rnw"
print(find.out, 0.95)


###################################################
### chunk number 27: 
###################################################
#line 605 "siggenes.Rnw"
ebam(find.out)


###################################################
### chunk number 28: 
###################################################
#line 613 "siggenes.Rnw"
ebam(find.out, which.a0 = 2)


###################################################
### chunk number 29: 
###################################################
#line 626 "siggenes.Rnw"
ebam(golub, golub.cl, a0 = 0, fast = TRUE, rand = 123)


###################################################
### chunk number 30: 
###################################################
#line 641 "siggenes.Rnw"
ebam.out <- ebam(golub, golub.cl, a0 = 0, rand = 123)


###################################################
### chunk number 31: 
###################################################
#line 652 "siggenes.Rnw"
print(ebam.out, seq(0.91, 0.99, 0.01))


###################################################
### chunk number 32: 
###################################################
#line 676 "siggenes.Rnw"
summary(ebam.out, 0.99997)


###################################################
### chunk number 33: 
###################################################
#line 694 "siggenes.Rnw"
ebam(golub, golub.cl, a0 = 0, var.equal = TRUE, rand = 123)


###################################################
### chunk number 34: 
###################################################
#line 702 "siggenes.Rnw"
ebam(golub, golub.cl, quan.a0 = 0.5, rand = 123)


###################################################
### chunk number 35: 
###################################################
#line 710 "siggenes.Rnw"
ebam(golub, golub.cl, method = wilc.ebam, rand =123)


###################################################
### chunk number 36: 
###################################################
#line 778 "siggenes.Rnw"
t.stat <- function(data, cl){
    require(genefilter) ||
        stop("genefilter required.")
    cl <- as.factor(cl)
    row.out <- rowttests(data, cl)
    d <- row.out$statistic
    m <- length(na.exclude(d))
    d.bar <- qt(((1:m) - 0.5)/m, length(cl) - 2)
    p.value <- row.out$p.value
    vec.false <- m * p.value/2
    s <- row.out$dm/d
    msg <- paste("SAM Two-Class Analysis",
         "Assuming Normality\n\n")
    list(d = -d, d.bar = d.bar, p.value = p.value,
        vec.false = vec.false, s = s, s0 = 0,
        mat.samp = matrix(numeric(0)),
        msg = msg, fold = numeric(0))
}


###################################################
### chunk number 37: 
###################################################
#line 809 "siggenes.Rnw"
sam(golub, golub.cl, method = t.stat)


###################################################
### chunk number 38: 
###################################################
#line 855 "siggenes.Rnw"
t.find <- function(data, cl, B = 50){
    require(genefilter)
    z.fun <- function(data, cl){
        cl <- as.factor(cl)
        out <- rowttests(data, cl)
        r<- out$dm
        s<- r / out$statistic
        return(list(r = -r, s = s))
    }
    mat.samp <- matrix(0, B, length(cl))
    for(i in 1:B)
        mat.samp[i, ] <- sample(cl)
    z.out <- z.fun(data, cl)
    msg <- paste("EBAM Analysis with a Moderated t-Statistic\n\n")
    list(r = z.out$r, s = z.out$s,
        mat.samp = mat.samp, z.fun = z.fun, msg = msg)
}


###################################################
### chunk number 39: 
###################################################
#line 882 "siggenes.Rnw"
t.out <- find.a0(golub, golub.cl, method = t.find, B = 100, rand =123)
t.out


###################################################
### chunk number 40: 
###################################################
#line 889 "siggenes.Rnw"
find.a0(golub, golub.cl, var.equal = TRUE, rand =123)


###################################################
### chunk number 41: 
###################################################
#line 895 "siggenes.Rnw"
ebam(t.out)


###################################################
### chunk number 42: 
###################################################
#line 929 "siggenes.Rnw"
t.ebam<-function(data, cl){
    require(genefilter)
    cl <- as.factor(cl)
    out <- rowttests(data, cl)
    z <- -out$statistic
    z.dens <- denspr(z)$y
    m <- length(z)
    vec.pos <- m * out$p.value / 2
    z.null <- dt(z, length(cl) - 2)
    msg<-paste("EBAM Analysis with t-Statistic Assuming Normality.\n\n")
    list(z = z, ratio = z.null/z.dens, vec.pos = vec.pos,
        vec.neg = vec.pos, msg = msg)
}


###################################################
### chunk number 43: 
###################################################
#line 952 "siggenes.Rnw"
ebam(golub, golub.cl, method = t.ebam)


