###################################################
### chunk number 1: loading rGADEM package
###################################################
#line 49 "rGADEM.Rnw"
library(rGADEM)


###################################################
### chunk number 2: loading BSgenome package
###################################################
#line 54 "rGADEM.Rnw"
library(BSgenome.Hsapiens.UCSC.hg18)


###################################################
### chunk number 3: BED File
###################################################
#line 66 "rGADEM.Rnw"
pwd<-"" #INPUT FILES- BedFiles, FASTA, etc.
path<- system.file("extdata/Test_100.bed",package="rGADEM")
BedFile<-paste(pwd,path,sep="")
BED<-read.table(BedFile,header=FALSE,sep="\t")
BED<-data.frame(chr=as.factor(BED[,1]),start=as.numeric(BED[,2]),end=as.numeric(BED[,3]))


###################################################
### chunk number 4: Create the RD Files
###################################################
#line 76 "rGADEM.Rnw"
rgBED<-IRanges(start=BED[,2],end=BED[,3])
Sequences<-RangedData(rgBED,space=BED[,1])


###################################################
### chunk number 5: Create the RD Files eval=FALSE
###################################################
## #line 83 "rGADEM.Rnw"
## 
## pwd<-"" #INPUT FILES- BedFiles, FASTA, etc.
## path<- system.file("extdata/Test_100.fasta",package="rGADEM")
## FastaFile<-paste(pwd,path,sep="")
## Sequences <- read.DNAStringSet(FastaFile, "fasta")


###################################################
### chunk number 6: rGADEM analysis
###################################################
#line 103 "rGADEM.Rnw"
gadem<-GADEM(Sequences,verbose=1,genome=Hsapiens)


###################################################
### chunk number 7: prepare PWM eval=FALSE
###################################################
## #line 114 "rGADEM.Rnw"
## path<- system.file("extdata/jaspar2009.txt",package="rGADEM")
## seededPwm<-readPWMfile(path)
## grep("STAT1",names(seededPwm))
## STAT1.PWM=seededPwm[103]


###################################################
### chunk number 8: rGADEM seeded analysis eval=FALSE
###################################################
## #line 124 "rGADEM.Rnw"
## gadem<-GADEM(Sequences,verbose=1,genome=Hsapiens,Spwm=STAT1.PWM, fixSeeded=TRUE)


###################################################
### chunk number 9: rGADEM seeded analysis eval=FALSE
###################################################
## #line 130 "rGADEM.Rnw"
## gadem<-GADEM(Sequences,verbose=1,genome=Hsapiens,Spwm=STAT1.PWM)


###################################################
### chunk number 10: pwm
###################################################
#line 147 "rGADEM.Rnw"
nOccurrences(gadem)


###################################################
### chunk number 11: pwm
###################################################
#line 151 "rGADEM.Rnw"
nOccurrences(gadem)[1]


###################################################
### chunk number 12: consensus
###################################################
#line 156 "rGADEM.Rnw"
consensus(gadem)


###################################################
### chunk number 13: consensus
###################################################
#line 162 "rGADEM.Rnw"
consensus(gadem)[1]


###################################################
### chunk number 14: position
###################################################
#line 168 "rGADEM.Rnw"
startPos(gadem)


###################################################
### chunk number 15: position
###################################################
#line 174 "rGADEM.Rnw"
endPos(gadem)


###################################################
### chunk number 16: parameters eval=FALSE
###################################################
## #line 180 "rGADEM.Rnw"
## gadem@parameters


