###################################################
### chunk number 1: LoadPackageToDetermineVersion
###################################################
#line 29 "procoil.Rnw"
options(width=65)
set.seed(0)
library(procoil)
procoilVersion <- packageDescription("procoil")$Version
procoilDateRaw <- packageDescription("procoil")$Date
procoilDateYear <- as.numeric(substr(procoilDateRaw, 1, 4))
procoilDateMonth <- as.numeric(substr(procoilDateRaw, 6, 7))
procoilDateDay <- as.numeric(substr(procoilDateRaw, 9, 10))
procoilDate <- paste(month.name[procoilDateMonth], " ",
                     procoilDateDay, ", ",
                     procoilDateYear, sep="")


###################################################
### chunk number 2: InstallPrOCoil eval=FALSE
###################################################
## #line 377 "procoil.Rnw"
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("procoil")


###################################################
### chunk number 3: LoadPrOCoil eval=FALSE
###################################################
## #line 389 "procoil.Rnw"
## library(procoil)


###################################################
### chunk number 4: PredictGCN4WildType
###################################################
#line 400 "procoil.Rnw"
GCN4wt <- predict(PrOCoilModel, "MKQLEDKVEELLSKNYHLENEVARLKKLV", "abcdefgabcdefgabcdefgabcdefga")


###################################################
### chunk number 5: PredictGCN4WildType2
###################################################
#line 416 "procoil.Rnw"
GCN4wt <- predict(PrOCoilModel, reg="abcdefgabcdefgabcdefgabcdefga",
                  seq="MKQLEDKVEELLSKNYHLENEVARLKKLV")


###################################################
### chunk number 6: DisplayResultForGCN4WildType
###################################################
#line 437 "procoil.Rnw"
GCN4wt


###################################################
### chunk number 7: PlotResultForGCN4WildType
###################################################
#line 446 "procoil.Rnw"
plot(GCN4wt)


###################################################
### chunk number 8: PredictMarcoilExample
###################################################
#line 471 "procoil.Rnw"
res <- predict(PrOCoilModel,
"MGECDQLLVFMITSRVLVLSTLIIMDSRQVYLENLRQFAENLRQNIENVHSFLENLRADLENLRQKFPGKWYSAMPGRHG",
"-------------------------------abcdefgabcdefgabcdefgabcdefgabcdefg--------------")


###################################################
### chunk number 9: DisplayResultForMarcoilExample
###################################################
#line 480 "procoil.Rnw"
res


###################################################
### chunk number 10: PlotResultForMarcoilExample
###################################################
#line 492 "procoil.Rnw"
plot(res[[1]])


###################################################
### chunk number 11: PredictGCN4Mutation
###################################################
#line 508 "procoil.Rnw"
GCN4m <- predict(PrOCoilModel, "MKQLEDKVEELLSKIYHNENEVARLKKLV", "abcdefgabcdefgabcdefgabcdefga")
GCN4m
plot(GCN4wt, GCN4m)


###################################################
### chunk number 12: PlotResultForExampleWithHeptadIrregularity
###################################################
#line 547 "procoil.Rnw"
plot(predict(PrOCoilModel, "LQDTLVRQERPIRKSIEDLRNTV", "defgabcdefgabcdabcdefga"))


###################################################
### chunk number 13: ReadModelFile eval=FALSE
###################################################
## #line 590 "procoil.Rnw"
## readCCModel("http://www.bioinf.jku.at/software/procoil/PrOCoilModel.patternmodel")


###################################################
### chunk number 14: ShowDefaultModel
###################################################
#line 595 "procoil.Rnw"
PrOCoilModel


###################################################
### chunk number 15: CustomPlot
###################################################
#line 607 "procoil.Rnw"
plot(GCN4wt, GCN4m, legend=c("wild type", "mutant N16I,L19N"),
     col=c(rgb(0.7,0,0), rgb(0,0,0.8)), main="GCN4 Mutation Analysis",
     shades=c(rgb(0.77,0.85,0.95),rgb(0.99,0.84,0.71)))


###################################################
### chunk number 16: PlotProfileToGraphicsFile eval=FALSE
###################################################
## #line 628 "procoil.Rnw"
## pdf(file="GCN4wt.pdf",height=6,width=nchar(GCN4wt@seq)*6/24)
## plot(GCN4wt)
## dev.off()
## bmp(file="GCN4wt.bmp",height=480,width=nchar(GCN4wt@seq)*480/24)
## plot(GCN4wt)
## dev.off()


###################################################
### chunk number 17: GCN4ExampleWithAttribute
###################################################
#line 645 "procoil.Rnw"
GCN4wtseq<-"MKQLEDKVEELLSKNYHLENEVARLKKLV"
attr(GCN4wtseq,"reg")<-"abcdefgabcdefgabcdefgabcdefga"
predict(PrOCoilModel,GCN4wtseq)


###################################################
### chunk number 18: GCN4ExampleUsingBiostringWithAttribute
###################################################
#line 651 "procoil.Rnw"
require(Biostrings)
GCN4wtseq2<-AAString("MKQLEDKVEELLSKNYHLENEVARLKKLV")
attr(GCN4wtseq2,"reg")<-"abcdefgabcdefgabcdefgabcdefga"
predict(PrOCoilModel,GCN4wtseq2)


###################################################
### chunk number 19: GCN4ExampleUsingBiostringWithMetaData
###################################################
#line 659 "procoil.Rnw"
GCN4wtseq3<-AAString("MKQLEDKVEELLSKNYHLENEVARLKKLV")
GCN4wtseq3@metadata$reg<-"abcdefgabcdefgabcdefgabcdefga"
predict(PrOCoilModel,GCN4wtseq3)


###################################################
### chunk number 20: DisplayModels
###################################################
#line 770 "procoil.Rnw"
PrOCoilModel
weights(PrOCoilModel)["N..La"]
PrOCoilModelBA
weights(PrOCoilModelBA)["N..La"]


###################################################
### chunk number 21: DisplayWeights
###################################################
#line 781 "procoil.Rnw"
noP<-length(weights(PrOCoilModel))
names(weights(PrOCoilModel))[1:25]
names(weights(PrOCoilModel))[noP:(noP-24)]


###################################################
### chunk number 22: DisplayBibTeXReference eval=FALSE
###################################################
## #line 862 "procoil.Rnw"
## toBibtex(citation("procoil"))


