###################################################
### chunk number 1: PLGEMwrapper
###################################################
#line 51 "plgem.Rnw"
library(plgem)
data(LPSeset)
set.seed(123)
LPSdegList <- run.plgem(esdata=LPSeset)


###################################################
### chunk number 2: modelFitting
###################################################
#line 113 "plgem.Rnw"
LPSfit <- plgem.fit(data=LPSeset, covariate=1, fitCondition='C', p=10, q=0.5,
  plot.file=FALSE, fittingEval=TRUE, verbose=TRUE)


###################################################
### chunk number 3: observedSTN
###################################################
#line 139 "plgem.Rnw"
LPSobsStn <- plgem.obsStn(data=LPSeset, covariate=1, baselineCondition=1,
  plgemFit=LPSfit, verbose=TRUE)


###################################################
### chunk number 4: resampledSTN
###################################################
#line 156 "plgem.Rnw"
set.seed(123)
LPSresampledStn <- plgem.resampledStn(data=LPSeset, plgemFit=LPSfit,
  iterations="automatic", verbose=TRUE)


###################################################
### chunk number 5: Pvalues
###################################################
#line 169 "plgem.Rnw"
LPSpValues <- plgem.pValue(observedStn=LPSobsStn,
  plgemResampledStn=LPSresampledStn, verbose=TRUE)
head(LPSpValues)


###################################################
### chunk number 6: DEGselection
###################################################
#line 184 "plgem.Rnw"
LPSdegList <- plgem.deg(observedStn=LPSobsStn, plgemPval=LPSpValues,
  delta=0.001, verbose=TRUE)
head(LPSdegList$significant[["0.001"]][["LPS_vs_C"]])


###################################################
### chunk number 7: sessionInfo
###################################################
#line 203 "plgem.Rnw"
sessionInfo()


