###################################################
### chunk number 1: init
###################################################
#line 49 "phenoDist.Rnw"
display <- function(...) {invisible()}


###################################################
### chunk number 2: library
###################################################
#line 53 "phenoDist.Rnw"
library('imageHTS')


###################################################
### chunk number 3: imageHTSSetup
###################################################
#line 57 "phenoDist.Rnw"
localPath <- file.path(tempdir(), 'kimorph')
serverURL <- 'http://www.ebi.ac.uk/~gpau/imageHTS/screens/kimorph'
x <- parseImageConf('conf/imageconf.txt', localPath=localPath, serverURL=serverURL)
x <- configure(x, 'conf/description.txt', 'conf/plateconf.txt', 'conf/screenlog.txt')
x <- annotate(x, 'conf/annotation.txt')


###################################################
### chunk number 4: imageHTSAnalysis eval=FALSE
###################################################
## #line 67 "phenoDist.Rnw"
## unames <- setdiff(getUnames(x), getUnames(x, content='empty'))
## segmentWells(x, uname=uname, segmentationPar='conf/segmentationpar.txt')
## extractFeatures(x, uname, 'conf/featurepar.txt')


###################################################
### chunk number 5: library
###################################################
#line 76 "phenoDist.Rnw"
library('phenoDist')


###################################################
### chunk number 6: PDM eval=FALSE
###################################################
## #line 80 "phenoDist.Rnw"
## profiles <- summarizeWells(x, unames, 'conf/featurepar.txt')
## load(system.file('kimorph', 'selectedFtrs.rda', package='phenoDist'))
## pcaPDM <- PDMByWellAvg(profiles, selectedWellFtrs=selectedWellFtrs, transformMethod='PCA',
## distMethod='euclidean', nPCA=30)
## svmAccPDM <- PDMBySvmAccuracy(x, unames, selectedCellFtrs=selectedCellFtrs, cross=5, cost=1,
## gamma=2^-5, kernel='radial')


###################################################
### chunk number 7: loadSvmAccPDM_Pl1
###################################################
#line 91 "phenoDist.Rnw"
load(system.file('kimorph', 'svmAccPDM_Pl1.rda', package='phenoDist'))
dim(svmAccPDM_Pl1)
svmAccPDM_Pl1[1:5,1:5]


###################################################
### chunk number 8: repDistRank
###################################################
#line 101 "phenoDist.Rnw"
ranking <- repDistRank(x, distMatrix=svmAccPDM_Pl1)
summary(ranking)


###################################################
### chunk number 9: distToNeg
###################################################
#line 111 "phenoDist.Rnw"
pheno <- distToNeg(x, distMatrix=svmAccPDM_Pl1, neg='rluc')
df <- data.frame(pheno=pheno,gene=getWellFeatures(x, uname=rownames(svmAccPDM_Pl1),
feature='GeneID'))
df <- df[order(pheno, decreasing=T),]
head(df)


###################################################
### chunk number 10: repCorr
###################################################
#line 124 "phenoDist.Rnw"
repCorr(x, pheno)


###################################################
### chunk number 11: ctlSeparation
###################################################
#line 128 "phenoDist.Rnw"
ctlSeparatn(x, pheno, neg='rluc', pos='ubc', method='robust')


###################################################
### chunk number 12: clustering
###################################################
#line 137 "phenoDist.Rnw"
phenoCluster <- clusterDist(x, distMatrix=svmAccPDM_Pl1, clusterFun='hclust', method='ward')


###################################################
### chunk number 13: enrichment eval=FALSE
###################################################
## #line 143 "phenoDist.Rnw"
## library('GOstats')
## GOEnrich <- enrichAnalysis(x, cl=cutree(phenoCluster, k=5), terms='GO', annotation='org.Hs.eg.db',
## pvalueCutoff=0.01, testDirection='over', ontology='BP', conditional=TRUE)


###################################################
### chunk number 14: sessionInfo
###################################################
#line 153 "phenoDist.Rnw"
toLatex(sessionInfo())


