###################################################
### chunk number 1: setupSmall
###################################################
#line 74 "ontoTools.Rnw"
library(graph)
library(ontoTools)
#library(Rgraphviz)
data(litOnto)
print(litOnto)
print(class(litOnto))


###################################################
### chunk number 2: showrDAG
###################################################
#line 94 "ontoTools.Rnw"
g1 <- new("rootedDAG", DAG=litOnto, root="A")
show(DAG(g1))
root(g1)


###################################################
### chunk number 3: compGraph
###################################################
#line 111 "ontoTools.Rnw"
data(litObj)
com <- new("compoundGraph", grList=list(litOnto,litObj),
         between= list(c("W","E"), c("X", "K"), c("Y","B"),
        c("Z","D"), c("Z","G")))
compRendList<-list(
      list( prenodes="node [fontsize=28 color=orange fontcolor=orange];",
         preedges="edge [color=black];"),
      list( prenodes="node [fontsize=28 color=green fontcolor=green];",
         preedges="edge [color=black];"),
      betweenRend = list( preedges = "edge [color = red]"))

ff <- "demoComp.dot"
toDot(com, ff, compRendList)
cat(readLines(ff),sep="\n")


###################################################
### chunk number 4: makeOnto
###################################################
#line 131 "ontoTools.Rnw"
g1 <- new("rootedDAG", DAG=litOnto, root="A")
o1 <- new("ontology", name="demo", version="0.1",
        rDAG=g1)
show(o1)


###################################################
### chunk number 5: sparseKVmap
###################################################
#line 143 "ontoTools.Rnw"
kvlist <- list(W="E", X="K", Y="B", Z=c("D","G"))
litMap <- otkvList2namedSparse( names(kvlist), LETTERS[1:12], kvlist )
print(litMap)


###################################################
### chunk number 6: makeOOC
###################################################
#line 153 "ontoTools.Rnw"
ooc1 <- makeOOC( o1, litMap )
show(ooc1)
#coverageMat(ooc1)


###################################################
### chunk number 7: DAG2matrix
###################################################
#line 171 "ontoTools.Rnw"
g1 <- new("rootedDAG", DAG=litOnto, root="A")
mg1d <- getMatrix(g1, "child2parent", "dense")
print(mg1d)


###################################################
### chunk number 8: sparsifyMap
###################################################
#line 179 "ontoTools.Rnw"
ng1 <- getMatrix(g1, "child2parent", "sparse")
ng1 <- new("namedSparse", mat=ng1)
dimnames(ng1) <- list(as.character(1:dim(ng1@mat)[1]),
     as.character(1:dim(ng1@mat)[2]))
print(ng1@mat)

print(as.matrix(ng1))


###################################################
### chunk number 9: namedSparse
###################################################
#line 195 "ontoTools.Rnw"
dimnames(ng1) <- list(letters[1:12], LETTERS[1:12])
print(class(ng1))
print(getSlots("namedSparse"))
print(as.matrix(ng1))



###################################################
### chunk number 10: accessMat
###################################################
#line 204 "ontoTools.Rnw"
show(accessMat(o1))


###################################################
### chunk number 11: coverageMat
###################################################
#line 214 "ontoTools.Rnw"
print(coverageMat(ooc1))



###################################################
### chunk number 12: depthStruct
###################################################
#line 222 "ontoTools.Rnw"
print(ontoDepth(g1))
ds1 <- depthStruct(g1)
print(ds1$tag2depth("B"))
print(ds1$depth2tags(3))



###################################################
### chunk number 13: rDAGbuild
###################################################
#line 249 "ontoTools.Rnw"
data(goMFgraph.1.15)
gomfrDAG <- new("rootedDAG", root="GO:0003674", DAG=goMFgraph.1.15)


###################################################
### chunk number 14: ontoBuild
###################################################
#line 254 "ontoTools.Rnw"
GOMFonto <- new("ontology", name="GOMF", version="bioc 1.3.1", rDAG=gomfrDAG)


###################################################
### chunk number 15: smSetup
###################################################
#line 312 "ontoTools.Rnw"
library(ontoTools)
data(litOnto)
g1 <- new("rootedDAG", DAG=litOnto, root="A")


###################################################
### chunk number 16: smOnto
###################################################
#line 319 "ontoTools.Rnw"
o1 <- new("ontology", name="demo", version="0.1",
   rDAG=g1)


###################################################
### chunk number 17: smKVlist
###################################################
#line 326 "ontoTools.Rnw"
kvlist <- list(W="E", X="K", Y="B", Z=c("D", "G"))


###################################################
### chunk number 18: smMap
###################################################
#line 331 "ontoTools.Rnw"
demomap <- otkvList2namedSparse( names(kvlist), LETTERS[1:12],
   kvlist )


###################################################
### chunk number 19: smOOC
###################################################
#line 336 "ontoTools.Rnw"
demoooc <- makeOOC( o1, demomap )


###################################################
### chunk number 20: smOOmap
###################################################
#line 340 "ontoTools.Rnw"
print(OOmap(demoooc))


###################################################
### chunk number 21: smcov
###################################################
#line 344 "ontoTools.Rnw"
cov1 <- coverageMat(demoooc)
print(cov1)


###################################################
### chunk number 22: smUcounts
###################################################
#line 351 "ontoTools.Rnw"
#print(pc <- colSums(coverageMat(demoooc)))
ACC <- accessMat(ontology(demoooc))
acctms <- dimnames(ACC)[[2]]
print(acctms)
MAP <- OOmap(demoooc)
nterms <- function(x) length(nodes(DAG(rDAG(x))))
ontoTerms <- function(x) nodes(DAG(rDAG(x)))
print(ontoTerms)

usageCount.vig <- function (MAP, ACC) 
{
    maptms <- dimnames(MAP)[[2]]
    acctms <- dimnames(ACC)[[2]]
    usages <- rep(0,length(maptms))
    names(usages) <- maptms
    for (i in 1:nrow(MAP)) {
        hits <- maptms[as.matrix.ok(MAP[i, ]) == 1]
        usages[hits] <- usages[hits] + 1
        for (j in 1:length(hits)) {
            anctags <- acctms[as.matrix.ok(ACC[hits[j], ]) == 1]
            usages[anctags] <- usages[anctags] + 1
        }
    }
    usages
}
print(usages <- usageCount.vig(MAP,ACC))
    


###################################################
### chunk number 23: smUev
###################################################
#line 388 "ontoTools.Rnw"
print(N <- max(usages))


###################################################
### chunk number 24: smCprob
###################################################
#line 392 "ontoTools.Rnw"
print(usages/N)


###################################################
### chunk number 25: cprobFunc
###################################################
#line 396 "ontoTools.Rnw"
conceptProbs.vig <- function(ooc) {
 if (is(occ, "OOC")) stop("arg must have class OOC")
 pc <- usageCount.vig(OOmap(ooc), accessMat(ontology(ooc)))
 pc/max(pc, na.rm=TRUE)
}


###################################################
### chunk number 26: subsumFunc
###################################################
#line 406 "ontoTools.Rnw"
subsumers.vig <- function(c1, c2, ont) {
 if (! is(ont, "ontology")) stop("ont must have class ontology")
 tmp <- colSums(accessMat(ont)[c(c1,c2),])
 names(tmp[tmp==2])
}
print(subsumers.vig("I", "K", ontology(demoooc)))


###################################################
### chunk number 27: pmsFunc
###################################################
#line 415 "ontoTools.Rnw"
pms.vig <- function(c1, c2, ooc) {
 if (! is(ooc, "OOC")) stop("arg must have class OOC")
 if (any(!(c(c1,c2) %in% nodes(DAG(rDAG(ontology(ooc))))))) 
     stop("some term not found in ontology DAG nodes")
 S <- subsumers.vig(c1,c2,ontology(ooc))
 pc <- conceptProbs.vig(ooc)
 min(pc[S])
}

print(pms("I", "K", demoooc))


###################################################
### chunk number 28: semsimFunc
###################################################
#line 429 "ontoTools.Rnw"
semsim.vig <- function(c1, c2, ooc) 
 -log(pms.vig(c1,c2,ooc))


###################################################
### chunk number 29: IySetup
###################################################
#line 444 "ontoTools.Rnw"
library(ontoTools)
library(Iyer517)
data(IyerAnnotated)
print(IyerAnnotated[1:3,])


###################################################
### chunk number 30: IyCP
###################################################
#line 452 "ontoTools.Rnw"
data(LL2GOMFcp.1.15)
print(LL2GOMFcp.1.15[1:3])


###################################################
### chunk number 31: MostInfFunc
###################################################
#line 459 "ontoTools.Rnw"
getMostInf <- function (tags,pc=LL2GOMFcp.1.15) 
{
    if (length(tags) == 1) 
        return(tags)
    if (all(is.na(tags))) return(NA)
    tags[pc[tags] == min(pc[tags])][1]
}


###################################################
### chunk number 32: IyMostInf
###################################################
#line 469 "ontoTools.Rnw"
GOmost <- apply(IyerAnnotated[, 5:9], 1, 
  function(x) getMostInf(as.character(x[!is.na(x)])))


###################################################
### chunk number 33: GOMFOOC
###################################################
#line 476 "ontoTools.Rnw"
data(goMFgraph.1.15)
data(LL2GOMFooMap.1.15)
data(goMFamat.1.15)
#
# build the rooted DAG, the ontology, and the OOC objects
#
gomfrDAG <- new("rootedDAG", root="GO:0003674", DAG=goMFgraph.1.15)
GOMFonto <- new("ontology", name="GOMF", version="bioc 1.3.1", rDAG=gomfrDAG)
LLGOMFOOC <- makeOOC(GOMFonto, LL2GOMFooMap.1.15)
#


###################################################
### chunk number 34: IclustTab
###################################################
#line 490 "ontoTools.Rnw"
print(table(IyerAnnotated$Iclust))



###################################################
### chunk number 35: IyMostInfTags
###################################################
#line 497 "ontoTools.Rnw"
getMostInfTags <- function(let) {
grp.GO <- GOmost[ IyerAnnotated$Iclust==let ]
grp.GO[!is.na(grp.GO)]
}

A.GO <- getMostInfTags("A")
B.GO <- getMostInfTags("B")
D.GO <- getMostInfTags("D")
H.GO <- getMostInfTags("H")



###################################################
### chunk number 36: pwiseSim
###################################################
#line 514 "ontoTools.Rnw"
getSim <- function(x,Nchk=30) {
 library(combinat)
 prs <- combn(x,2)
 sim <- rep(NA,ncol(prs))
 for (i in 1:ncol(prs))
   {
   if (i > Nchk) break
   cat(i)
   if (any(!(c(prs[1,i], prs[2,i]) %in% goMFamat.1.15@Dimnames[[1]])))
     sim[i] = NA
   else
     sim[i] <- semsim( prs[1,i], prs[2,i], acc=goMFamat.1.15, pc=LL2GOMFcp.1.15, ooc=LLGOMFOOC )
   }
 sim[1:Nchk]
 }


###################################################
### chunk number 37: calcSims
###################################################
#line 532 "ontoTools.Rnw"
Asim <- getSim(A.GO)
save(Asim,file="Asim.rda")
Bsim <- getSim(B.GO)
save(Bsim,file="Bsim.rda")
Dsim <- getSim(D.GO)
save(Dsim,file="Dsim.rda")
Hsim <- getSim(H.GO)
save(Hsim,file="Hsim.rda")


###################################################
### chunk number 38: boxpSims
###################################################
#line 543 "ontoTools.Rnw"
boxplot(Asim,Bsim,Dsim,Hsim)


