/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.structural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLReasonerBase;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralReasoner
extends OWLReasonerBase {
    private ClassHierarchyInfo classHierarchyInfo = new ClassHierarchyInfo();
    private ObjectPropertyHierarchyInfo objectPropertyHierarchyInfo = new ObjectPropertyHierarchyInfo();
    private DataPropertyHierarchyInfo dataPropertyHierarchyInfo = new DataPropertyHierarchyInfo();
    private static final Version version = new Version(1, 0, 0, 0);
    private boolean interrupted = false;
    private ReasonerProgressMonitor pm;
    private boolean prepared = false;

    public StructuralReasoner(OWLOntology rootOntology, OWLReasonerConfiguration configuration, BufferingMode bufferingMode) {
        super(rootOntology, configuration, bufferingMode);
        this.pm = configuration.getProgressMonitor();
        if (this.pm == null) {
            this.pm = new NullReasonerProgressMonitor();
        }
        this.prepareReasoner();
    }

    @Override
    public String getReasonerName() {
        return "Structural Reasoner";
    }

    @Override
    public FreshEntityPolicy getFreshEntityPolicy() {
        return FreshEntityPolicy.ALLOW;
    }

    @Override
    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return IndividualNodeSetPolicy.BY_NAME;
    }

    @Override
    public Version getReasonerVersion() {
        return version;
    }

    @Override
    protected void handleChanges(Set<OWLAxiom> addAxioms, Set<OWLAxiom> removeAxioms) {
        this.handleChanges(addAxioms, removeAxioms, this.classHierarchyInfo);
        this.handleChanges(addAxioms, removeAxioms, this.objectPropertyHierarchyInfo);
        this.handleChanges(addAxioms, removeAxioms, this.dataPropertyHierarchyInfo);
    }

    private <T extends OWLObject> void handleChanges(Set<OWLAxiom> added, Set<OWLAxiom> removed, HierarchyInfo<T> hierarchyInfo) {
        Set sig = ((HierarchyInfo)hierarchyInfo).getEntitiesInSignature(added);
        sig.addAll(((HierarchyInfo)hierarchyInfo).getEntitiesInSignature(removed));
        hierarchyInfo.processChanges(sig, added, removed);
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    private void ensurePrepared() {
        if (!this.prepared) {
            this.prepareReasoner();
        }
    }

    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.classHierarchyInfo.computeHierarchy();
        this.objectPropertyHierarchyInfo.computeHierarchy();
        this.dataPropertyHierarchyInfo.computeHierarchy();
        this.prepared = true;
    }

    @Override
    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        this.prepareReasoner();
    }

    @Override
    public boolean isPrecomputed(InferenceType inferenceType) {
        return true;
    }

    @Override
    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return CollectionFactory.createSet(InferenceType.CLASS_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY);
    }

    private void throwExceptionIfInterrupted() {
        if (this.interrupted) {
            this.interrupted = false;
            throw new ReasonerInterruptedException();
        }
    }

    @Override
    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        return true;
    }

    @Override
    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return !classExpression.isAnonymous() && !this.getEquivalentClasses(classExpression.asOWLClass()).contains(this.getDataFactory().getOWLNothing());
    }

    @Override
    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        return OWLClassNode.getBottomNode();
    }

    @Override
    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.getRootOntology().containsAxiomIgnoreAnnotations(axiom, true);
    }

    @Override
    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.getRootOntology().containsAxiomIgnoreAnnotations(oWLAxiom, true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return false;
    }

    @Override
    public Node<OWLClass> getTopClassNode() {
        this.ensurePrepared();
        return this.classHierarchyInfo.getEquivalents(this.getDataFactory().getOWLThing());
    }

    @Override
    public Node<OWLClass> getBottomClassNode() {
        this.ensurePrepared();
        return this.classHierarchyInfo.getEquivalents(this.getDataFactory().getOWLNothing());
    }

    @Override
    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            this.ensurePrepared();
            return this.classHierarchyInfo.getNodeHierarchyChildren(ce.asOWLClass(), direct, ns);
        }
        return ns;
    }

    @Override
    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            this.ensurePrepared();
            return this.classHierarchyInfo.getNodeHierarchyParents(ce.asOWLClass(), direct, ns);
        }
        return ns;
    }

    @Override
    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        if (!ce.isAnonymous()) {
            return this.classHierarchyInfo.getEquivalents(ce.asOWLClass());
        }
        return new OWLClassNode();
    }

    @Override
    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) {
        this.ensurePrepared();
        OWLClassNodeSet nodeSet = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(ce.asOWLClass())) {
                    for (OWLClassExpression op : ax.getClassExpressions()) {
                        if (op.isAnonymous()) continue;
                        nodeSet.addNode(this.getEquivalentClasses(op));
                    }
                }
            }
        }
        return nodeSet;
    }

    @Override
    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLTopObjectProperty());
    }

    @Override
    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLBottomObjectProperty());
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getNodeHierarchyChildren(pe, direct, ns);
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getNodeHierarchyParents(pe, direct, ns);
    }

    @Override
    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNode nd = new OWLObjectPropertyNode();
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getEquivalents(pe);
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return new OWLObjectPropertyNodeSet();
    }

    @Override
    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLObjectPropertyExpression inv = pe.getInverseProperty().getSimplified();
        return this.getEquivalentObjectProperties(inv);
    }

    @Override
    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyDomainAxiom axiom : ontology.getObjectPropertyDomainAxioms(pe)) {
                result.addNode(this.getEquivalentClasses(axiom.getDomain()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses(axiom.getDomain(), false).getNodes());
            }
            for (OWLObjectPropertyExpression invPe : this.getInverseObjectProperties(pe).getEntities()) {
                for (OWLObjectPropertyRangeAxiom axiom : ontology.getObjectPropertyRangeAxioms(invPe)) {
                    result.addNode(this.getEquivalentClasses((OWLClassExpression)axiom.getRange()));
                    if (direct) continue;
                    result.addAllNodes(this.getSuperClasses((OWLClassExpression)axiom.getRange(), false).getNodes());
                }
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyRangeAxiom axiom : ontology.getObjectPropertyRangeAxioms(pe)) {
                result.addNode(this.getEquivalentClasses((OWLClassExpression)axiom.getRange()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses((OWLClassExpression)axiom.getRange(), false).getNodes());
            }
            for (OWLObjectPropertyExpression invPe : this.getInverseObjectProperties(pe).getEntities()) {
                for (OWLObjectPropertyDomainAxiom axiom : ontology.getObjectPropertyDomainAxioms(invPe)) {
                    result.addNode(this.getEquivalentClasses(axiom.getDomain()));
                    if (direct) continue;
                    result.addAllNodes(this.getSuperClasses(axiom.getDomain(), false).getNodes());
                }
            }
        }
        return result;
    }

    @Override
    public Node<OWLDataProperty> getTopDataPropertyNode() {
        this.ensurePrepared();
        return this.dataPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLTopDataProperty());
    }

    @Override
    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        this.ensurePrepared();
        return this.dataPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLBottomDataProperty());
    }

    @Override
    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        return this.dataPropertyHierarchyInfo.getNodeHierarchyChildren(pe, direct, ns);
    }

    @Override
    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        return this.dataPropertyHierarchyInfo.getNodeHierarchyParents(pe, direct, ns);
    }

    @Override
    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        return this.dataPropertyHierarchyInfo.getEquivalents(pe);
    }

    @Override
    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLDataPropertyNodeSet result = new OWLDataPropertyNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLDisjointDataPropertiesAxiom axiom : ontology.getDisjointDataPropertiesAxioms(pe.asOWLDataProperty())) {
                for (OWLDataPropertyExpression dpe : axiom.getPropertiesMinus(pe)) {
                    if (dpe.isAnonymous()) continue;
                    result.addNode(this.dataPropertyHierarchyInfo.getEquivalents(dpe.asOWLDataProperty()));
                    result.addAllNodes(this.getSubDataProperties(dpe.asOWLDataProperty(), false).getNodes());
                }
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLDataPropertyDomainAxiom axiom : ontology.getDataPropertyDomainAxioms(pe)) {
                result.addNode(this.getEquivalentClasses(axiom.getDomain()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses(axiom.getDomain(), false).getNodes());
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLClassAssertionAxiom axiom : ontology.getClassAssertionAxioms(ind)) {
                OWLClassExpression ce = axiom.getClassExpression();
                if (ce.isAnonymous()) continue;
                result.addNode(this.classHierarchyInfo.getEquivalents(ce.asOWLClass()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses(ce, false).getNodes());
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLNamedIndividualNodeSet result = new OWLNamedIndividualNodeSet();
        if (!ce.isAnonymous()) {
            OWLClass cls = ce.asOWLClass();
            HashSet<OWLClass> clses = new HashSet<OWLClass>();
            clses.add(cls);
            if (!direct) {
                clses.addAll(this.getSubClasses(cls, false).getFlattened());
            }
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLClass curCls : clses) {
                    for (OWLClassAssertionAxiom axiom : ontology.getClassAssertionAxioms(curCls)) {
                        OWLIndividual individual = axiom.getIndividual();
                        if (individual.isAnonymous()) continue;
                        if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                            result.addNode(this.getSameIndividuals(individual.asOWLNamedIndividual()));
                            continue;
                        }
                        result.addNode(new OWLNamedIndividualNode(individual.asOWLNamedIndividual()));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLNamedIndividualNodeSet result = new OWLNamedIndividualNodeSet();
        Node<OWLObjectPropertyExpression> inverses = this.getInverseObjectProperties(pe);
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyAssertionAxiom axiom : ontology.getObjectPropertyAssertionAxioms(ind)) {
                OWLObjectPropertyExpression invPe;
                if (!((OWLIndividual)axiom.getObject()).isAnonymous() && ((OWLObjectPropertyExpression)axiom.getProperty()).getSimplified().equals(pe.getSimplified())) {
                    if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                        result.addNode(this.getSameIndividuals(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                    } else {
                        result.addNode(new OWLNamedIndividualNode(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                    }
                }
                if (!((OWLIndividual)axiom.getObject()).equals(ind) || axiom.getSubject().isAnonymous() || (invPe = ((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty().getSimplified()).isAnonymous() || !inverses.contains(invPe.asOWLObjectProperty())) continue;
                if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                    result.addNode(this.getSameIndividuals(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                    continue;
                }
                result.addNode(new OWLNamedIndividualNode(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
            }
        }
        return result;
    }

    @Override
    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        HashSet<OWLLiteral> literals = new HashSet<OWLLiteral>();
        Set<OWLDataProperty> superProperties = this.getSuperDataProperties(pe, false).getFlattened();
        superProperties.addAll(this.getEquivalentDataProperties(pe).getEntities());
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLDataPropertyAssertionAxiom axiom : ontology.getDataPropertyAssertionAxioms(ind)) {
                if (!superProperties.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty())) continue;
                literals.add((OWLLiteral)axiom.getObject());
            }
        }
        return literals;
    }

    @Override
    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
        HashSet<OWLSameIndividualAxiom> processed = new HashSet<OWLSameIndividualAxiom>();
        ArrayList<OWLNamedIndividual> stack = new ArrayList<OWLNamedIndividual>();
        stack.add(ind);
        while (!stack.isEmpty()) {
            OWLNamedIndividual currentInd = (OWLNamedIndividual)stack.remove(0);
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLSameIndividualAxiom axiom : ontology.getSameIndividualAxioms(currentInd)) {
                    if (processed.contains(axiom)) continue;
                    processed.add(axiom);
                    for (OWLIndividual i : axiom.getIndividuals()) {
                        OWLNamedIndividual namedInd;
                        if (i.isAnonymous() || inds.contains(namedInd = i.asOWLNamedIndividual())) continue;
                        inds.add(namedInd);
                        stack.add(namedInd);
                    }
                }
            }
        }
        return new OWLNamedIndividualNode((Set<OWLNamedIndividual>)inds);
    }

    @Override
    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return new OWLNamedIndividualNodeSet();
    }

    protected OWLDataFactory getDataFactory() {
        return this.getRootOntology().getOWLOntologyManager().getOWLDataFactory();
    }

    public void dumpClassHierarchy(boolean showBottomNode) {
        this.dumpClassHierarchy(OWLClassNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpClassHierarchy(Node<OWLClass> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        this.printIndent(level);
        OWLClass representative = cls.getRepresentativeElement();
        System.out.println(this.getEquivalentClasses(representative));
        for (Node node : this.getSubClasses(representative, true)) {
            this.dumpClassHierarchy(node, level + 1, showBottomNode);
        }
    }

    public void dumpObjectPropertyHierarchy(boolean showBottomNode) {
        this.dumpObjectPropertyHierarchy(OWLObjectPropertyNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpObjectPropertyHierarchy(Node<OWLObjectPropertyExpression> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        this.printIndent(level);
        OWLObjectPropertyExpression representative = cls.getRepresentativeElement();
        System.out.println(this.getEquivalentObjectProperties(representative));
        for (Node node : this.getSubObjectProperties(representative, true)) {
            this.dumpObjectPropertyHierarchy(node, level + 1, showBottomNode);
        }
    }

    public void dumpDataPropertyHierarchy(boolean showBottomNode) {
        this.dumpDataPropertyHierarchy(OWLDataPropertyNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpDataPropertyHierarchy(Node<OWLDataProperty> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        this.printIndent(level);
        OWLDataProperty representative = cls.getRepresentativeElement();
        System.out.println(this.getEquivalentDataProperties(representative));
        for (Node node : this.getSubDataProperties(representative, true)) {
            this.dumpDataPropertyHierarchy(node, level + 1, showBottomNode);
        }
    }

    private void printIndent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("    ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RawDataPropertyHierarchyProvider
    implements RawHierarchyProvider<OWLDataProperty> {
        private RawDataPropertyHierarchyProvider() {
        }

        @Override
        public Collection<OWLDataProperty> getParents(OWLDataProperty child) {
            HashSet<OWLDataProperty> properties = new HashSet<OWLDataProperty>();
            for (OWLDataPropertyExpression prop : child.getSuperProperties(StructuralReasoner.this.getRootOntology().getImportsClosure())) {
                properties.add(prop.asOWLDataProperty());
            }
            return properties;
        }

        @Override
        public Collection<OWLDataProperty> getChildren(OWLDataProperty parent) {
            HashSet<OWLDataProperty> properties = new HashSet<OWLDataProperty>();
            for (OWLDataPropertyExpression prop : parent.getSubProperties(StructuralReasoner.this.getRootOntology().getImportsClosure())) {
                properties.add(prop.asOWLDataProperty());
            }
            return properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RawObjectPropertyHierarchyProvider
    implements RawHierarchyProvider<OWLObjectPropertyExpression> {
        private OWLObjectPropertyManager propertyManager;
        private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> sub2Super;
        private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> super2Sub;

        private RawObjectPropertyHierarchyProvider() {
            this.rebuild();
        }

        public void rebuild() {
            this.propertyManager = new OWLObjectPropertyManager(StructuralReasoner.this.getRootOntology().getOWLOntologyManager(), StructuralReasoner.this.getRootOntology());
            this.sub2Super = this.propertyManager.getPropertyHierarchy();
            this.super2Sub = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
            for (OWLObjectPropertyExpression sub : this.sub2Super.keySet()) {
                for (OWLObjectPropertyExpression superProp : this.sub2Super.get(sub)) {
                    Set<OWLObjectPropertyExpression> subs = this.super2Sub.get(superProp);
                    if (subs == null) {
                        subs = new HashSet<OWLObjectPropertyExpression>();
                        this.super2Sub.put(superProp, subs);
                    }
                    subs.add(sub);
                }
            }
        }

        @Override
        public Collection<OWLObjectPropertyExpression> getParents(OWLObjectPropertyExpression child) {
            if (child.isBottomEntity()) {
                return Collections.emptySet();
            }
            Set<OWLObjectPropertyExpression> propertyExpressions = this.sub2Super.get(child);
            if (propertyExpressions == null) {
                return Collections.emptySet();
            }
            return new HashSet<OWLObjectPropertyExpression>(propertyExpressions);
        }

        @Override
        public Collection<OWLObjectPropertyExpression> getChildren(OWLObjectPropertyExpression parent) {
            if (parent.isTopEntity()) {
                return Collections.emptySet();
            }
            Set<OWLObjectPropertyExpression> propertyExpressions = this.super2Sub.get(parent);
            if (propertyExpressions == null) {
                return Collections.emptySet();
            }
            return new HashSet<OWLObjectPropertyExpression>(propertyExpressions);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RawClassHierarchyProvider
    implements RawHierarchyProvider<OWLClass> {
        private RawClassHierarchyProvider() {
        }

        @Override
        public Collection<OWLClass> getParents(OWLClass child) {
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            for (OWLOntology ont : StructuralReasoner.this.getRootOntology().getImportsClosure()) {
                for (OWLSubClassOfAxiom oWLSubClassOfAxiom : ont.getSubClassAxiomsForSubClass(child)) {
                    OWLClassExpression superCls = oWLSubClassOfAxiom.getSuperClass();
                    if (!superCls.isAnonymous()) {
                        result.add(superCls.asOWLClass());
                        continue;
                    }
                    if (!(superCls instanceof OWLObjectIntersectionOf)) continue;
                    OWLObjectIntersectionOf intersectionOf = (OWLObjectIntersectionOf)superCls;
                    for (OWLClassExpression conjunct : intersectionOf.asConjunctSet()) {
                        if (conjunct.isAnonymous()) continue;
                        result.add(conjunct.asOWLClass());
                    }
                }
                for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : ont.getEquivalentClassesAxioms(child)) {
                    for (OWLClassExpression ce : oWLEquivalentClassesAxiom.getClassExpressionsMinus(child)) {
                        if (!ce.isAnonymous()) {
                            result.add(ce.asOWLClass());
                            continue;
                        }
                        if (!(ce instanceof OWLObjectIntersectionOf)) continue;
                        OWLObjectIntersectionOf intersectionOf = (OWLObjectIntersectionOf)ce;
                        for (OWLClassExpression conjunct : intersectionOf.asConjunctSet()) {
                            if (conjunct.isAnonymous()) continue;
                            result.add(conjunct.asOWLClass());
                        }
                    }
                }
            }
            return result;
        }

        @Override
        public Collection<OWLClass> getChildren(OWLClass parent) {
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            for (OWLOntology ont : StructuralReasoner.this.getRootOntology().getImportsClosure()) {
                for (OWLAxiom ax : ont.getReferencingAxioms(parent)) {
                    if (ax instanceof OWLSubClassOfAxiom) {
                        Set<OWLClassExpression> conjuncts;
                        OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)ax;
                        if (sca.getSubClass().isAnonymous() || !(conjuncts = sca.getSuperClass().asConjunctSet()).contains(parent)) continue;
                        result.add(sca.getSubClass().asOWLClass());
                        continue;
                    }
                    if (!(ax instanceof OWLEquivalentClassesAxiom)) continue;
                    OWLEquivalentClassesAxiom eca = (OWLEquivalentClassesAxiom)ax;
                    for (OWLClassExpression ce : eca.getClassExpressions()) {
                        if (!ce.containsConjunct(parent)) continue;
                        for (OWLClassExpression sub : eca.getClassExpressions()) {
                            if (sub.isAnonymous() || sub.equals(ce)) continue;
                            result.add(sub.asOWLClass());
                        }
                    }
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface RawHierarchyProvider<T> {
        public Collection<T> getParents(T var1);

        public Collection<T> getChildren(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertyHierarchyInfo
    extends HierarchyInfo<OWLDataProperty> {
        private DataPropertyHierarchyInfo() {
            super(StructuralReasoner.this, "data property", (OWLObject)StructuralReasoner.this.getDataFactory().getOWLTopDataProperty(), (OWLObject)StructuralReasoner.this.getDataFactory().getOWLBottomDataProperty(), (RawHierarchyProvider)new RawDataPropertyHierarchyProvider());
        }

        @Override
        protected Set<OWLDataProperty> getEntitiesInSignature(OWLAxiom ax) {
            return ax.getDataPropertiesInSignature();
        }

        @Override
        protected Set<OWLDataProperty> getEntities(OWLOntology ont) {
            return ont.getDataPropertiesInSignature();
        }

        @Override
        protected DefaultNode<OWLDataProperty> createNode(Set<OWLDataProperty> cycle) {
            return new OWLDataPropertyNode(cycle);
        }

        @Override
        protected DefaultNode<OWLDataProperty> createNode() {
            return new OWLDataPropertyNode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyHierarchyInfo
    extends HierarchyInfo<OWLObjectPropertyExpression> {
        private ObjectPropertyHierarchyInfo() {
            super(StructuralReasoner.this, "object property", (OWLObject)StructuralReasoner.this.getDataFactory().getOWLTopObjectProperty(), (OWLObject)StructuralReasoner.this.getDataFactory().getOWLBottomObjectProperty(), (RawHierarchyProvider)new RawObjectPropertyHierarchyProvider());
        }

        @Override
        protected Set<OWLObjectPropertyExpression> getEntitiesInSignature(OWLAxiom ax) {
            HashSet<OWLObjectPropertyExpression> result = new HashSet<OWLObjectPropertyExpression>();
            for (OWLObjectProperty property : ax.getObjectPropertiesInSignature()) {
                result.add(property);
                result.add(property.getInverseProperty());
            }
            return result;
        }

        @Override
        protected Set<OWLObjectPropertyExpression> getEntities(OWLOntology ont) {
            HashSet<OWLObjectPropertyExpression> result = new HashSet<OWLObjectPropertyExpression>();
            for (OWLObjectProperty property : ont.getObjectPropertiesInSignature()) {
                result.add(property);
                result.add(property.getInverseProperty());
            }
            return result;
        }

        @Override
        protected DefaultNode<OWLObjectPropertyExpression> createNode(Set<OWLObjectPropertyExpression> cycle) {
            return new OWLObjectPropertyNode(cycle);
        }

        @Override
        protected DefaultNode<OWLObjectPropertyExpression> createNode() {
            return new OWLObjectPropertyNode();
        }

        @Override
        public void processChanges(Set<OWLObjectPropertyExpression> signature, Set<OWLAxiom> added, Set<OWLAxiom> removed) {
            boolean rebuild = false;
            for (OWLAxiom ax : added) {
                if (!(ax instanceof OWLObjectPropertyAxiom)) continue;
                rebuild = true;
                break;
            }
            if (!rebuild) {
                for (OWLAxiom ax : removed) {
                    if (!(ax instanceof OWLObjectPropertyAxiom)) continue;
                    rebuild = true;
                    break;
                }
            }
            if (rebuild) {
                ((RawObjectPropertyHierarchyProvider)this.getRawParentChildProvider()).rebuild();
            }
            super.processChanges(signature, added, removed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassHierarchyInfo
    extends HierarchyInfo<OWLClass> {
        private ClassHierarchyInfo() {
            super(StructuralReasoner.this, "class", (OWLObject)StructuralReasoner.this.getDataFactory().getOWLThing(), (OWLObject)StructuralReasoner.this.getDataFactory().getOWLNothing(), (RawHierarchyProvider)new RawClassHierarchyProvider());
        }

        @Override
        protected Set<OWLClass> getEntitiesInSignature(OWLAxiom ax) {
            return ax.getClassesInSignature();
        }

        @Override
        protected DefaultNode<OWLClass> createNode(Set<OWLClass> cycle) {
            return new OWLClassNode(cycle);
        }

        @Override
        protected Set<OWLClass> getEntities(OWLOntology ont) {
            return ont.getClassesInSignature();
        }

        @Override
        protected DefaultNode<OWLClass> createNode() {
            return new OWLClassNode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeCache<T extends OWLObject> {
        private HierarchyInfo<T> hierarchyInfo;
        private Node<T> topNode;
        private Node<T> bottomNode;
        private Map<T, Node<T>> map = new HashMap<T, Node<T>>();

        protected NodeCache(HierarchyInfo<T> hierarchyInfo) {
            this.hierarchyInfo = hierarchyInfo;
            this.clearTopNode();
            this.clearBottomNode();
        }

        public void addNode(Node<T> node) {
            for (OWLObject element : node.getEntities()) {
                this.map.put(element, node);
                if (element.isTopEntity()) {
                    this.topNode = node;
                    continue;
                }
                if (!element.isBottomEntity()) continue;
                this.bottomNode = node;
            }
        }

        public Set<Node<T>> getNodes(Set<T> elements) {
            HashSet<Node<T>> result = new HashSet<Node<T>>();
            for (OWLObject element : elements) {
                result.add(this.getNode(element));
            }
            return result;
        }

        public Set<T> getTopEntities() {
            return this.topNode.getEntities();
        }

        public Set<T> getBottomEntities() {
            return this.bottomNode.getEntities();
        }

        public Node<T> getNode(T containing) {
            Node<T> parentNode = this.map.get(containing);
            if (parentNode != null) {
                return parentNode;
            }
            return this.hierarchyInfo.createNode(Collections.singleton(containing));
        }

        public void addNode(Set<T> elements) {
            this.addNode(this.hierarchyInfo.createNode(elements));
        }

        public Node<T> getTopNode() {
            return this.topNode;
        }

        public Node<T> getBottomNode() {
            return this.bottomNode;
        }

        public void setTopNode(Node<T> topNode) {
            this.topNode = topNode;
        }

        public void setBottomNode(Node<T> bottomNode) {
            this.bottomNode = bottomNode;
        }

        public void clearTopNode() {
            this.removeNode(((HierarchyInfo)this.hierarchyInfo).topEntity);
            this.topNode = this.hierarchyInfo.createNode(Collections.singleton(((HierarchyInfo)this.hierarchyInfo).topEntity));
            this.addNode(this.topNode);
        }

        public void clearBottomNode() {
            this.removeNode(((HierarchyInfo)this.hierarchyInfo).bottomEntity);
            this.bottomNode = this.hierarchyInfo.createNode(Collections.singleton(((HierarchyInfo)this.hierarchyInfo).bottomEntity));
            this.addNode(this.bottomNode);
        }

        public void clearNodes(Set<T> containing) {
            for (OWLObject entity : containing) {
                this.removeNode(entity);
            }
        }

        public void clear() {
            this.map.clear();
            this.clearTopNode();
            this.clearBottomNode();
        }

        public void removeNode(T containing) {
            Node<T> node = this.map.remove(containing);
            if (node != null) {
                for (OWLObject object : node.getEntities()) {
                    this.map.remove(object);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class HierarchyInfo<T extends OWLObject> {
        private RawHierarchyProvider<T> rawParentChildProvider;
        private T topEntity;
        private T bottomEntity;
        private Set<T> directChildrenOfTopNode = new HashSet<T>();
        private Set<T> directParentsOfBottomNode = new HashSet<T>();
        private NodeCache<T> nodeCache;
        private String name;
        private int classificationSize;
        final /* synthetic */ StructuralReasoner this$0;

        public HierarchyInfo(String name, T topEntity, T bottomEntity, RawHierarchyProvider<T> rawParentChildProvider) {
            this.this$0 = var1_1;
            this.topEntity = topEntity;
            this.bottomEntity = bottomEntity;
            this.nodeCache = new NodeCache(this);
            this.rawParentChildProvider = rawParentChildProvider;
            this.name = name;
        }

        public RawHierarchyProvider<T> getRawParentChildProvider() {
            return this.rawParentChildProvider;
        }

        protected abstract Set<T> getEntities(OWLOntology var1);

        protected abstract DefaultNode<T> createNode(Set<T> var1);

        protected abstract DefaultNode<T> createNode();

        protected abstract Set<? extends T> getEntitiesInSignature(OWLAxiom var1);

        private Set<T> getEntitiesInSignature(Set<OWLAxiom> axioms) {
            HashSet<T> result = new HashSet<T>();
            for (OWLAxiom ax : axioms) {
                result.addAll(this.getEntitiesInSignature(ax));
            }
            return result;
        }

        public void computeHierarchy() {
            this.this$0.pm.reasonerTaskStarted("Computing " + this.name + " hierarchy");
            this.this$0.pm.reasonerTaskBusy();
            this.nodeCache.clear();
            HashMap cache = new HashMap();
            HashSet<T> entities = new HashSet<T>();
            for (OWLOntology ont : this.this$0.getRootOntology().getImportsClosure()) {
                entities.addAll(this.getEntities(ont));
            }
            this.classificationSize = entities.size();
            this.this$0.pm.reasonerTaskProgressChanged(0, this.classificationSize);
            this.updateForSignature(entities, cache);
            this.this$0.pm.reasonerTaskStopped();
        }

        private void updateForSignature(Set<T> signature, Map<T, Collection<T>> cache) {
            HashSet<Set<T>> cyclesResult = new HashSet<Set<T>>();
            HashSet processed = new HashSet();
            this.nodeCache.clearTopNode();
            this.nodeCache.clearBottomNode();
            this.nodeCache.clearNodes(signature);
            this.directChildrenOfTopNode.removeAll(signature);
            HashSet equivTopOrChildrenOfTop = new HashSet();
            HashSet equivBottomOrParentsOfBottom = new HashSet();
            for (OWLObject oWLObject : signature) {
                if (processed.contains(oWLObject)) continue;
                this.this$0.pm.reasonerTaskProgressChanged(processed.size(), signature.size());
                this.tarjan(oWLObject, 0, new Stack(), new HashMap(), new HashMap(), cyclesResult, processed, new HashSet(), cache, equivTopOrChildrenOfTop, equivBottomOrParentsOfBottom);
                this.this$0.throwExceptionIfInterrupted();
            }
            for (Set set : cyclesResult) {
                this.nodeCache.addNode(set);
            }
            this.directChildrenOfTopNode.addAll(equivTopOrChildrenOfTop);
            this.directChildrenOfTopNode.removeAll(this.nodeCache.getTopNode().getEntities());
            this.directParentsOfBottomNode.addAll(equivBottomOrParentsOfBottom);
            this.directParentsOfBottomNode.removeAll(this.nodeCache.getBottomNode().getEntities());
            for (Set set : cyclesResult) {
                if (set.contains(this.topEntity) || set.contains(this.bottomEntity)) continue;
                boolean childOfTop = true;
                for (OWLObject element : set) {
                    Collection<OWLObject> parents = this.rawParentChildProvider.getParents(element);
                    parents.removeAll(set);
                    parents.removeAll(this.nodeCache.getTopNode().getEntities());
                    if (parents.isEmpty()) continue;
                    childOfTop = false;
                    break;
                }
                if (childOfTop) {
                    this.directChildrenOfTopNode.addAll(set);
                }
                boolean parentOfBottom = true;
                for (OWLObject element : set) {
                    Collection<OWLObject> children = this.rawParentChildProvider.getChildren(element);
                    children.removeAll(set);
                    children.removeAll(this.nodeCache.getBottomNode().getEntities());
                    if (children.isEmpty()) continue;
                    parentOfBottom = false;
                    break;
                }
                if (!parentOfBottom) continue;
                this.directParentsOfBottomNode.addAll(set);
            }
        }

        public void processChanges(Set<T> signature, Set<OWLAxiom> added, Set<OWLAxiom> removed) {
            this.updateForSignature(signature, null);
        }

        public void tarjan(T entity, int index, Stack<T> stack, Map<T, Integer> indexMap, Map<T, Integer> lowlinkMap, Set<Set<T>> result, Set<T> processed, Set<T> stackEntities, Map<T, Collection<T>> cache, Set<T> childrenOfTop, Set<T> parentsOfBottom) {
            Collection<T> rawChildren;
            this.this$0.throwExceptionIfInterrupted();
            if (processed.add(entity) && ((rawChildren = this.rawParentChildProvider.getChildren(entity)).isEmpty() || rawChildren.contains(this.bottomEntity))) {
                parentsOfBottom.add(entity);
            }
            this.this$0.pm.reasonerTaskProgressChanged(processed.size(), this.classificationSize);
            indexMap.put(entity, index);
            lowlinkMap.put(entity, index);
            ++index;
            stack.push(entity);
            stackEntities.add(entity);
            Collection<T> rawParents = null;
            if (cache != null) {
                rawParents = cache.get(entity);
                if (rawParents == null) {
                    rawParents = this.rawParentChildProvider.getParents(entity);
                    if (rawParents.isEmpty() || rawParents.contains(this.topEntity)) {
                        childrenOfTop.add(entity);
                    }
                    cache.put(entity, rawParents);
                }
            } else {
                rawParents = this.rawParentChildProvider.getParents(entity);
                if (rawParents.isEmpty() || rawParents.contains(this.topEntity)) {
                    childrenOfTop.add(entity);
                }
            }
            for (OWLObject superEntity : rawParents) {
                if (!indexMap.containsKey(superEntity)) {
                    this.tarjan(superEntity, index, stack, indexMap, lowlinkMap, result, processed, stackEntities, cache, childrenOfTop, parentsOfBottom);
                    lowlinkMap.put(entity, Math.min(lowlinkMap.get(entity), lowlinkMap.get(superEntity)));
                    continue;
                }
                if (!stackEntities.contains(superEntity)) continue;
                lowlinkMap.put(entity, Math.min(lowlinkMap.get(entity), indexMap.get(superEntity)));
            }
            if (lowlinkMap.get(entity).equals(indexMap.get(entity))) {
                OWLObject clsPrime;
                HashSet<OWLObject> scc = new HashSet<OWLObject>();
                do {
                    clsPrime = (OWLObject)stack.pop();
                    stackEntities.remove(clsPrime);
                    scc.add(clsPrime);
                } while (!clsPrime.equals(entity));
                if (scc.size() > 1) {
                    result.add(scc);
                }
            }
        }

        public NodeSet<T> getNodeHierarchyChildren(T parent, boolean direct, DefaultNodeSet<T> ns) {
            Node<T> node = this.nodeCache.getNode(parent);
            if (node.isBottomNode()) {
                return ns;
            }
            HashSet<OWLObject> directChildren = new HashSet<OWLObject>();
            for (OWLObject oWLObject : node) {
                directChildren.addAll(this.rawParentChildProvider.getChildren(oWLObject));
                if (!this.directParentsOfBottomNode.contains(oWLObject)) continue;
                ns.addNode(this.nodeCache.getBottomNode());
            }
            directChildren.removeAll(node.getEntities());
            if (node.isTopNode()) {
                directChildren.addAll(this.directChildrenOfTopNode);
            }
            for (Node node2 : this.nodeCache.getNodes(directChildren)) {
                ns.addNode(node2);
            }
            if (!direct) {
                for (OWLObject oWLObject : directChildren) {
                    this.getNodeHierarchyChildren(oWLObject, direct, ns);
                }
            }
            return ns;
        }

        public NodeSet<T> getNodeHierarchyParents(T child, boolean direct, DefaultNodeSet<T> ns) {
            Node<T> node = this.nodeCache.getNode(child);
            if (node.isTopNode()) {
                return ns;
            }
            HashSet<OWLObject> directParents = new HashSet<OWLObject>();
            for (OWLObject oWLObject : node) {
                directParents.addAll(this.rawParentChildProvider.getParents(oWLObject));
                if (!this.directChildrenOfTopNode.contains(oWLObject)) continue;
                ns.addNode(this.nodeCache.getTopNode());
            }
            directParents.removeAll(node.getEntities());
            if (node.isBottomNode()) {
                directParents.addAll(this.directParentsOfBottomNode);
            }
            for (Node node2 : this.nodeCache.getNodes(directParents)) {
                ns.addNode(node2);
            }
            if (!direct) {
                for (OWLObject oWLObject : directParents) {
                    this.getNodeHierarchyParents(oWLObject, direct, ns);
                }
            }
            return ns;
        }

        public Node<T> getEquivalents(T element) {
            return this.nodeCache.getNode(element);
        }
    }
}

