/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPPropertyDisjointWithHandler
extends TriplePredicateHandler {
    public TPPropertyDisjointWithHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
    }

    public boolean canHandle(IRI subject, IRI predicate, IRI object) {
        this.inferTypes(subject, object);
        return super.canHandle(subject, predicate, object) && (this.getConsumer().isObjectProperty(subject) && this.getConsumer().isObjectProperty(object) || this.getConsumer().isDataProperty(subject) && this.getConsumer().isDataProperty(object));
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isDataProperty(subject) && this.getConsumer().isDataProperty(object)) {
            this.addAxiom(this.getDataFactory().getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet(this.translateDataProperty(subject), this.translateDataProperty(object)), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
        if (this.getConsumer().isObjectProperty(subject) && this.getConsumer().isObjectProperty(object)) {
            this.addAxiom(this.getDataFactory().getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet(this.translateObjectProperty(subject), this.translateObjectProperty(object)), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        this.inferTypes(subject, object);
        return false;
    }
}

