###################################################
### chunk number 1: 
###################################################
#line 65 "mBPCR.Rnw"
library(mBPCR)


###################################################
### chunk number 2: 
###################################################
#line 72 "mBPCR.Rnw"
data(rec10k)


###################################################
### chunk number 3: 
###################################################
#line 83 "mBPCR.Rnw"
maxProbeNumber <- 1000


###################################################
### chunk number 4: 
###################################################
#line 87 "mBPCR.Rnw"
A <- array(1, dim=(maxProbeNumber+1)*(maxProbeNumber+2)/2)


###################################################
### chunk number 5: 
###################################################
#line 95 "mBPCR.Rnw"
remove(A)


###################################################
### chunk number 6: 
###################################################
#line 105 "mBPCR.Rnw"
results <- estProfileWithMBPCR(rec10k$SNPname, rec10k$Chromosome, rec10k$PhysicalPosition, rec10k$log2ratio, chrToBeAnalyzed=c(3,5), maxProbeNumber=1000)


###################################################
### chunk number 7: 
###################################################
#line 116 "mBPCR.Rnw"
writeEstProfile(path='', sampleName='rec10k',rec10k$SNPname, rec10k$Chromosome, rec10k$PhysicalPosition, rec10k$log2ratio, chrToBeWritten=c(3,5), results$estPC, results$estBoundaries)


###################################################
### chunk number 8: 
###################################################
#line 120 "mBPCR.Rnw"
library(xtable)
temp <- writeEstProfile(path=NULL, sampleName='rec10k',rec10k$SNPname,rec10k$Chromosome,  rec10k$PhysicalPosition, rec10k$log2ratio,chrToBeWritten=c(3,5), results$estPC, results$estBoundaries) 


###################################################
### chunk number 9: genTable1
###################################################
#line 125 "mBPCR.Rnw"
xx <- xtable(head(temp$mBPCRestimate))
label(xx) <- "tab_mBPCR"
caption(xx) <- "Example of table containing the profile estimated with mBPCR."
align(xx) <- c("|c|","|c|","c|","c|","c|","c|")
print(xx,latex.environments=c("center","small"),include.rownames=FALSE)


###################################################
### chunk number 10: genTable2
###################################################
#line 135 "mBPCR.Rnw"
xx <- xtable(head(temp$mBPCRbreakpoints))
label(xx) <- "tab_bounds"
caption(xx) <- "Example of table containing a summary of the breakpoints estimated with mBPCR."
align(xx) <- c("|c|","|c|","c|","c|","c|","c|","c|","c|")
print(xx,latex.environments=c("center","small"),include.rownames=FALSE)


###################################################
### chunk number 11: 
###################################################
#line 150 "mBPCR.Rnw"
results <- estProfileWithMBPCR(rec10k$SNPname, rec10k$Chromosome, rec10k$PhysicalPosition, rec10k$log2ratio, chrToBeAnalyzed=3, regr='BRC', maxProbeNumber=1000)


###################################################
### chunk number 12: 
###################################################
#line 158 "mBPCR.Rnw"
plotEstProfile(sampleName='rec10k', rec10k$Chromosome, rec10k$PhysicalPosition, rec10k$log2ratio, chrToBePlotted=3, results$estPC, maxProbeNumber=2000, regrCurve=results$regrCurve, regr='BRC')


###################################################
### chunk number 13:  eval=FALSE
###################################################
## #line 173 "mBPCR.Rnw"
## data(jekoChr11Array250Knsp)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## #line 177 "mBPCR.Rnw"
## maxProbeNumber <- 9000


###################################################
### chunk number 15:  eval=FALSE
###################################################
## #line 181 "mBPCR.Rnw"
## A <- array(1, dim=(maxProbeNumber+1)*(maxProbeNumber+2)/2)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## #line 186 "mBPCR.Rnw"
## remove(A)


###################################################
### chunk number 17:  eval=FALSE
###################################################
## #line 190 "mBPCR.Rnw"
## results <- estProfileWithMBPCR(jekoChr11Array250Knsp$SNPname, jekoChr11Array250Knsp$Chromosome, jekoChr11Array250Knsp$PhysicalPosition, jekoChr11Array250Knsp$log2ratio, chrToBeAnalyzed=11, maxProbeNumber=9000, rhoSquare=0.0479, nu=-3.012772e-10, sigmaSquare=0.0699)


###################################################
### chunk number 18:  eval=FALSE
###################################################
## #line 194 "mBPCR.Rnw"
## plotEstProfile(sampleName='jeko250Knsp', jekoChr11Array250Knsp$Chromosome, jekoChr11Array250Knsp$PhysicalPosition, jekoChr11Array250Knsp$log2ratio, chrToBePlotted=11, results$estPC, maxProbeNumber=9000)


###################################################
### chunk number 19: 
###################################################
#line 205 "mBPCR.Rnw"
data(rec10k)


###################################################
### chunk number 20: 
###################################################
#line 209 "mBPCR.Rnw"
estGlobParam(rec10k$log2ratio)


###################################################
### chunk number 21: 
###################################################
#line 223 "mBPCR.Rnw"
data(jekoChr11Array250Knsp)


###################################################
### chunk number 22: 
###################################################
#line 230 "mBPCR.Rnw"
y <- jekoChr11Array250Knsp$log2ratio[10600:11200]


###################################################
### chunk number 23: 
###################################################
#line 234 "mBPCR.Rnw"
p <- jekoChr11Array250Knsp$PhysicalPosition[10600:11200]


###################################################
### chunk number 24: 
###################################################
#line 242 "mBPCR.Rnw"
results <- computeMBPCR(y, nu=-3.012772e-10, rhoSquare=0.0479, sigmaSquare=0.0699, regr='BRC')


###################################################
### chunk number 25: 
###################################################
#line 249 "mBPCR.Rnw"
plot(p,y)
points(p, results$estPC, type='l', col='red')
points(p, results$regrCurve, type='l', col='green')
legend(x='bottomleft', legend=c('mBPCR', 'BRC with K_2'), lty=c(1, 1), col=c(4, 2))


###################################################
### chunk number 26: 
###################################################
#line 294 "mBPCR.Rnw"
path <- system.file("extdata", "rec10k.txt", package = "mBPCR")


###################################################
### chunk number 27: 
###################################################
#line 307 "mBPCR.Rnw"
rec10k <- importCNData(path, NRowSkip=1)


###################################################
### chunk number 28: 
###################################################
#line 315 "mBPCR.Rnw"
plot(rec10k$position[rec10k$chr == 3], rec10k$logratio[rec10k$chr == 3], xlab='Chromosome 3', ylab='log2ratio')        


###################################################
### chunk number 29: 
###################################################
#line 326 "mBPCR.Rnw"
library(SNPchip)


###################################################
### chunk number 30: 
###################################################
#line 329 "mBPCR.Rnw"
data(sample.snpset)


###################################################
### chunk number 31: 
###################################################
#line 338 "mBPCR.Rnw"
library(mBPCR)


###################################################
### chunk number 32: 
###################################################
#line 342 "mBPCR.Rnw"
r <- estProfileWithMBPCRforOligoSnpSet(sample.snpset, sampleToBeAnalyzed=3, chrToBeAnalyzed=1, maxProbeNumber=1000, ifLogRatio=0, rhoSquare= 0.0889637)


###################################################
### chunk number 33: 
###################################################
#line 347 "mBPCR.Rnw"
cc <- r$estPC


###################################################
### chunk number 34: 
###################################################
#line 350 "mBPCR.Rnw"
cc1 <- cc[chromosome(cc) == "1",3]


###################################################
### chunk number 35: 
###################################################
#line 353 "mBPCR.Rnw"
graph.par <- plotSnp(cc1)


###################################################
### chunk number 36: 
###################################################
#line 356 "mBPCR.Rnw"
graph.par$ylim <- c(-0.23, 0.1)


###################################################
### chunk number 37: 
###################################################
#line 359 "mBPCR.Rnw"
graph.par$cytoband.ycoords <- c(-0.22, -0.18)


###################################################
### chunk number 38: 
###################################################
#line 362 "mBPCR.Rnw"
print(graph.par)


