###################################################
### chunk number 1: 
###################################################
#line 30 "lol.Rnw"
options(width=80)
options(verbose=FALSE)


###################################################
### chunk number 2: 
###################################################
#line 58 "lol.Rnw"
library(lol)
data(chin07)
dim(chin07$cn)
dim(chin07$ge)


###################################################
### chunk number 3: 
###################################################
#line 66 "lol.Rnw"
gain <- rowSums(chin07$cn >= .2)
loss <- -rowSums(chin07$cn <= -.2)
plotGW(data=cbind(gain, loss), pos=attr(chin07$cn, 'chrome'), file='plotGWCN', 
fileType='pdf', legend=c('gain', 'loss'), col=c('darkred', 'darkblue'))


###################################################
### chunk number 4: 
###################################################
#line 77 "lol.Rnw"
Data <- list(y=chin07$ge[1,], x=t(chin07$cn))
class(Data) <- 'cv'
set.seed(10)
res.cv <- lasso(Data)
res.cv


###################################################
### chunk number 5: 
###################################################
#line 89 "lol.Rnw"
class(Data) <- 'stability'
res.stability <- lasso(Data)
res.stability


###################################################
### chunk number 6: 
###################################################
#line 97 "lol.Rnw"
class(Data) <- 'multiSplit'
res.multiSplit <- lasso(Data)
res.multiSplit


###################################################
### chunk number 7: 
###################################################
#line 104 "lol.Rnw"
class(Data) <- 'simultaneous'
res.simultaneous <- lasso(Data)
res.simultaneous


###################################################
### chunk number 8: 
###################################################
#line 111 "lol.Rnw"
plotGW(data=cbind(res.cv$beta, res.stability$beta, res.multiSplit$beta, res.simultaneous$beta), 
pos=attr(chin07$cn, 'chrome'), file='plotGWLassoOptimizers', fileType='pdf', width=8, 
height=5, legend=c('cv', 'stability', 'multiSplit', 'simultaneous'), legend.pos='topleft')


###################################################
### chunk number 9: 
###################################################
#line 119 "lol.Rnw"
Data <- list(y=t(chin07$ge), x=t(chin07$cn))
res1 <- matrixLasso(Data, method='cv')
res1
res2 <- matrixLasso(Data, method='stability')
res2


###################################################
### chunk number 10: 
###################################################
#line 128 "lol.Rnw"
res.lm <- lmMatrixFit(y=Data, mat=abs(res2$coefMat), th=0.01)
res.lm


###################################################
### chunk number 11: sessionInfo
###################################################
#line 134 "lol.Rnw"
sessionInfo()


