###################################################
### chunk number 1: ibhExample
###################################################
#line 37 "ibh.Rnw"
 library(ibh)
 data(ArabidopsisBioGRIDInteractionEntrezId)
 geneList <- list(839226, 817241, 824340, 832179, 818561, 831145, 
     838782, 826404)
 ibh(ArabidopsisBioGRIDInteractionEntrezId, geneList)


###################################################
### chunk number 2: ibhBioGRIDExample1
###################################################
#line 47 "ibh.Rnw"
 geneList <- list(839226, 817241, 824340, 832179, 818561, 831145, 
   838782, 826404)
ibhBioGRID(geneList, organism = "arabidopsis", idType = "EntrezId")


###################################################
### chunk number 3: ibhBioGRIDExample2
###################################################
#line 52 "ibh.Rnw"
 geneList <- list("YJR151C", "YBL032W", "YAL040C", "YBL072C", 
     "YCL050C", "YCR009C")
 ibhBioGRID(geneList, organism = "yeast", idType = "UniqueId")


###################################################
### chunk number 4: ibhForMultipleGeneListsExample
###################################################
#line 58 "ibh.Rnw"
 data(ArabidopsisBioGRIDInteractionEntrezId)
 listofGeneList <- list(list(839226, 817241, 824340, 832179, 818561, 
     831145, 838782, 826404), list(832018, 839226, 838824))
 ibhForMultipleGeneLists(ArabidopsisBioGRIDInteractionEntrezId, 
     listofGeneList)


###################################################
### chunk number 5: ibhForMultipleGeneListsBioGRIDExample
###################################################
#line 65 "ibh.Rnw"
 listofGeneList <- list(list("YJR151C", "YBL032W", "YAL040C", 
     "YBL072C", "YCL050C", "YCR009C"), list("YDR063W", "YDR074W", 
     "YDR080W", "YDR247W", "YGR183C", "YHL033C"), list("YOL068C", 
     "YOL015W", "YOL009C", "YOL004W", "YOR065W"))
 ibhForMultipleGeneListsBioGRID(listofGeneList, organism = "yeast", 
     idType = "UniqueId")


###################################################
### chunk number 6: ibhClusterEvalExample
###################################################
#line 74 "ibh.Rnw"
 require(yeastCC)
 require(stats)
 data(yeastCC)
 require(simpIntLists)
 data(YeastBioGRIDInteractionUniqueId)
 subset <- exprs(yeastCC)[1:50, ]
 d <- dist(subset, method = "euclidean")
 k <- kmeans(d, 3)
 ibhClusterEval(k$cluster, rownames(subset), YeastBioGRIDInteractionUniqueId)


###################################################
### chunk number 7: ibhClusterEvalBioGRIDExample
###################################################
#line 85 "ibh.Rnw"
 ibhClusterEvalBioGRID(k$cluster, rownames(subset), organism = "yeast", 
     idType = "UniqueId")


