###################################################
### chunk number 1: requiredFiles1
###################################################
#line 58 "goProfiles.Rnw"
options(width=60, warn=0, digits=5)
require(goProfiles)


###################################################
### chunk number 2: prostateIds
###################################################
#line 86 "goProfiles.Rnw"
require(goProfiles)
data(prostateIds)


###################################################
### chunk number 3: basicProfilesMF
###################################################
#line 91 "goProfiles.Rnw"
welsh.MF <- basicProfile (welsh01EntrezIDs[1:100], onto="MF", level=2, orgPackage="org.Hs.eg.db") 
singh.MF <- basicProfile (singh01EntrezIDs[1:100], onto="MF", level=2, orgPackage="org.Hs.eg.db") 
welsh.singh.MF <-mergeProfilesLists(welsh.MF, singh.MF, profNames=c("Welsh", "Singh"))
printProfiles(welsh.singh.MF, percentage=TRUE)


###################################################
### chunk number 4: plotProfileMF
###################################################
#line 99 "goProfiles.Rnw"
plotProfiles (welsh.MF, aTitle="Welsh (2001). Prostate cancer data")


###################################################
### chunk number 5: basicProfilesANY
###################################################
#line 106 "goProfiles.Rnw"
welsh <- basicProfile (welsh01EntrezIDs[1:100], onto="ANY", level=2, orgPackage="org.Hs.eg.db") 


###################################################
### chunk number 6: comparevisual
###################################################
#line 112 "goProfiles.Rnw"
plotProfiles (welsh.singh.MF, percentage=T,aTitle="Welsh vs Singh", legend=T) 


###################################################
### chunk number 7: compareDiff1
###################################################
#line 121 "goProfiles.Rnw"
compared.welsh.singh.01.MF <- compareGeneLists (welsh01EntrezIDs[1:100], singh01EntrezIDs[1:100], onto="MF", level=2, orgPackage="org.Hs.eg.db")
print(compSummary(compared.welsh.singh.01.MF))


###################################################
### chunk number 8: compareEquiv1
###################################################
#line 135 "goProfiles.Rnw"
data(prostateIds)
expandedWelsh <- expandedProfile(welsh01EntrezIDs[1:100], onto="MF",
                        level=2, orgPackage="org.Hs.eg.db")
expandedSingh <- expandedProfile(singh01EntrezIDs[1:100], onto="MF",
                        level=2, orgPackage="org.Hs.eg.db")
commonGenes <- intersect(welsh01EntrezIDs[1:100], singh01EntrezIDs[1:100])
commonExpanded <- expandedProfile(commonGenes, onto="MF", level=2, orgPackage="org.Hs.eg.db")

equivMF <-equivalentGOProfiles (expandedWelsh[['MF']], 
                          qm  = expandedSingh[['MF']], 
                          pqn0= commonExpanded[['MF']])
print(equivSummary(equivMF, decs=5))



