###################################################
### chunk number 1: make data
###################################################
#line 87 "GlobalTest.Rnw"
set.seed(1)
Y <- rnorm(20)
X <- matrix(rnorm(200), 20, 10)
X[,1:3] <- X[,1:3] + Y
colnames(X) <- LETTERS[1:10]


###################################################
### chunk number 2: 
###################################################
#line 99 "GlobalTest.Rnw"
library(globaltest)


###################################################
### chunk number 3: options
###################################################
#line 107 "GlobalTest.Rnw"
gt.options(trace=FALSE, max.print=45)


###################################################
### chunk number 4: full formula simple
###################################################
#line 117 "GlobalTest.Rnw"
gt(Y~1, Y~A+B+C, data = X)


###################################################
### chunk number 5: full formula
###################################################
#line 128 "GlobalTest.Rnw"
gt(Y~D, Y~A+B+C+D, data = X)


###################################################
### chunk number 6: summary
###################################################
#line 136 "GlobalTest.Rnw"
summary(gt(Y~A, Y~A+B+C, data = X))


###################################################
### chunk number 7: 
###################################################
#line 141 "GlobalTest.Rnw"
res <- gt(Y~A, Y~A+B+C, data = X)
p.value(res)
z.score(res)
result(res)
size(res)


###################################################
### chunk number 8:  eval=FALSE
###################################################
## #line 157 "GlobalTest.Rnw"
## gt(Y~A, ~B+C, data = X)


###################################################
### chunk number 9: 
###################################################
#line 163 "GlobalTest.Rnw"
gt(Y~A+B+C, data = X)


###################################################
### chunk number 10: 
###################################################
#line 168 "GlobalTest.Rnw"
gt(Y~A, ~., data = X)


###################################################
### chunk number 11: 
###################################################
#line 174 "GlobalTest.Rnw"
gt(Y, X)


###################################################
### chunk number 12: null design
###################################################
#line 179 "GlobalTest.Rnw"
designA <- cbind(1, X[,"A"])
gt(Y, X, designA)


###################################################
### chunk number 13: poisson
###################################################
#line 190 "GlobalTest.Rnw"
P <- rpois(20, lambda=2)
gt(P~A, ~., data=X, model = "Poisson")
gt(P~A, ~., data=X, model = "linear")


###################################################
### chunk number 14: permutations
###################################################
#line 214 "GlobalTest.Rnw"
gt(Y,X)
gt(Y,X, permutations=1e4)


###################################################
### chunk number 15: 
###################################################
#line 222 "GlobalTest.Rnw"
hist(gt(Y,X, permutations=1e4))


###################################################
### chunk number 16: 
###################################################
#line 232 "GlobalTest.Rnw"
A <- X[,"A"]
gt(Y,X,A)
gt(Y,X,~A)


###################################################
### chunk number 17: no intercept
###################################################
#line 240 "GlobalTest.Rnw"
gt(Y~0+A, ~ B+C, data = X)


###################################################
### chunk number 18: alternative intercept
###################################################
#line 244 "GlobalTest.Rnw"
IC <- rep(1, 20)
gt(Y~0+A, ~ IC+B+C, data = X)


###################################################
### chunk number 19: factors
###################################################
#line 256 "GlobalTest.Rnw"
YY <- rnorm(6)
FF <- factor(rep(letters[1:2], 3))
GG <- factor(rep(letters[3:5], 2))
model.matrix(gt(YY ~ FF + GG, x = TRUE))$alternative


###################################################
### chunk number 20: ordered factors
###################################################
#line 265 "GlobalTest.Rnw"
GG <- ordered(GG)
model.matrix(gt(YY ~ GG, x = TRUE))$alternative


###################################################
### chunk number 21: weights
###################################################
#line 275 "GlobalTest.Rnw"
res <- gt(Y, X)
weights(res)


###################################################
### chunk number 22: 
###################################################
#line 282 "GlobalTest.Rnw"
res <- gt(Y,X, standardize=TRUE)
weights(res)


###################################################
### chunk number 23:  eval=FALSE
###################################################
## #line 288 "GlobalTest.Rnw"
## gt(Y, X[,c("A","A","B")], weights=c(.5,.5,1))
## gt(Y, X[,c("A","B")])


###################################################
### chunk number 24: 
###################################################
#line 297 "GlobalTest.Rnw"
gt(Y, X, directional = TRUE)


###################################################
### chunk number 25: 
###################################################
#line 309 "GlobalTest.Rnw"
gt(Y~A+B+C,data=X, test.value=c(.2,.2,.2))


###################################################
### chunk number 26: 
###################################################
#line 315 "GlobalTest.Rnw"
os <- X[,1:3]%*%c(.2,.2,.2)
gt(Y~offset(os), ~A+B+C, data=X)


###################################################
### chunk number 27: covariates preparation
###################################################
#line 331 "GlobalTest.Rnw"
gt(Y~A+B, data=X)
gt(Y~A, data=X)
gt(Y~B, data=X)


###################################################
### chunk number 28: covariates
###################################################
#line 341 "GlobalTest.Rnw"
covariates(gt(Y,X))


###################################################
### chunk number 29: covariatesW
###################################################
#line 349 "GlobalTest.Rnw"
covariates(gt(Y,X), what="w")


###################################################
### chunk number 30: covariates output
###################################################
#line 359 "GlobalTest.Rnw"
res <- covariates(gt(Y,X))
res[1:10]


###################################################
### chunk number 31: covariates leafNodes
###################################################
#line 364 "GlobalTest.Rnw"
leafNodes(res, alpha=0.10)


###################################################
### chunk number 32: covariates_zoom
###################################################
#line 372 "GlobalTest.Rnw"
covariates(gt(Y,X), zoom=TRUE)


###################################################
### chunk number 33: 
###################################################
#line 402 "GlobalTest.Rnw"
subjects(gt(Y,X))


###################################################
### chunk number 34: 
###################################################
#line 410 "GlobalTest.Rnw"
subjects(gt(Y,X), what="s", mirror=FALSE)


###################################################
### chunk number 35: subset
###################################################
#line 432 "GlobalTest.Rnw"
set <- LETTERS[1:3]
gt(Y,X, subsets = set)


###################################################
### chunk number 36: many sets
###################################################
#line 437 "GlobalTest.Rnw"
sets <- list(one=LETTERS[1:3], two=LETTERS[4:6])
gt(Y,X, subsets = sets)


###################################################
### chunk number 37: subsets method
###################################################
#line 444 "GlobalTest.Rnw"
res <- gt(Y,X, subsets = sets)
subsets(res)


###################################################
### chunk number 38: many weights
###################################################
#line 450 "GlobalTest.Rnw"
wts <- list(up = 1:10, down = 10:1)
gt(Y,X,weights=wts)


###################################################
### chunk number 39: single weight many subsets
###################################################
#line 457 "GlobalTest.Rnw"
gt(Y,X, subsets=sets, weights=1:10)


###################################################
### chunk number 40: subsets and weights
###################################################
#line 461 "GlobalTest.Rnw"
gt(Y,X, subsets=sets, weights=wts)
gt(Y,X, subsets=sets, weights=list(1:3,7:5))


###################################################
### chunk number 41: alias
###################################################
#line 467 "GlobalTest.Rnw"
res <- gt(Y,X, weights=wts, alias = c("one", "two"))
alias(res)
alias(res) <- c("ONE", "TWO")


###################################################
### chunk number 42: sort
###################################################
#line 474 "GlobalTest.Rnw"
res[1]
sort(res)


###################################################
### chunk number 43: p.adjust
###################################################
#line 491 "GlobalTest.Rnw"
p.adjust(res)
p.adjust(res, "BH")
p.adjust(res, "BY")


###################################################
### chunk number 44: focuslevel set structure
###################################################
#line 505 "GlobalTest.Rnw"
level1 <- as.list(LETTERS[1:10])
names(level1) <- letters[1:10]
level2 <- list(abc = LETTERS[1:3], cde  = LETTERS[3:5],
                     fgh = LETTERS[6:8], hij = LETTERS[8:10])
level3 <- list(all = LETTERS[1:10])
dag <- c(level1, level2, level3)


###################################################
### chunk number 45: focus level choice
###################################################
#line 516 "GlobalTest.Rnw"
fl <- names(level2)
fl <- findFocus(dag, maxsize=8)


###################################################
### chunk number 46: focus level
###################################################
#line 523 "GlobalTest.Rnw"
res <- gt(Y,X)
res <- focusLevel(res, sets = dag, focus=fl)
sort(res)


###################################################
### chunk number 47: focus level leaf nodes
###################################################
#line 531 "GlobalTest.Rnw"
leafNodes(res)


###################################################
### chunk number 48: draw
###################################################
#line 538 "GlobalTest.Rnw"
draw(res, names=TRUE)


###################################################
### chunk number 49: draw legend eval=FALSE
###################################################
## #line 543 "GlobalTest.Rnw"
## legend <- draw(res)


###################################################
### chunk number 50: inheritance set structure
###################################################
#line 556 "GlobalTest.Rnw"
level1 <- as.list(LETTERS[1:10])
names(level1) <- letters[1:10]
level2 <- list(ab = LETTERS[1:2], cde = LETTERS[3:5], fg = LETTERS[6:7], hij = LETTERS[8:10])
level3 <- list(all = LETTERS[1:10])
tree <- c(level1, level2, level3)


###################################################
### chunk number 51: inheritance
###################################################
#line 565 "GlobalTest.Rnw"
res <- gt(Y,X)
resI <- inheritance(res, tree)
resI


###################################################
### chunk number 52: inheritance
###################################################
#line 578 "GlobalTest.Rnw"
hc <- hclust(dist(t(X)))
resHC <- inheritance(res, hc)
resHC


###################################################
### chunk number 53: inheritance leaf nodes
###################################################
#line 585 "GlobalTest.Rnw"
leafNodes(resI)
leafNodes(resHC)


###################################################
### chunk number 54: inheritance_draw
###################################################
#line 593 "GlobalTest.Rnw"
draw(resHC, names=TRUE)


###################################################
### chunk number 55: inheritance covariates eval=FALSE
###################################################
## #line 598 "GlobalTest.Rnw"
## covariates(res)


###################################################
### chunk number 56: transpose option eval=FALSE
###################################################
## #line 621 "GlobalTest.Rnw"
## gt.options(transpose=TRUE)


###################################################
### chunk number 57: load Golub
###################################################
#line 631 "GlobalTest.Rnw"
library(golubEsets)
data(Golub_Train)


###################################################
### chunk number 58: vsn
###################################################
#line 636 "GlobalTest.Rnw"
library(vsn)
exprs(Golub_Train) <- exprs(vsn2(Golub_Train))


###################################################
### chunk number 59: overall
###################################################
#line 642 "GlobalTest.Rnw"
gt(ALL.AML, Golub_Train)


###################################################
### chunk number 60: Source
###################################################
#line 650 "GlobalTest.Rnw"
gt(ALL.AML ~ Source, Golub_Train)


###################################################
### chunk number 61: transpose option eval=FALSE
###################################################
## #line 659 "GlobalTest.Rnw"
## gt.options(transpose=TRUE)


###################################################
### chunk number 62: trim option eval=FALSE
###################################################
## #line 670 "GlobalTest.Rnw"
## gt.options(trim=TRUE)


###################################################
### chunk number 63: gtKEGG
###################################################
#line 686 "GlobalTest.Rnw"
gtKEGG(ALL.AML, Golub_Train, id = "04110")


###################################################
### chunk number 64: KEGG organism package
###################################################
#line 692 "GlobalTest.Rnw"
eg <- as.list(hu6800ENTREZID)
gtKEGG(ALL.AML, Golub_Train, id="04110", probe2entrez = eg, annotation="org.Hs.eg.db")


###################################################
### chunk number 65: gtKEGG multtest
###################################################
#line 698 "GlobalTest.Rnw"
gtKEGG(ALL.AML, Golub_Train, id=c("04110","04210"), multtest="BH")


###################################################
### chunk number 66: testKEGG eval=FALSE
###################################################
## #line 702 "GlobalTest.Rnw"
## gtKEGG(ALL.AML, Golub_Train)


###################################################
### chunk number 67: gtGO
###################################################
#line 710 "GlobalTest.Rnw"
gtGO(ALL.AML, Golub_Train, id="GO:0007049")


###################################################
### chunk number 68: GO organism package
###################################################
#line 716 "GlobalTest.Rnw"
eg <- as.list(hu6800ENTREZID)
gtGO(ALL.AML, Golub_Train, id="GO:0007049", probe2entrez = eg, annotation="org.Hs.eg")


###################################################
### chunk number 69: testBP eval=FALSE
###################################################
## #line 722 "GlobalTest.Rnw"
## gtGO(ALL.AML, Golub_Train, ontology="BP", minsize = 10, maxsize = 500)


###################################################
### chunk number 70: gtGO multtest
###################################################
#line 727 "GlobalTest.Rnw"
gtGO(ALL.AML, Golub_Train, id=c("GO:0007049","GO:0006915"), multtest="BH")


###################################################
### chunk number 71: focusGO
###################################################
#line 732 "GlobalTest.Rnw"
descendants <- get("GO:0007049", GOBPOFFSPRING)
res <- gtGO(ALL.AML, Golub_Train, id = c("GO:0007049", descendants), multtest = "focus")
leafNodes(res)


###################################################
### chunk number 72: significantGO1 eval=FALSE
###################################################
## #line 739 "GlobalTest.Rnw"
## draw(res, interactive=TRUE)
## legend <- draw(res)


###################################################
### chunk number 73: significantGO2
###################################################
#line 743 "GlobalTest.Rnw"
draw(res)


###################################################
### chunk number 74: getBroadSets eval=FALSE
###################################################
## #line 752 "GlobalTest.Rnw"
## broad <- getBroadSets("your/path/to/msigdb_v.2.5.xml")


###################################################
### chunk number 75: gtBroad eval=FALSE
###################################################
## #line 758 "GlobalTest.Rnw"
## gtBroad(ALL.AML, Golub_Train, id = "chr5q33", collection=broad)


###################################################
### chunk number 76: Broad organism package eval=FALSE
###################################################
## #line 764 "GlobalTest.Rnw"
## eg <- as.list(hu6800ENTREZID)
## gtBroad(ALL.AML, Golub_Train, id = "chr5q33", collection=broad, probe2entrez = eg, annotation="org.Hs.eg.db")


###################################################
### chunk number 77: gtBroad multtest eval=FALSE
###################################################
## #line 771 "GlobalTest.Rnw"
## gtBroad(ALL.AML, Golub_Train, id=c("chr5q33","chr5q34"), multtest="BH", collection=broad)


###################################################
### chunk number 78: Broad c1 eval=FALSE
###################################################
## #line 784 "GlobalTest.Rnw"
## gtBroad(ALL.AML, Golub_Train, category="c1", collection=broad)


###################################################
### chunk number 79: gtConcept eval=FALSE
###################################################
## #line 794 "GlobalTest.Rnw"
## gtConcept(ALL.AML, Golub_Train, conceptmatrix="Body System.txt")


###################################################
### chunk number 80: gtConcept organism package eval=FALSE
###################################################
## #line 803 "GlobalTest.Rnw"
## eg <- as.list(hu6800ENTREZID)
## gtConcept(ALL.AML, Golub_Train, conceptmatrix="Body System.txt", probe2entrez = eg, annotation="org.Hs.eg.db")


###################################################
### chunk number 81: gtConcept multtest eval=FALSE
###################################################
## #line 811 "GlobalTest.Rnw"
## gtConcept(ALL.AML, Golub_Train, conceptmatrix="Body System.txt", multtest="BH")


###################################################
### chunk number 82: KEGG_covariates
###################################################
#line 822 "GlobalTest.Rnw"
res <- gtKEGG(ALL.AML, Golub_Train, id = "04110")
features(res, alias=hu6800SYMBOL)


###################################################
### chunk number 83: LeafNodes geneplot
###################################################
#line 830 "GlobalTest.Rnw"
ft <- features(res, alias=hu6800SYMBOL)
leafNodes(ft)


###################################################
### chunk number 84: subsets leafNodes eval=FALSE
###################################################
## #line 835 "GlobalTest.Rnw"
## subsets(leafNodes(ft))


###################################################
### chunk number 85: KEGG_covariates_zoom
###################################################
#line 840 "GlobalTest.Rnw"
res <- gtKEGG(ALL.AML, Golub_Train, id = "04110")
features(res, alias=hu6800SYMBOL, zoom=TRUE)


###################################################
### chunk number 86: pdf covariates eval=FALSE
###################################################
## #line 847 "GlobalTest.Rnw"
## res_all <- gtKEGG(ALL.AML, Golub_Train)
## features(res_all[1:5], pdf="KEGGcov.pdf", alias=hu6800SYMBOL)


###################################################
### chunk number 87: KEGG_subjects
###################################################
#line 856 "GlobalTest.Rnw"
res <- gt(ALL.AML, Golub_Train)
subjects(res)


###################################################
### chunk number 88: pdf covariates eval=FALSE
###################################################
## #line 862 "GlobalTest.Rnw"
## res_all <- gtKEGG(ALL.AML, Golub_Train)
## subjects(res_all[1:25], pdf="KEGGsubj.pdf")


###################################################
### chunk number 89: lungExpression
###################################################
#line 875 "GlobalTest.Rnw"
library(lungExpression)
data(michigan)
gt(Surv(TIME..months., death==1), michigan)


###################################################
### chunk number 90: comparative
###################################################
#line 887 "GlobalTest.Rnw"
res <- gtKEGG(ALL.AML, Golub_Train, id = "04110")
comparative(res)


###################################################
### chunk number 91: litters
###################################################
#line 936 "GlobalTest.Rnw"
library("survival")
data(rats)
nlitters<-length(unique(rats$litter))
Z<-matrix(NA,dim(rats)[1],nlitters, dimnames=list(NULL,1:nlitters))
for (i in 1:nlitters) Z[,i]<-(rats[,1]==i)*1
gt(Surv(time,status)~rx,alternative=Z,data=rats,model="cox")


###################################################
### chunk number 92: anscombe
###################################################
#line 971 "GlobalTest.Rnw"
data(anscombe)
set.seed(0)
X<-anscombe$x2
Y<-anscombe$y2 + rnorm(length(X),0,3)
gtPS(Y~X)


###################################################
### chunk number 93: different pord
###################################################
#line 980 "GlobalTest.Rnw"
gtPS(Y~X, pord=list(a=0,b=1,c=2,d=3))


###################################################
### chunk number 94: different nint
###################################################
#line 984 "GlobalTest.Rnw"
lpord<-list(a0=0,b0=0,c0=0,a2=2,b2=2,c2=2)
lnint<-list(a0=2,b0=5,c0=100, a2=2,b2=5,c2=100)
gtPS(Y~X, nint=lnint, pord=lpord)


###################################################
### chunk number 95: psplines span
###################################################
#line 994 "GlobalTest.Rnw"
B<-bbase(X, bdeg=3, nint=10)
N<-repdes(B, pord=3)$N
qr(cbind(model.matrix(~X),N))$rank


###################################################
### chunk number 96: union
###################################################
#line 1006 "GlobalTest.Rnw"
data("stanford2")
cc<-complete.cases(stanford2)
stanford2cc<-stanford2[cc,]
fit0<-coxph(Surv(time,status)~age,data=stanford2cc)
gtPS(fit0)


###################################################
### chunk number 97: stanford2 fit
###################################################
#line 1022 "GlobalTest.Rnw"
Z<-getPS(stanford2cc,covs="age")
require("penalized")
fit1 <- penalized(Surv(time,status), penalized=~ Z, unpenalized=~age, data = stanford2cc, model="cox", lambda2 = 15, trace=FALSE)


###################################################
### chunk number 98: goodness_stanford2
###################################################
#line 1030 "GlobalTest.Rnw"
ages<-sort(stanford2cc$age, index.return=T)
plot(ages$x,fit1@lin.pred,type="l",xlab="age",ylab="linear predictor", ylim=c(-0.4,3.3))


###################################################
### chunk number 99: wpbc
###################################################
#line 1052 "GlobalTest.Rnw"
require("mboost")
data("wpbc")
cc <- complete.cases(wpbc)
wpbc2 <- wpbc[cc, colnames(wpbc) != "time"]
gtPS(status ~ ., data = wpbc2, model="logistic")


###################################################
### chunk number 100: goodness_wpbc
###################################################
#line 1065 "GlobalTest.Rnw"
covnames<-names(wpbc2)[-1]
bd=3
ni=10
po=2
d<-bd+ni-po
Z<-getPS(wpbc2,covs=covnames, bdeg=bd, nint=ni, pord=po)

fit1<-penalized(response=status, penalized=~ Z, unpenalized=~mean_radius + mean_texture + mean_perimeter + mean_area + 
    mean_smoothness + mean_compactness + mean_concavity + mean_concavepoints + 
    mean_symmetry + mean_fractaldim + SE_radius + SE_texture + 
    SE_perimeter + SE_area + SE_smoothness + SE_compactness + 
    SE_concavity + SE_concavepoints + SE_symmetry + SE_fractaldim + 
    worst_radius + worst_texture + worst_perimeter + worst_area + 
    worst_smoothness + worst_compactness + worst_concavity + 
    worst_concavepoints + worst_symmetry + worst_fractaldim + 
    tsize + pnodes, data = wpbc2, model="logistic", lambda2 = 7, trace=FALSE)

gammas<-fit1@penalized
betas<-fit1@unpenalized
l<-length(covnames)
cd<-c(0,cumsum(rep(d,l)))

op <- par(mfrow = c(2, 2))
for (i in c(12,21,25,31)){
x<-wpbc2[,covnames[i]]
sx<-sort(x,index.return=T)
ind<-vector("list", l)
ind[[i]]<-(cd[i]+1):(cd[i+1])
plot(sx$x, (Z[sx$ix,ind[[i]]]%*%gammas[ind[[i]]] ), type="b", xlab=covnames[i], ylab=paste("f(",covnames[i],")", sep=""), ylim=c(-.5,.65))
lines(abline(h=0,lty="dotted"))
rug(x)
}
par(op)


###################################################
### chunk number 101: rats ph
###################################################
#line 1119 "GlobalTest.Rnw"
gtPS(Surv(time,status)~rx,covs="time", by="rx",data=rats, model="cox", pord=1)


