###################################################
### chunk number 1: <options
###################################################
#line 35 "genoset.Rnw"
  options(width=90)


###################################################
### chunk number 2: objectcreation
###################################################
#line 73 "genoset.Rnw"
library(genoset)
data(genoset)
genoset.ds = GenoSet( locData=locData.rd, foo=fake.lrr, pData=fake.pData, annotation="SNP6" )

baf.ds = BAFSet( locData=locData.rd, lrr=fake.lrr, baf=fake.baf, pData=fake.pData, annotation="SNP6" )

cn.ds = CNSet( locData=locData.rd, cn=fake.lrr, pData=fake.pData, annotation="SNP6" )
cn.ds

rle.baf.ds = BAFSet( locData=locData.rd,
  lrr=DataFrame(K=Rle(c(rep(1.5,300),rep(2.3,700))),L=Rle( c(rep(3.2,700),rep(2.1,300)) ), M=Rle(rep(1.1,1000)),row.names=rownames(fake.lrr)),
  baf=DataFrame(K=Rle(c(rep(0.05,600),rep(0.5,400))),L=Rle( c(rep(0,700),rep(0.5,300)) ), M=Rle(rep(1,1000)),row.names=rownames(fake.baf)),
  pData=fake.pData,
  annotation="SNP6"
  )


###################################################
### chunk number 3: subsetdc
###################################################
#line 95 "genoset.Rnw"
chr12.ds = cn.ds[["chr12"]]
chr12.ds
gene.rd = RangedData(ranges=IRanges(start=c(35e6,127e6),end=c(35.5e6,129e6),
                       names=c("HER2","CMYC")), space=c("chr17","chr8"))
gene.ds = cn.ds[ gene.rd, ]
gene.ds


###################################################
### chunk number 4: subsetsamples
###################################################
#line 105 "genoset.Rnw"
cn.ds[1:4,1:2]


###################################################
### chunk number 5: cbs
###################################################
#line 132 "genoset.Rnw"
assayDataElement(cn.ds,"cn.segs") = runCBS(cn(cn.ds),locData(cn.ds), n.cores=3)


###################################################
### chunk number 6: cbssegs eval=FALSE
###################################################
## #line 147 "genoset.Rnw"
## segs = runCBS(cn(cn.ds), locData(cn.ds), n.cores=3, return.segs=TRUE)


###################################################
### chunk number 7: segs2mat eval=FALSE
###################################################
## #line 153 "genoset.Rnw"
## segTable(assayDataElement(cn.ds,"cn.segs"), locData(cn.ds))


###################################################
### chunk number 8: 
###################################################
#line 160 "genoset.Rnw"
png(file="genoset-plotgenome.png",width=12,height=5,res=150,units="in")


###################################################
### chunk number 9: plotgenome
###################################################
#line 164 "genoset.Rnw"
genoPlot(cn.ds, 1)
genoPlot(cn.ds, 1, element="cn.segs", add=TRUE, col="red")


###################################################
### chunk number 10: 
###################################################
#line 169 "genoset.Rnw"
invisible(dev.off())


###################################################
### chunk number 11: 
###################################################
#line 182 "genoset.Rnw"
png(file="genoset-plotchr.png",width=12,height=5,res=150,units="in")


###################################################
### chunk number 12: plotchr
###################################################
#line 186 "genoset.Rnw"
genoPlot(cn.ds,1,chr="chr12")
genoPlot(cn.ds,1,chr="chr12",element="cn.segs",add=TRUE, col="red")


###################################################
### chunk number 13: 
###################################################
#line 191 "genoset.Rnw"
invisible(dev.off())


###################################################
### chunk number 14: mbafcutoff
###################################################
#line 218 "genoset.Rnw"
assayDataElement(baf.ds,"mbaf") = baf2mbaf(baf(baf.ds),hom.cutoff = 0.90)


###################################################
### chunk number 15: segment
###################################################
#line 233 "genoset.Rnw"
assayDataElement(baf.ds,"baf.segs") = runCBS( assayDataElement(baf.ds,"mbaf"), locData(baf.ds) )
assayDataElement(baf.ds,"lrr.segs") = runCBS( lrr(baf.ds), locData(baf.ds) )


###################################################
### chunk number 16: 
###################################################
#line 243 "genoset.Rnw"
png(file="genoset-plotlrr.png",width=7,height=4,res=150,units="in")


###################################################
### chunk number 17: plotlrr
###################################################
#line 246 "genoset.Rnw"
genoPlot(baf.ds,1,chr="chr12",element="lrr",main="LRR of chr12")
genoPlot(baf.ds,1,chr="chr12",element="lrr.segs",add=TRUE,col="red")


###################################################
### chunk number 18: 
###################################################
#line 250 "genoset.Rnw"
invisible(dev.off())


###################################################
### chunk number 19: 
###################################################
#line 264 "genoset.Rnw"
png(file="genoset-plotbaf.png",width=7,height=8,res=150,units="in")


###################################################
### chunk number 20: plotbaf
###################################################
#line 267 "genoset.Rnw"
par(mfrow=c(2,1))
genoPlot(baf.ds,1,chr="chr12",element="baf", main="BAF of chr12")
genoPlot(baf.ds,1,chr="chr12",element="mbaf", main="mBAF of chr12")
genoPlot(baf.ds,1,chr="chr12",element="baf.segs", add=TRUE,col="red")


###################################################
### chunk number 21: 
###################################################
#line 273 "genoset.Rnw"
invisible(dev.off())


###################################################
### chunk number 22: genelevel
###################################################
#line 325 "genoset.Rnw"
# Get the gene-level summary
rangeSampleMeans(gene.rd, baf.ds, "lrr")


