/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.systemsbiology.gaggle.experiment.metadata.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Condition
implements Serializable {
    String alias;
    Integer order;
    ArrayList<Variable> variables;

    public Condition(String alias) {
        this(alias, null);
    }

    public Condition(String alias, Integer order) {
        this.alias = alias;
        this.order = order;
        this.variables = new ArrayList();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setVariables(ArrayList<Variable> newValue) {
        this.variables = newValue;
    }

    public Variable[] getVariables() {
        return this.variables.toArray(new Variable[0]);
    }

    public void addVariable(Variable variable) {
        this.variables.add(variable);
    }

    public String[] getVariableNames() {
        Variable[] variables = this.getVariables();
        ArrayList<String> list = new ArrayList<String>();
        for (Variable variable : variables) {
            list.add(variable.getName());
        }
        Collections.sort(list);
        return list.toArray(new String[0]);
    }

    public Variable getVariable(String name) {
        Variable[] variables;
        for (Variable variable : variables = this.getVariables()) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("condition: ");
        sb.append(this.alias);
        sb.append("\n");
        sb.append("Order: ");
        String orderStr = this.order == null ? "(null)" : this.order.toString();
        sb.append(orderStr).append("\n");
        for (Variable var : this.getVariables()) {
            sb.append("     ");
            sb.append(var.getName()).append(" = ").append(var.getValue());
            if (var.getUnits() != null) {
                sb.append(" ").append(var.getUnits());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

