###################################################
### chunk number 1: foo
###################################################
#line 18 "flowPhyto.Rnw"
options(keep.source = TRUE, width = 60)
foo <- packageDescription("flowPhyto")


###################################################
### chunk number 2: loadlib
###################################################
#line 50 "flowPhyto.Rnw"
library(flowPhyto)


###################################################
### chunk number 3: read
###################################################
#line 65 "flowPhyto.Rnw"
CHANNEL.CLMNS


###################################################
### chunk number 4: read
###################################################
#line 70 "flowPhyto.Rnw"
evt.file.path <- system.file("extdata","seaflow_cruise","2011_001", "2.evt",
				package="flowPhyto")
evt <- readSeaflow(evt.file.path)


###################################################
### chunk number 5: filter
###################################################
#line 80 "flowPhyto.Rnw"
opp <- filter(evt, notch=1.1)


###################################################
### chunk number 6: classify1
###################################################
#line 87 "flowPhyto.Rnw"
opp.path <- system.file("extdata","seaflow_cruise","2011_001", "2.evt.opp", 
				package="flowPhyto")
pop.def.path <- system.file("extdata","seaflow_cruise","pop.def.tab", 
				package="flowPhyto")
opp <- readSeaflow(opp.path)
def <- readPopDef(pop.def.path)
def


###################################################
### chunk number 7: classify1
###################################################
#line 100 "flowPhyto.Rnw"
pop <- classify(x=opp, pop.def= def, func=2 )

table(pop$pop)


###################################################
### chunk number 8: plotCytogram
###################################################
#line 108 "flowPhyto.Rnw"
plotCytogram(pop, "fsc_small","chl_small", pop.def= def, add.legend=TRUE, cex=1)



###################################################
### chunk number 9: fig1
###################################################
#line 114 "flowPhyto.Rnw"
#line 108 "flowPhyto.Rnw"
plotCytogram(pop, "fsc_small","chl_small", pop.def= def, add.legend=TRUE, cex=1)

#line 115 "flowPhyto.Rnw"


###################################################
### chunk number 10: consensus
###################################################
#line 132 "flowPhyto.Rnw"
vct.paths <- sapply(c(1,439,440), function(i) 
		system.file("extdata","seaflow_cruise","2011_001", 
			paste("1.evt.opp.",i,'-class.vct',sep=''), 
				package="flowPhyto"))
mat <- do.call(cbind,lapply(vct.paths, read.delim))
consen.df <- consensus(mtrx=mat)
table(consen.df$pop)
aggregate(consen.df$support,list(consen.df$pop), mean)


###################################################
### chunk number 11: census
###################################################
#line 146 "flowPhyto.Rnw"
census(v=pop$pop, pop.def=def)


###################################################
### chunk number 12: summarize
###################################################
#line 154 "flowPhyto.Rnw"
filter.df <- readSeaflow(opp.path, add.yearday.file=TRUE)
classed <- cbind.data.frame(filter.df, consen.df)
names(opp.path) <- getFileNumber(opp.path)
class.jn <- joinSDS(classed, opp.path)
nrow.opp <- sapply(opp.path, function(p) readSeaflow(              p , count.only=TRUE))
nrow.evt <- sapply(opp.path, function(p) readSeaflow(sub('.opp','',p), count.only=TRUE))
class.jn$opp <- rep(nrow.opp, times=nrow.opp)
class.jn$evt <- rep(nrow.evt, times=nrow.opp)

summarize(class.jn,  opp.paths.str=opp.path)


###################################################
### chunk number 13: plotStatMap
###################################################
#line 172 "flowPhyto.Rnw"
stat.tab <- system.file("extdata","seaflow_cruise","stats.tab", 
					package="flowPhyto")
stats <- read.delim(stat.tab)
plotStatMap(df=stats, pop='ultra', z.param='conc', margin=0.2, zlab=expression(paste('Cell concentration, ',10^6 * cells/L)), 
main="Cell concentration of Ultra-plankton population")
mtext(line=1, side=4, "cell concentration 10^6 cells / L")



###################################################
### chunk number 14: fig2
###################################################
#line 183 "flowPhyto.Rnw"
#line 172 "flowPhyto.Rnw"
stat.tab <- system.file("extdata","seaflow_cruise","stats.tab", 
					package="flowPhyto")
stats <- read.delim(stat.tab)
plotStatMap(df=stats, pop='ultra', z.param='conc', margin=0.2, zlab=expression(paste('Cell concentration, ',10^6 * cells/L)), 
main="Cell concentration of Ultra-plankton population")
mtext(line=1, side=4, "cell concentration 10^6 cells / L")

#line 184 "flowPhyto.Rnw"


###################################################
### chunk number 15: validateSDS
###################################################
#line 204 "flowPhyto.Rnw"
path <- system.file("extdata","seaflow_cruise",package="flowPhyto")
sds <- combineSdsFiles(path)
plot(sds$LON, sds$LAT)


###################################################
### chunk number 16: validatePopDef
###################################################
#line 210 "flowPhyto.Rnw"
validatePopDef(readPopDef(pop.def.path))


###################################################
### chunk number 17: pipeline
###################################################
#line 221 "flowPhyto.Rnw"
repository.dir <- '.' 
output.path <- paste(repository.dir,'/','seaflow_cruise',sep='')
seaflow.path <- system.file("extdata", 'seaflow_cruise', package="flowPhyto")
file.copy(from=seaflow.path, to=repository.dir, recursive=TRUE)
pipeline(repo= repository.dir, cruise.name='seaflow_cruise', steps=4, parallel=FALSE, submit.cmd='qsub -l walltime=00:20:00') 
unlink(output.path, recursive=TRUE)


