###################################################
### chunk number 1: loadPackage
###################################################
#line 64 "flowFP_HowTo.Rnw"

library(flowFP)


###################################################
### chunk number 2: ShowData
###################################################
#line 200 "flowFP_HowTo.Rnw"
data(fs1)
fs1


###################################################
### chunk number 3: ShowTube
###################################################
#line 207 "flowFP_HowTo.Rnw"
fs1[[1]]


###################################################
### chunk number 4: Model
###################################################
#line 215 "flowFP_HowTo.Rnw"
mod <-  flowFPModel(fs1, name="CD45/SS Model", parameters=c(2,5), nRecursions=7)
show(mod)


###################################################
### chunk number 5: PlotModel
###################################################
#line 221 "flowFP_HowTo.Rnw"
plot(mod)


###################################################
### chunk number 6: Fingerprint
###################################################
#line 283 "flowFP_HowTo.Rnw"

fp <- flowFP (fs1, mod)
show(fp)
plot (fp, type="stack")


###################################################
### chunk number 7: Plex1
###################################################
#line 329 "flowFP_HowTo.Rnw"

data(fs2)
mod1 <-  flowFPModel(fs1, name="CD45/SS Model vs fs1", parameters=c("SS Log", "FL3 Log"), nRecursions=7)
mod2 <-  flowFPModel(fs2, name="CD45/SS Model vs fs2", parameters=c("SS Log", "FL3 Log"), nRecursions=7)
fp1_1 <- flowFP (fs1, mod1)
fp1_2 <- flowFP (fs1, mod2)
plex <- flowFPPlex(c(fp1_1, fp1_2))
plot (plex, type='grid', vert_scale=10)


###################################################
### chunk number 8: Plex2
###################################################
#line 352 "flowFP_HowTo.Rnw"

fp <- flowFP (fs1, param=c("SS Log", "FL3 Log"), nRecursions=8)
plex <- flowFPPlex()
for (levels in 8:5) {
	nRecursions(fp) <- levels
	plex <- append (plex, fp)
}
plot (plex, type="tangle", transformation="norm")


###################################################
### chunk number 9: QC1
###################################################
#line 457 "flowFP_HowTo.Rnw"

fp1 <- flowFP (fs1, parameters=c("SS Log", "FL3 Log"), name="self model: fs1", nRecursions=5)
plot (fp1, type="qc", main="Gate QC for Sample fs1")


###################################################
### chunk number 10: QC2
###################################################
#line 474 "flowFP_HowTo.Rnw"

fp2 <- flowFP (fs2, parameters=c("SS Log", "FL3 Log"), name="self model: fs2", nRecursions=5)
plot (fp2, type="qc", main="Gate QC for Sample fs2")


###################################################
### chunk number 11: Subsample
###################################################
#line 481 "flowFP_HowTo.Rnw"
phenoData(fs2)$Tube <- factor(1:7)   #$
for (i in 1:7) {
	exprs(fs2[[i]]) = exprs(fs2[[i]])[sample(1:nrow(fs2[[i]]),size=2500),]
}
fp2 <- flowFP (fs2, param=c(2,5), nRec=5)


###################################################
### chunk number 12: FvizFigure
###################################################
#line 489 "flowFP_HowTo.Rnw"
xyplot (`FL3 Log` ~ `SS Log` | Tube, data=fs2)


###################################################
### chunk number 13: 
###################################################
#line 494 "flowFP_HowTo.Rnw"
plot(trellis.last.object())


###################################################
### chunk number 14: QC3
###################################################
#line 503 "flowFP_HowTo.Rnw"
plot (fp2, fs2, hi=5, showbins=c(6,7,10,11), pch=20, cex=.3, transformation='norm')


###################################################
### chunk number 15: QC4
###################################################
#line 517 "flowFP_HowTo.Rnw"
data(plate)
fp <- flowFP (plate, parameters=c("SSC-H","FL3-H","FL4-H"), nRecursions=5)
plot (fp, type='plate')


