###################################################
### chunk number 1: stage0
###################################################
#line 113 "flowClust.Rnw"
library(flowClust)


###################################################
### chunk number 2: stage1
###################################################
#line 116 "flowClust.Rnw"
data(rituximab)
summary(rituximab)
res1 <- flowClust(rituximab, varNames=c("FSC.H", "SSC.H"), K=1, B=100)


###################################################
### chunk number 3: stage2
###################################################
#line 125 "flowClust.Rnw"
rituximab2 <- rituximab[rituximab %in% res1,]
res2 <- flowClust(rituximab2, varNames=c("FL1.H", "FL3.H"), K=1:6, B=100)


###################################################
### chunk number 4: stage2Result
###################################################
#line 130 "flowClust.Rnw"
criterion(res2, "BIC")
summary(res2[[3]])


###################################################
### chunk number 5: stage2ChangeRule1
###################################################
#line 135 "flowClust.Rnw"
ruleOutliers(res2[[3]]) <- list(level=0.95)
summary(res2[[3]])


###################################################
### chunk number 6: stage2ChangeRule2
###################################################
#line 140 "flowClust.Rnw"
ruleOutliers(res2[[3]]) <- list(z.cutoff=0.6)
summary(res2[[3]])


###################################################
### chunk number 7: stage2Alternative
###################################################
#line 147 "flowClust.Rnw"
flowClust(rituximab2, varNames=c("FL1.H", "FL3.H"), K=2, B=100, min=c(0,0), max=c(400,800))


###################################################
### chunk number 8: stage2Scatter
###################################################
#line 155 "flowClust.Rnw"
plot(res2[[3]], data=rituximab2, level=0.8, z.cutoff=0)


###################################################
### chunk number 9: stage2Contour
###################################################
#line 162 "flowClust.Rnw"
res2.den <- density(res2[[3]], data=rituximab2)
plot(res2.den)


###################################################
### chunk number 10: stage2Image
###################################################
#line 167 "flowClust.Rnw"
plot(res2.den, type="image")


###################################################
### chunk number 11: stage2Hist
###################################################
#line 173 "flowClust.Rnw"
hist(res2[[3]], data=rituximab2, subset="FL1.H")


###################################################
### chunk number 12: stage2Hist
###################################################
#line 178 "flowClust.Rnw"
hist(res2[[3]], data=rituximab2, subset=1)


###################################################
### chunk number 13: stage2f
###################################################
#line 191 "flowClust.Rnw"
s2filter <- tmixFilter("s2filter", c("FL1.H", "FL3.H"), K=3, B=100)
res2f <- filter(rituximab2, s2filter)


###################################################
### chunk number 14: stage2fSubsetting
###################################################
#line 196 "flowClust.Rnw"
Subset(rituximab2, res2f)
split(rituximab2, res2f, population=list(sc1=1:2, sc2=3))


###################################################
### chunk number 15: stage2fRectGate
###################################################
#line 205 "flowClust.Rnw"
rectGate <- rectangleGate(filterId="rectRegion", "FL1.H"=c(0, 400), "FL3.H"=c(0, 800))
MBCfilter <- tmixFilter("MBCfilter", c("FL1.H", "FL3.H"), K=2, B=100)
filter(rituximab2, MBCfilter %subset% rectGate)


