### R code from vignette source 'edgeR.Rnw'

###################################################
### code chunk number 1: poisson
###################################################
library(edgeR)
set.seed(101)
n <- 10000
lib.sizes <- c(40000,50000,38000,40000)
p <- runif(n,min=.0001,.001)
mu <- outer(p,lib.sizes)
mu[1:5,3:4]<-mu[1:5,3:4]*8
y <- matrix(rpois(4*n,lambda=mu),nrow=n)
dP <- DGEList(counts=y,group=rep(1:2,each=2),lib.size=lib.sizes)
dP$common.lib.size <- exp(mean(log(dP$samples$lib.size)))


###################################################
### code chunk number 2: poissonstats
###################################################
de.P <- exactTest(dP, dispersion=1e-06) 
topTags(de.P)


###################################################
### code chunk number 3: setup
###################################################
sessionInfo()


