###################################################
### chunk number 1: getGolub
###################################################
#line 73 "HOWTO-edd.Rnw"
library(edd)
library(golubEsets)
library(xtable)
data(Golub_Merge)


###################################################
### chunk number 2: filterGolub
###################################################
#line 84 "HOWTO-edd.Rnw"
madvec <- apply(exprs(Golub_Merge),1,mad)
minvec <- apply(exprs(Golub_Merge),1,min)
keep <- (madvec > median(madvec)) & (minvec > 300)
gmfilt <- Golub_Merge[keep==TRUE,]


###################################################
### chunk number 3: splitGolub
###################################################
#line 92 "HOWTO-edd.Rnw"
ALL <- gmfilt$ALL.AML=="ALL"
gall <- gmfilt[,ALL==TRUE]
gaml <- gmfilt[,ALL==FALSE]
show(gall)


###################################################
### chunk number 4: eddByType
###################################################
#line 102 "HOWTO-edd.Rnw"
set.seed(12345)
alldists <- edd(gall, meth="nnet", size=10, decay=.2)
amldists <- edd(gaml, meth="nnet", size=10, decay=.2)


###################################################
### chunk number 5: 
###################################################
#line 106 "HOWTO-edd.Rnw"
greo <- match(sapply(eddDistList,tag),names(table(alldists)))
if (any(ii <- is.na(greo))) greo = greo[-which(ii)]


###################################################
### chunk number 6: 
###################################################
#line 113 "HOWTO-edd.Rnw"
gn <- row.names(exprs(gall))
alld <- as.character(alldists)[1:5]
names(alld) <- gn[1:5]
print(alld)


###################################################
### chunk number 7: lookKNN
###################################################
#line 120 "HOWTO-edd.Rnw"
set.seed(123)
alldistsKNN <- edd(gall, meth="knn", k=1, l=0)
alldistsTEST <- edd(gall, meth="test", thresh=.3)


###################################################
### chunk number 8: compareKNNvNN
###################################################
#line 128 "HOWTO-edd.Rnw"
cap <- "Comparison of distribution shape classification by nnet (rows) and by knn (columns) methods in edd."
print(try(xtable(
   latEDtable(table(alldists,alldistsKNN),reorder=greo),digits=rep(0,length(table(alldists))+1),caption=cap, label="conc1")))


###################################################
### chunk number 9: testTable
###################################################
#line 135 "HOWTO-edd.Rnw"
print(table(alldistsTEST))


###################################################
### chunk number 10: ALLtable
###################################################
#line 141 "HOWTO-edd.Rnw"
cap <- "Frequencies of distributional shapes in filtered ALL data."
print(xtable(latEDtable(
    table(alldists),reorder=greo),digits=rep(0,length(table(alldists))+1),caption=cap,label="marg1"))


###################################################
### chunk number 11: compare
###################################################
#line 150 "HOWTO-edd.Rnw"
mymat <- matrix(c(1,2),nr=1)
layout(mymat)#,heights=c(lcm(6),lcm(6)),widths=c(lcm(6),lcm(6)),respect=TRUE)
barplot(table(alldists),las=2)
barplot(table(amldists),las=2)


###################################################
### chunk number 12: discordTable
###################################################
#line 163 "HOWTO-edd.Rnw"
cap <- "Rows are gene-specific distribution shapes for ALL, columns for AML, and cell entries are counts of genes."
print(xtable(latEDtable(table(alldists,amldists),reord=greo),cap=cap,
 label="disco1"))


###################################################
### chunk number 13: findBiMod
###################################################
#line 174 "HOWTO-edd.Rnw"
print((1:540)[alldists==".75N(0,1)+.25N(4,1)" &
  amldists=="N(0,1)"][1:5])


###################################################
### chunk number 14: lookD87593
###################################################
#line 186 "HOWTO-edd.Rnw"
par(mfrow=c(2,2))
 plotED(MIXN1,data=exprs(gall)[65,])
 hist(exprs(gall)[65,],xlim=c(0,3500))
 plotED(N01,data=exprs(gaml)[65,])
 hist(exprs(gaml)[65,],xlim=c(0,3500))


###################################################
### chunk number 15: namesEDL
###################################################
#line 207 "HOWTO-edd.Rnw"
names(eddDistList)


###################################################
### chunk number 16: plotRefs
###################################################
#line 215 "HOWTO-edd.Rnw"
par(mfrow=c(4,2))
for (i in 1:8)
 plotED(eddDistList[[i]])


###################################################
### chunk number 17: addMIXN3
###################################################
#line 229 "HOWTO-edd.Rnw"
#> median(rmixnorm(10000,.75,0,1,6,1))
#[1] 0.4337298
#> mad(rmixnorm(10000,.75,0,1,6,1))
#[1] 1.550768  -- these are resistant stats!
MIXN3 <- new("eddDist", stub="mixnorm", parms=c(p1=.75,m1=0,s1=1,m2=6,s2=1),
     median=.43, mad=1.55, tag=".75N(0,1)+.25N(6,1)", plotlim=c(-3,11),
     latexTag="$\\frac{3}{4}\\Phi+\\frac{1}{4}\\Phi_{6,1}$")
eddDistList[["MIXN3"]] <- MIXN3
set.seed(12345)
alldists2 <- edd(gall, meth="nnet", size=10, decay=.2)
print(alldists2[65])


###################################################
### chunk number 18: checkFit3
###################################################
#line 252 "HOWTO-edd.Rnw"
plotED(MIXN3,data=exprs(gall)[65,])


###################################################
### chunk number 19: checkFit1
###################################################
#line 261 "HOWTO-edd.Rnw"
plotED(MIXN1,data=exprs(gall)[65,])


