###################################################
### chunk number 1: KeggMapping
###################################################
#line 79 "domainenrichment.Rnw"
library(domainsignatures)
keggMap <- mget(grep("^hsa", ls(KEGGPATHID2EXTID), value=TRUE), 
                KEGGPATHID2EXTID)
univGenes <-  unique(unlist(keggMap))
randGenes <- sample(univGenes, 30)
pwLength <- listLen(keggMap)
randPw <- "hsa04330"
set.seed(123)
pwGenes <- sample(keggMap[[randPw]], 10)


###################################################
### chunk number 2: gseaprep
###################################################
#line 110 "domainenrichment.Rnw"
geneset <- c(randGenes, pwGenes)
universe <- getKEGGdata(univGenes)
universe


###################################################
### chunk number 3: gseashow eval=FALSE
###################################################
## #line 126 "domainenrichment.Rnw"
## res <- gseDomain(dataSource=universe, geneset=geneset, n=1000)


###################################################
### chunk number 4: gseado
###################################################
#line 129 "domainenrichment.Rnw"
## We only run this code for testing purpos. The actual object was pre-
## computed and we only load the serialized version here.
tmp <- gseDomain(universe, geneset, n=100, verbose=FALSE)
load(system.file("precomp/precomp.rda", package="domainsignatures"))


###################################################
### chunk number 5: volcano
###################################################
#line 142 "domainenrichment.Rnw"
volcData <- cbind(similarity=res$similarity, log_p=-log10(res$pvalue))
plot(volcData, main="volcano plot")
sel <- which.max(res$similarity)
points(volcData[sel,,drop=FALSE], pch=20, col="red")
text(volcData[sel,,drop=FALSE], names(sel), pos=2)


###################################################
### chunk number 6: thesame
###################################################
#line 153 "domainenrichment.Rnw"
names(sel) == randPw
getKEGGdescription(randPw)


###################################################
### chunk number 7: biomart
###################################################
#line 182 "domainenrichment.Rnw"
ensembl <- useMart("ensembl",dataset="hsapiens_gene_ensembl")
cMap <- getBM(attributes=c("entrezgene", "chromosome_name"),
              filters="entrezgene", value=univGenes, mart=ensembl)
cMap <- cMap[cMap$chromosome_name %in% c(as.character(1:23), "X", "Y"),]
grouping <- split(cMap$chromosome_name, cMap$entrezgene)
universe2 <- dataSource(grouping)
geneset2 <- geneset[geneset %in% names(grouping)]


###################################################
### chunk number 8: dsigshow eval=FALSE
###################################################
## #line 191 "domainenrichment.Rnw"
## ## Again, the object was precomputed for perfomance reasons
## res2 <- gseDomain(universe2, geneset2)


###################################################
### chunk number 9: vplot2
###################################################
#line 195 "domainenrichment.Rnw"
volcData2 <- cbind(similarity=res2$similarity, log_p=-log10(res2$pvalue))
plot(volcData2, main="volcano plot", 
     xlim=c(0,max(unlist(res$similarity))))


