###################################################
### chunk number 1: specifyFiles
###################################################
#line 237 "rtPCR.Rnw"
library(ddCt)
datadir <- function(x) system.file("extdata", x, package="ddCt")
savedir <- function(x) file.path(tempdir(), x)

file.names <- c(datadir("Experiment1.txt"),datadir("Experiment2.txt"))
info <- datadir("sampleData.txt")
warningFile <- savedir("warnings.txt")


###################################################
### chunk number 2: readingData
###################################################
#line 257 "rtPCR.Rnw"
name.reference.sample <- c("Sample1", "Sample2")
name.reference.gene <- c("Gene2")


###################################################
### chunk number 3: readData
###################################################
#line 268 "rtPCR.Rnw"
library(Biobase)  
CtData <- SDMFrame(file.names)
sampleInformation <- read.AnnotatedDataFrame(info,header=TRUE, row.names=NULL)


###################################################
### chunk number 4: calculating
###################################################
#line 279 "rtPCR.Rnw"
result <- ddCtExpression(CtData,
                         calibrationSample=name.reference.sample,
                         housekeepingGene=name.reference.gene,
                         sampleInformation=sampleInformation,
                         warningStream=warningFile)


###################################################
### chunk number 5: showMAD
###################################################
#line 292 "rtPCR.Rnw"
CtErr(result)


###################################################
### chunk number 6: vis
###################################################
#line 303 "rtPCR.Rnw"
br <- errBarchart(result)
print(br)


###################################################
### chunk number 7: write Tables
###################################################
#line 322 "rtPCR.Rnw"
elistWrite(result,file=savedir("allValues.txt"))


###################################################
### chunk number 8: sessionInfo
###################################################
#line 337 "rtPCR.Rnw"
toLatex(sessionInfo(), locale=FALSE)


