###################################################
### chunk number 1: loadPacks
###################################################
#line 280 "clippda.Rnw"
library(clippda)


###################################################
### chunk number 2: setWidth
###################################################
#line 282 "clippda.Rnw"
options(width=60)


###################################################
### chunk number 3: liverdata
###################################################
#line 312 "clippda.Rnw"
data(liverdata)
data(liverRawData)
data(liver_pheno)
liverdata[1:4,]
liverRawData[1:4,]


###################################################
### chunk number 4: decription1
###################################################
#line 322 "clippda.Rnw"
names(liverdata)
dim(liverdata)


###################################################
### chunk number 5: checkNo.replicates
###################################################
#line 331 "clippda.Rnw"
no.peaks <- 53
no.replicates <- 2
checkNo.replicates(liverRawData,no.peaks,no.replicates) 


###################################################
### chunk number 6: preProcRepeatedPeakData
###################################################
#line 350 "clippda.Rnw"
threshold <- 0.80 
Data <- preProcRepeatedPeakData(liverRawData, no.peaks, no.replicates, threshold)


###################################################
### chunk number 7: difference
###################################################
#line 360 "clippda.Rnw"
setdiff(unique(liverRawData$SampleTag),unique(liverdata$SampleTag))
setdiff(unique(Data$SampleTag),unique(liverdata$SampleTag))


###################################################
### chunk number 8: spectrumFilter
###################################################
#line 368 "clippda.Rnw"
TAGS <- spectrumFilter(Data,threshold,no.peaks)$SampleTag
NewRawData2 <- Data[Data$SampleTag %in% TAGS,]
dim(Data)
dim(liverdata)
dim(NewRawData2)


###################################################
### chunk number 9: no.replicates
###################################################
#line 383 "clippda.Rnw"
length(liverRawData[liverRawData$SampleTag == 25,]$Intensity)/no.peaks
length(liverRawData[liverRawData$SampleTag == 40,]$Intensity)/no.peaks


###################################################
### chunk number 10: coherencepeaks
###################################################
#line 390 "clippda.Rnw"
Mat1 <- matrix(liverRawData[liverRawData$SampleTag == 25,]$Intensity,53,3)
Mat2 <-matrix(liverRawData[liverRawData$SampleTag == 40,]$Intensity,53,4)
cor(log2(Mat1))
cor(log2(Mat2))


###################################################
### chunk number 11: coherencepeaks
###################################################
#line 402 "clippda.Rnw"
Mat1 <- matrix(liverRawData[liverRawData$SampleTag == 25,]$Intensity,53,3)
Mat2 <-matrix(liverRawData[liverRawData$SampleTag == 40,]$Intensity,53,4)
sort(mostSimilarTwo(cor(log2(Mat1))))
sort(mostSimilarTwo(cor(log2(Mat2))))


###################################################
### chunk number 12: confirmpreprocessing
###################################################
#line 414 "clippda.Rnw"
names(NewRawData2)
dim(NewRawData2)
names(liverdata)
dim(liverdata)
setdiff(NewRawData2$SampleTag,liverdata$SampleTag)
setdiff(liverdata$SampleTag,NewRawData2$SampleTag)
summary(NewRawData2$Intensity)
summary(liverdata$Intensity)


###################################################
### chunk number 13: sampleClusteredData
###################################################
#line 431 "clippda.Rnw"
JUNK_DATA <- sampleClusteredData(NewRawData2,no.peaks)
head(JUNK_DATA)[,1:5] 


###################################################
### chunk number 14: column1
###################################################
#line 439 "clippda.Rnw"
as.vector(t(matrix(liverdata[liverdata$SampleTag %in% 156,]$Intensity,53,2))[,1:5])
length(as.vector(t(matrix(liverdata[liverdata$SampleTag %in% 156,]$Intensity,53,2))))

as.vector(t(matrix(NewRawData2[NewRawData2$SampleTag %in% 156,]$Intensity,53,2))[,1:5])
length(as.vector(t(matrix(NewRawData2[NewRawData2$SampleTag %in% 156,]$Intensity,53,2))))


###################################################
### chunk number 15: createClassObject
###################################################
#line 481 "clippda.Rnw"
OBJECT=new("aclinicalProteomicsData")

OBJECT@rawSELDIdata=as.matrix(NewRawData2) #OBJECT@rawSELDIdata=as.matrix(liverdata)

OBJECT@covariates=c("tumor" ,    "sex")

OBJECT@phenotypicData=as.matrix(liver_pheno)

OBJECT@variableClass=c('numeric','factor','factor')

OBJECT@no.peaks=no.peaks

OBJECT



###################################################
### chunk number 16: ExtractComponetsOfeSet
###################################################
#line 514 "clippda.Rnw"
head(proteomicsExprsData(OBJECT))

head(proteomicspData(OBJECT))


###################################################
### chunk number 17: biologicalParameters
###################################################
#line 557 "clippda.Rnw"
intraclasscorr  <-  0.60 
signifcut <- 0.05  
Data=OBJECT

sampleSizeParameters(Data, intraclasscorr, signifcut)

Z <- as.vector(fisherInformation(Data)[2,2])/2
Z 
sampleSize(Data, intraclasscorr, signifcut)


###################################################
### chunk number 18: contourplot
###################################################
#line 604 "clippda.Rnw"
m <- 2
DIFF <- seq(0.1,0.50,0.01) 
VAR <- seq(0.2,4,0.1)
beta <- c(0.90,0.80,0.70)
alpha <-  1 - c(0.001, 0.01,0.05)/2
Corr <- c(0.70,0.90) 
Z <- 2.4   
Indicator <- 1 
observedPara <- c(1,0.4) #the variance you computed from pilot data
#observedPara <- data.frame(var=c(0.7,0.5,1.5),diFF=c(0.37,0.33,0.43))
sampleSizeContourPlots(Z,m,DIFF,VAR,beta,alpha,observedPara,Indicator)


###################################################
### chunk number 19: contourplot
###################################################
#line 621 "clippda.Rnw"
observedVAR=1 
observedDIFF=0.4 


###################################################
### chunk number 20: scatterplot
###################################################
#line 643 "clippda.Rnw"
Z <- 2.460018
m <- 2
DIFF <- seq(0.1,0.50,0.01) 
VAR <- seq(0.2,4,0.1)
beta <- c(0.90,0.80,0.70)
alpha  <-  1 - c(0.001, 0.01,0.05)/2
observedDIFF  <-  0.4
observedVAR  <-  1.0
observedSampleSize  <-  80
Indicator  <-  1 
Angle  <-  60    
sampleSize3DscatterPlots(Z,m,DIFF,VAR,beta,alpha,observedDIFF,observedVAR,observedSampleSize,Angle,Indicator)


